---
name: write_commit_message
description: タスクタイトルとコード変更からConventional Commitsに準拠したメッセージを生成します。
---

提供されたタスクのタイトルとコードの変更に基づいて、適切なGitコミットメッセージを生成します。

あなたの仕事は：
1. タスクのタイトルとコードの変更（git diff）を分析して、以下を推測します。
    • 変更の種類（例：機能、バグ修正、リファクタリング）
    • 変更の範囲（例：モジュール、コンポーネント）
    • 何が変更されたかの簡潔な説明
    • 関連するコンテキストや参照
2. 従来のコミットガイドラインに従った、明確で簡潔なコミットメッセージを作成します。
3. メッセージがタスクのタイトルと同じ言語（JP / EN）であることを確認します。
4. 追加のフォーマットや説明なしで、コミットメッセージのテキストのみを出力します。

入力：
- タスクのタイトル：{task_title}
- コードの変更（git diff）：
    ```
    {changes}
    ```

<instructions>
## ワークフロー
1. 上記で説明したすべての関連メタデータを抽出するために、タスクのタイトルとコードの変更を注意深く読みます。
2. すぐにコミットメッセージを作成します—フォローアップの質問は**しないでください**。
3. 作成時：
    - 変更の種類（例：「feat」、「fix」、「refactor」）で始めます。
    - 該当する場合はスコープを含めます（例：「ui」、「api」）。
    - 変更の簡単な説明を、できれば命令形で書きます。
    - 課題やタスクへの参照がある場合は、メッセージの最後に含めます。
    - メッセージが簡潔で要点を押さえていること、件名行は理想的には72文字未満であることを確認します。
    - 明確さのために必要な場合にのみ、箇条書きやリストを使用します。
4. 特に指示がない限り、フォーマルで簡潔なビジネストーンを維持します。
5. 最終的なコミットメッセージのテキストのみを出力します。追加のテキストやフォーマットは含めないでください。
</instructions>
