---
name: write_pull_request_description
description: チケット情報・差分・コミットとテンプレートからPR説明を生成します。
---

提供されたチケット情報、コードの変更、およびテンプレート形式に基づいて、適切なプルリクエストの説明を生成します。

あなたの仕事は：
1. チケット情報（URL、タイトル、説明）を分析して、コンテキストと要件を理解します。
2. コードの変更（git diff）とコミットコメントを確認して、何が実装されたかを理解します。
3. 提供されたプルリクエストテンプレートの形式に正確に従います。
4. 以下を含む包括的な説明を生成します。
    • 行われた変更の概要
    • 元のチケットへの参照
    • コードの変更に基づく技術的な詳細
    • 関連するテスト情報や注意事項
5. 説明がチケットのタイトルと同じ言語（JP / EN）であることを確認します。
6. フォーマットされたプルリクエストの説明テキストのみを出力し、追加のフォーマットや説明は付けません。

入力：
- チケットURL：{ticket_url}
- チケットタイトル：{ticket_title}
- チケットの説明：{ticket_description}
- コードの変更（git diff）：
    ```
    {git_diff}
    ```
- コミットコメント：{commit_comments}
- プルリクエストテンプレート：
    ```
    {pr_template}
    ```

<instructions>
## ワークフロー
1. 提供されたすべての入力を注意深く読み、変更の完全なコンテキストを理解します。
2. プルリクエストテンプレートの形式を分析し、必要なすべてのセクションを特定します。
3. すぐにプルリクエストの説明を作成します—フォローアップの質問は**しないでください**。
4. 作成時：
    - PRテンプレートで指定された正確な構造と形式に従います。
    - すべてのテンプレートセクションを入力からの関連情報で埋めます。
    - 適切な場所にチケットURLを参照として含めます。
    - git diffに基づいて技術的な変更を要約します。
    - コミットコメントからの重要な実装の詳細を記載します。
    - コードレビューに適した明確でプロフェッショナルな言語を使用します。
    - チケットのタイトルで使用されている言語との一貫性を維持します。
5. すべてのテンプレートプレースホルダーが実際のコンテンツに置き換えられていることを確認します。
6. テンプレート形式に従った最終的なプルリクエストの説明テキストのみを出力します。
</instructions>
