/*
 * Decompiled with CFR 0.152.
 */
package com.certora.evmverifier.cvl;

import com.certora.evmverifier.cvl.Cmd;
import com.certora.evmverifier.cvl.Exp;
import com.certora.evmverifier.cvl.KotlinizeResult;
import spec.TypeResolver;
import spec.cvlast.CVLCmd;
import spec.cvlast.CVLExp;
import spec.cvlast.CVLRange;
import spec.cvlast.CVLScope;
import spec.cvlast.typechecker.CVLError;
import utils.CollectingResult;

public class AssertCmd
extends Cmd {
    public Exp exp;
    public String description;

    public AssertCmd(CVLRange cvlRange, Exp _exp, String _description) {
        super(cvlRange);
        if (_exp == null) {
            throw new RuntimeException("Assert command must have an expression");
        }
        this.exp = _exp;
        this.description = _description;
    }

    public String toString() {
        return String.format(this.exp.toString(), this.description);
    }

    @Override
    public CollectingResult<CVLCmd, CVLError> kotlinize(TypeResolver resolver, CVLScope scope) {
        return KotlinizeResult.map(this.exp.kotlinize(resolver, scope), exp -> new CVLCmd.Simple.Assert(this.cvlRange, (CVLExp)exp, this.description, scope, false));
    }
}

