/*
 * Decompiled with CFR 0.152.
 */
package datastructures;

import datastructures.stdcollections.ListsKt;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u001e\n\u0002\b\u0007\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\b\u0012\u0004\u0012\u0002H\u00010\u00022\u00020\u0003B\u001d\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\u0006B\u000f\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0007B+\b\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\u0002\u0010\tJ\u0016\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0003\u00a2\u0006\u0002\u0010\u0016J\u0017\u0010\u0017\u001a\u00020\u00142\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00028\u00000\u0019H\u0096\u0001J\u0016\u0010\u001a\u001a\u00028\u00002\u0006\u0010\u001b\u001a\u00020\u000eH\u0096\u0003\u00a2\u0006\u0002\u0010\u001cJ\u0016\u0010\u001d\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010\u001eJ\t\u0010\u001f\u001a\u00020\u0014H\u0096\u0001J\u000f\u0010 \u001a\b\u0012\u0004\u0012\u00028\u00000!H\u0096\u0003J\u0016\u0010\"\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00028\u0000H\u0096\u0001\u00a2\u0006\u0002\u0010\u001eJ\u000f\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$H\u0096\u0001J\u0017\u0010#\u001a\b\u0012\u0004\u0012\u00028\u00000$2\u0006\u0010\u001b\u001a\u00020\u000eH\u0096\u0001J&\u0010%\u001a\b\u0012\u0004\u0012\u0002H&0\u0000\"\u0004\b\u0001\u0010&2\u0012\u0010'\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H&0(J,\u0010)\u001a\b\u0012\u0004\u0012\u0002H&0\u0000\"\u0004\b\u0001\u0010&2\u0018\u0010'\u001a\u0014\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u0002H&0*J\u001f\u0010+\u001a\b\u0012\u0004\u0012\u00028\u00000\u00022\u0006\u0010,\u001a\u00020\u000e2\u0006\u0010-\u001a\u00020\u000eH\u0096\u0001J\b\u0010.\u001a\u00020/H\u0016R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0012\u0010\r\u001a\u00020\u000eX\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0017\u0010\u0005\u001a\b\u0012\u0004\u0012\u00028\u00000\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u00060"}, d2={"Ldatastructures/NonEmptyList;", "T", "", "Ljava/io/Serializable;", "head", "tail", "(Ljava/lang/Object;Ljava/util/List;)V", "(Ljava/lang/Object;)V", "backing", "(Ljava/lang/Object;Ljava/util/List;Ljava/util/List;)V", "getHead", "()Ljava/lang/Object;", "Ljava/lang/Object;", "size", "", "getSize", "()I", "getTail", "()Ljava/util/List;", "contains", "", "element", "(Ljava/lang/Object;)Z", "containsAll", "elements", "", "get", "index", "(I)Ljava/lang/Object;", "indexOf", "(Ljava/lang/Object;)I", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "map", "R", "transform", "Lkotlin/Function1;", "mapIndexed", "Lkotlin/Function2;", "subList", "fromIndex", "toIndex", "toString", "", "GeneralUtils"})
@SourceDebugExtension(value={"SMAP\nNonEmptyList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NonEmptyList.kt\ndatastructures/NonEmptyList\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,46:1\n1549#2:47\n1620#2,3:48\n1559#2:51\n1590#2,4:52\n*S KotlinDebug\n*F\n+ 1 NonEmptyList.kt\ndatastructures/NonEmptyList\n*L\n21#1:47\n21#1:48,3\n32#1:51\n32#1:52,4\n*E\n"})
public final class NonEmptyList<T>
implements List<T>,
Serializable,
KMappedMarker {
    private final T head;
    @NotNull
    private final List<T> tail;
    @NotNull
    private final List<T> backing;

    public NonEmptyList(T head, @NotNull List<? extends T> tail, @NotNull List<? extends T> backing) {
        Intrinsics.checkNotNullParameter(tail, "tail");
        Intrinsics.checkNotNullParameter(backing, "backing");
        this.head = head;
        this.tail = tail;
        this.backing = backing;
    }

    public final T getHead() {
        return this.head;
    }

    @NotNull
    public final List<T> getTail() {
        return this.tail;
    }

    public int getSize() {
        return this.backing.size();
    }

    @Override
    public boolean contains(Object element) {
        return this.backing.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        return this.backing.containsAll(elements);
    }

    @Override
    public T get(int index) {
        return this.backing.get(index);
    }

    @Override
    public int indexOf(Object element) {
        return this.backing.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.backing.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<T> iterator() {
        return this.backing.iterator();
    }

    @Override
    public int lastIndexOf(Object element) {
        return this.backing.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator() {
        return this.backing.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<T> listIterator(int index) {
        return this.backing.listIterator(index);
    }

    @Override
    @NotNull
    public List<T> subList(int fromIndex, int toIndex) {
        return this.backing.subList(fromIndex, toIndex);
    }

    public NonEmptyList(T head, @NotNull List<? extends T> tail) {
        Intrinsics.checkNotNullParameter(tail, "tail");
        this((T)head, tail, ListsKt.plus((Collection)ListsKt.listOf(head), (Iterable)tail));
    }

    public NonEmptyList(T head) {
        this(head, ListsKt.emptyList(), ListsKt.listOf(head));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <R> NonEmptyList<R> map(@NotNull Function1<? super T, ? extends R> transform2) {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Iterable iterable = this.tail;
        R r = transform2.invoke(this.head);
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            destination$iv$iv.add(transform2.invoke(item$iv$iv));
        }
        List list = (List)destination$iv$iv;
        R r2 = r;
        return new NonEmptyList<R>(r2, list);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final <R> NonEmptyList<R> mapIndexed(@NotNull Function2<? super Integer, ? super T, ? extends R> transform2) {
        void $this$mapIndexedTo$iv$iv;
        void $this$mapIndexed$iv;
        Intrinsics.checkNotNullParameter(transform2, "transform");
        Iterable iterable = this.tail;
        R r = transform2.invoke(0, this.head);
        boolean $i$f$mapIndexed = false;
        void var4_5 = $this$mapIndexed$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$mapIndexed$iv, 10));
        boolean $i$f$mapIndexedTo = false;
        int index$iv$iv = 0;
        for (Object item$iv$iv : $this$mapIndexedTo$iv$iv) {
            void elem;
            void idx;
            int n;
            if ((n = index$iv$iv++) < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Object t = item$iv$iv;
            int n2 = n;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(transform2.invoke((int)(idx + true), elem));
        }
        List list = (List)destination$iv$iv;
        R r2 = r;
        return new NonEmptyList<R>(r2, list);
    }

    @NotNull
    public String toString() {
        return this.backing.toString();
    }

    @Override
    public boolean add(T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends T> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T remove(int index) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> elements) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public T set(int index, T element) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super T> p0) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Intrinsics.checkNotNullParameter(array, "array");
        return CollectionToArray.toArray(this, array);
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray(this);
    }
}

