/*
 * Decompiled with CFR 0.152.
 */
package bridge;

import bridge.CertoraConf;
import bridge.CertoraConfKt;
import bridge.SingleDeployedContract;
import bridge.VerificationQuery;
import bridge.VerificationQueryType;
import java.io.Closeable;
import java.io.File;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.StringCompanionObject;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import kotlinx.serialization.builtins.BuiltinSerializersKt;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonKt;
import log.ArtifactManagerFactory;
import org.jetbrains.annotations.NotNull;
import utils.ArtifactFileUtils;
import utils.CertoraFileCache;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lbridge/CertoraConf;", "", "()V", "Companion", "Shared"})
public final class CertoraConf {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J,\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\n\u001a\u00020\u0006J\"\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00060\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0006J\u001e\u0010\u0010\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\fj\u0002`\u00122\u0006\u0010\u0013\u001a\u00020\u0006J \u0010\u0014\u001a\u0012\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00110\fj\u0002`\u00122\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J/\u0010\u0016\u001a\u0002H\u0017\"\u0004\b\u0000\u0010\u00172\u0006\u0010\u0018\u001a\u00020\u00062\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u0002H\u00170\u001aH\u0002\u00a2\u0006\u0002\u0010\u001bJ\u0018\u0010\u001c\u001a\f\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001f2\u0006\u0010\u0013\u001a\u00020\u0006J\u001a\u0010 \u001a\f\u0012\u0004\u0012\u00020\u001e0\u001dj\u0002`\u001f2\u0006\u0010\u0015\u001a\u00020\u0006H\u0002J\u0014\u0010!\u001a\u00020\u00042\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020\u001e0\u001d\u00a8\u0006#"}, d2={"Lbridge/CertoraConf$Companion;", "", "()V", "copyInputs", "", "buildFilename", "", "verificationFilename", "cfgFileNames", "", "metadataFilename", "getConfigFileNameToContentMap", "", "jsonConfigElem", "Lkotlinx/serialization/json/JsonElement;", "certoraCfgDir", "loadBuildConf", "Lbridge/SingleDeployedContract;", "Lbridge/BuildConf;", "filename", "loadBuildConfFromJsonStr", "jsonStr", "loadConf", "C", "fileName", "loader", "Lkotlin/Function1;", "(Ljava/lang/String;Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "loadVerificationConf", "", "Lbridge/VerificationQuery;", "Lbridge/VerificationConf;", "loadVerificationConfFromJsonStr", "validateVerificationQueries", "verificationQueries", "Shared"})
    public static final class Companion {
        private Companion() {
        }

        private final Map<String, SingleDeployedContract> loadBuildConfFromJsonStr(String jsonStr) {
            return (Map)JsonKt.Json$default(null, loadBuildConfFromJsonStr.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.MapSerializer(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), SingleDeployedContract.Companion.serializer()), jsonStr);
        }

        private final List<VerificationQuery> loadVerificationConfFromJsonStr(String jsonStr) {
            List verificationQueries2 = (List)JsonKt.Json$default(null, loadVerificationConfFromJsonStr.verificationQueries.1.INSTANCE, 1, null).decodeFromString(BuiltinSerializersKt.ListSerializer(VerificationQuery.Companion.serializer()), jsonStr);
            this.validateVerificationQueries(verificationQueries2);
            return verificationQueries2;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private final <C> C loadConf(String fileName, Function1<? super String, ? extends C> loader) {
            String string2;
            System.out.println((Object)("load conf tried to open file " + fileName));
            Object object = CertoraFileCache.INSTANCE.getContentReader(fileName);
            Throwable throwable = null;
            try {
                Reader it = (Reader)object;
                boolean bl = false;
                string2 = TextStreamsKt.readText(it);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, throwable);
            }
            object = string2;
            return loader.invoke((String)object);
        }

        @NotNull
        public final List<VerificationQuery> loadVerificationConf(@NotNull String filename) {
            Intrinsics.checkNotNullParameter(filename, "filename");
            return (List)this.loadConf(filename, (Function1)new Function1<String, List<? extends VerificationQuery>>((Object)this){

                @NotNull
                public final List<VerificationQuery> invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return bridge.CertoraConf$Companion.access$loadVerificationConfFromJsonStr((Companion)this.receiver, p0);
                }
            });
        }

        @NotNull
        public final Map<String, SingleDeployedContract> loadBuildConf(@NotNull String filename) {
            Intrinsics.checkNotNullParameter(filename, "filename");
            return (Map)this.loadConf(filename, (Function1)new Function1<String, Map<String, ? extends SingleDeployedContract>>((Object)this){

                @NotNull
                public final Map<String, SingleDeployedContract> invoke(@NotNull String p0) {
                    Intrinsics.checkNotNullParameter(p0, "p0");
                    return bridge.CertoraConf$Companion.access$loadBuildConfFromJsonStr((Companion)this.receiver, p0);
                }
            });
        }

        /*
         * WARNING - void declaration
         */
        @NotNull
        public final Map<String, String> getConfigFileNameToContentMap(@NotNull JsonElement jsonConfigElem, @NotNull String certoraCfgDir) {
            void $this$associateTo$iv$iv;
            Intrinsics.checkNotNullParameter(jsonConfigElem, "jsonConfigElem");
            Intrinsics.checkNotNullParameter(certoraCfgDir, "certoraCfgDir");
            Iterable $this$associate$iv = JsonElementKt.getJsonObject(jsonConfigElem).entrySet();
            boolean $i$f$associate = false;
            int capacity$iv = RangesKt.coerceAtLeast(MapsKt.mapCapacity(CollectionsKt.collectionSizeOrDefault($this$associate$iv, 10)), 16);
            Iterable iterable = $this$associate$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateTo = false;
            for (Object element$iv$iv : $this$associateTo$iv$iv) {
                Map map2 = destination$iv$iv;
                Map.Entry it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                String cfgFilePath = (String)it.getKey();
                String fileName = ArtifactFileUtils.INSTANCE.getRelativeFileName(cfgFilePath, certoraCfgDir);
                String contents2 = (String)JsonKt.Json$default(null, getConfigFileNameToContentMap.1.contents.1.INSTANCE, 1, null).decodeFromJsonElement(BuiltinSerializersKt.serializer(StringCompanionObject.INSTANCE), (JsonElement)it.getValue());
                Pair<String, String> pair = TuplesKt.to(fileName, contents2);
                map2.put(pair.getFirst(), pair.getSecond());
            }
            return destination$iv$iv;
        }

        /*
         * WARNING - void declaration
         */
        public final void validateVerificationQueries(@NotNull List<VerificationQuery> verificationQueries2) {
            Intrinsics.checkNotNullParameter(verificationQueries2, "verificationQueries");
            Iterable $this$forEach$iv = verificationQueries2;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                void $this$mapTo$iv$iv;
                VerificationQuery vq = (VerificationQuery)element$iv;
                boolean bl = false;
                VerificationQueryType[] $this$map$iv = VerificationQueryType.values();
                boolean $i$f$map = false;
                VerificationQueryType[] verificationQueryTypeArray = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void it;
                    void item$iv$iv;
                    void var16_16 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv;
                    boolean bl2 = false;
                    collection.add(it.toString());
                }
                if (!CollectionsKt.toSet((List)destination$iv$iv).contains(vq.getType())) {
                    CertoraConfKt.access$getLogger$p().error("Invalid type " + vq.getType());
                }
                if (!StringsKt.isBlank(vq.getPrimary_contract())) continue;
                CertoraConfKt.access$getLogger$p().error("Primary contract for verification query " + vq + " is blank");
            }
        }

        public final void copyInputs(@NotNull String buildFilename, @NotNull String verificationFilename, @NotNull Set<String> cfgFileNames, @NotNull String metadataFilename) {
            Intrinsics.checkNotNullParameter(buildFilename, "buildFilename");
            Intrinsics.checkNotNullParameter(verificationFilename, "verificationFilename");
            Intrinsics.checkNotNullParameter(cfgFileNames, "cfgFileNames");
            Intrinsics.checkNotNullParameter(metadataFilename, "metadataFilename");
            ArtifactManagerFactory.INSTANCE.invoke().backup(buildFilename, bridge.CertoraConf$Companion.copyInputs$getBackupFileName(bridge.CertoraConf$Companion.copyInputs$trimPath(buildFilename)));
            ArtifactManagerFactory.INSTANCE.invoke().backup(verificationFilename, bridge.CertoraConf$Companion.copyInputs$getBackupFileName(bridge.CertoraConf$Companion.copyInputs$trimPath(verificationFilename)));
            Iterable $this$forEach$iv = cfgFileNames;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                String it = (String)element$iv;
                boolean bl = false;
                ArtifactManagerFactory.INSTANCE.invoke().backup(it, bridge.CertoraConf$Companion.copyInputs$getBackupFileName(it));
            }
            if (CertoraFileCache.INSTANCE.exists(metadataFilename)) {
                ArtifactManagerFactory.INSTANCE.invoke().backup(metadataFilename, bridge.CertoraConf$Companion.copyInputs$getBackupFileName(bridge.CertoraConf$Companion.copyInputs$trimPath(metadataFilename)));
            }
        }

        private static final String copyInputs$getBackupFileName(String fileName) {
            return ArtifactManagerFactory.INSTANCE.invoke().getInputsDir() + File.separator + fileName;
        }

        private static final String copyInputs$trimPath(String fileName) {
            return ArtifactFileUtils.INSTANCE.getNameFromPath(fileName);
        }

        public static final /* synthetic */ List access$loadVerificationConfFromJsonStr(Companion $this, String jsonStr) {
            return $this.loadVerificationConfFromJsonStr(jsonStr);
        }

        public static final /* synthetic */ Map access$loadBuildConfFromJsonStr(Companion $this, String jsonStr) {
            return $this.loadBuildConfFromJsonStr(jsonStr);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

