# Lightbulb By Example

::::{grid} 1 2 2 2
:gutter: 3

:::{grid-item-card} {material-outlined}`flag;2em` Preface
:columns: 12
:link: by-examples/000_preface
:link-type: doc

Introduction to Lightbulb - project setup and first steps.
:::

:::{grid-item-card} {material-outlined}`keyboard_command_key;2em` Commands
:link: by-examples/010_commands
:link-type: doc

What is a command and how to create them.
:::

:::{grid-item-card} {material-outlined}`settings;2em` Options
:link: by-examples/020_options
:link-type: doc

Taking user input for commands and how to use it.
:::

:::{grid-item-card} {material-outlined}`menu_open;2em` Context Menus
:link: by-examples/030_context_menus
:link-type: doc

What are context menu commands - how and why to use them.
:::

:::{grid-item-card} {material-outlined}`groups;2em` Groups
:link: by-examples/040_groups
:link-type: doc

Why use a command group, and potential pitfalls using them.
:::

:::{grid-item-card} {material-outlined}`link;2em` Dependencies
:link: by-examples/050_dependencies
:link-type: doc

What is dependency injection - accessing objects wherever you need them without global state.
:::

:::{grid-item-card} {material-outlined}`phishing;2em` Hooks
:link: by-examples/060_hooks
:link-type: doc

Modifying command behaviour and conditionally blocking execution.
:::

:::{grid-item-card} {material-outlined}`warning;2em` Error Handling
:link: by-examples/065_error_handling
:link-type: doc

Catching errors and how to display them to the user.
:::

:::{grid-item-card} {material-outlined}`power;2em` Extensions
:link: by-examples/070_extensions
:link-type: doc

Splitting your application into multiple files - how extensions enable this.
:::

:::{grid-item-card} {material-outlined}`keyboard_alt;2em` Autocomplete
:link: by-examples/080_autocomplete
:link-type: doc

Dynamically suggesting option values to your users.
:::

:::{grid-item-card} {material-outlined}`translate;2em` Localization
:link: by-examples/090_localization
:link-type: doc

Catering to the international audience - how to translate command names and more.
:::

:::{grid-item-card} {material-outlined}`menu_book;2em` Appendix
:columns: 12
:link: by-examples/100_appendix
:link-type: doc

Further reading; more advanced concepts and techniques.
:::
::::

:::{toctree}
:hidden:
:maxdepth: 2

by-examples/000_preface
by-examples/010_commands
by-examples/020_options
by-examples/030_context_menus
by-examples/040_groups
by-examples/050_dependencies
by-examples/060_hooks
by-examples/065_error_handling
by-examples/070_extensions
by-examples/080_autocomplete
by-examples/090_localization
by-examples/100_appendix
:::
