<!-- This file is automatically generated. Do not edit manually. -->
(v3-changelog)=
# Version 3 Changelog

Below are all the changelogs for the new versions of hikari-lightbulb (version 3.0.0 to present).

----

<!-- next-changelog -->

## v3.1.3 (2025-08-24)
### Features

- Add a `lb_` prefix to component custom IDs generated by Lightbulb. ([#593](https://github.com/tandemdude/hikari-lightbulb/issues/593))

----

## v3.1.2 (2025-08-10)
### Features

- Add `lightbulb.utils.to_choices()` helper for converting various values to `Choice` sequences.

### Bugfixes

- Fix unloading extensions still allowing subcommands to be invoked. ([#587](https://github.com/tandemdude/hikari-lightbulb/issues/587))

----

## v3.1.1 (2025-07-30)
### Bugfixes

- Fix commands no longer being invokable when their extensions are reloaded.

----

## v3.1.0 (2025-07-23)
### Features

- Implement option converters, allowing conversion of option values to custom types. ([#574](https://github.com/tandemdude/hikari-lightbulb/issues/574))

----

## v3.0.3 (2025-07-18)
### Bugfixes

- Add `typing-extensions` as a dependency.

----

## v3.0.2 (2025-07-14)
### Features

- Expose `Context.initial_response_sent` and `Client.safe_create_task` ([#578](https://github.com/tandemdude/hikari-lightbulb/issues/578))
- Allow modals to return values from the `on_submit` handler, which will in turn be returned from the call to `modal.attach`. ([#581](https://github.com/tandemdude/hikari-lightbulb/issues/581))

----

## v3.0.1 (2025-06-09)
### Bugfixes

- Fix memory leak when a handler errors before submitting an initial response within REST-based interactions.

### Miscellaneous

- Silence TimeoutError from being logged when using persistent menus with timeouts enabled.

----

## v3.0.0 (2025-06-06)
### Features

- This is the first V3 stable release! From now on the number of breaking changes will be minimal and the API is considered stable. Any breaking changes will be preceded by a suitably long deprecation period.

----

## v3.0.0a26 (2025-06-01)
### Breaking Changes

- - Removed `wait` kwarg from the `Menu.attach` method - `wait=True` is now the only supported behaviour. For persistent menus, you should use the `Menu.attach_persistent` method instead.
  - `MenuHandle` is no longer awaitable. You should await the `.wait()` method instead.

  ([#569](https://github.com/tandemdude/hikari-lightbulb/issues/569))

### Features

- Add `Menu.attach_persistent` method to replace previous waiter functionality. ([#569](https://github.com/tandemdude/hikari-lightbulb/issues/569))

### Miscellaneous

- Optimised the number of asyncio tasks created when using menus to improve performance at a large scale. ([#569](https://github.com/tandemdude/hikari-lightbulb/issues/569))

----

## v3.0.0a25 (2025-05-28)
### Features

- Add `permit_admin` argument to builtin permission check hooks.
- Add `sync_commands` flag when constructing the Client instance.

----

## v3.0.0a24 (2025-05-20)
### Bugfixes

- Fix DI context not propagating correctly for menu callbacks where it would be expected to work. ([#563](https://github.com/tandemdude/hikari-lightbulb/issues/563))

### Miscellaneous

- Remove maximum version limit for `linkd` and `confspec`.

----

## v3.0.0a23 (2025-05-17)
### Features

- Add `extension` attribute to `CommandData` and `Group` classes.

### Miscellaneous

- Switch to `confspec` to provide `lightbulb.config` functionality.

----

## v3.0.0a22 (2025-05-08)
### Bugfixes

- Fix cooldown prefabs failing to register the appropriate `CommandCooldown` dependency during invocation.

----

## v3.0.0a21 (2025-05-05)
### Features

- Add `configuration` submodule for parsing configuration files to msgspec Structs, including environment variable interpolation. ([#557](https://github.com/tandemdude/hikari-lightbulb/issues/557))

----

## v3.0.0a20 (2025-05-03)
### Bugfixes

- Fix handling of REST interactions erroring when trying to make an initial response. ([#556](https://github.com/tandemdude/hikari-lightbulb/issues/556))

----

## v3.0.0a19 (2025-04-27)
### Miscellaneous

- Bump Hikari version support to 2.3.1.

----

## v3.0.0a18 (2025-04-14)
### Breaking Changes

- Migrate to using [`linkd`](https://github.com/tandemdude/linkd) for dependency injection instead of including the framework within Lightbulb.

  - All DI classes have been removed and should now be imported from `linkd` instead. A few members are vendored through
    Lightbulb to prevent too many breaking code changes.

  **Vendored members:**
  The following members are still accessible through the `lightbulb.di` namespace
  - `DI_ENABLED`, `INJECTED`
  - `If`, `Try`, `with_di`
  - `CircularDependencyException`, `ContainerClosedException`, `DependencyInjectionException`, `DependencyNotSatisfiableException`
  - `DefaultContainer`

  The following members are implemented in Lightbulb due to them being too specialised to include directly in `linkd`
  - `CommandContainer`, `AutocompleteContainer`, `ListenerContainer`, `TaskContainer`
  - `Contexts`

  ([#543](https://github.com/tandemdude/hikari-lightbulb/issues/543))

### Bugfixes

- Fixed registering groups failing when using `integration_types` or `contexts`.

----

## v3.0.0a17 (2025-04-06)
### Breaking Changes

- Removed `RestContext` and `RestAutocompleteContext`. If you were not explicitly using these classes you will not be affected.

### Features

- Added support for sending polls within command and component interaction responses.

----

## v3.0.0a16 (2025-03-21)
### Features

- Implement user installable application commands. ([#536](https://github.com/tandemdude/hikari-lightbulb/issues/536))

----

## v3.0.0a15 (2024-11-22)
### Features

- `Menu.attach` now returns an instance of `MenuHandle` instead of a generic awaitable - allowing the menu to be stopped without using a `MenuContext` or timeout.

### Bugfixes

- Changed logging level for exceptions happening in tasks from `WARNING` to `ERROR`. ([#486](https://github.com/tandemdude/hikari-lightbulb/issues/486))
- Fix sporadic attribute error when using `self.previous_row()` within a component menu class.

----

## v3.0.0a14 (2024-10-30)
### Bugfixes

- Fixed lightbulb.attachment option, which previously compiled to hikari.OptionType.MENTIONABLE ([#472](https://github.com/tandemdude/hikari-lightbulb/issues/472))

### Miscellaneous

- Add support for Python 3.13

----

## v3.0.0a13 (2024-09-30)
### Features

- - Implement injection for union dependencies using `Foo | Bar`. If any of the requested dependencies are not registered, it will fall back to the next in the union.
  - Implement injection for optional dependencies using `Foo | None`. If all the requested dependencies are not registered, it will fall back to `None`.
  - Implement injection 'meta annotations' (`Try[]` and `If[]`) allowing modifying of the fall-back behaviour.

  ([#454](https://github.com/tandemdude/hikari-lightbulb/issues/454))
- Add `name` argument to the `hook()` decorator and `name` attribute to `ExecutionHook`.
- Prefab cooldown hooks now register an instance of `CommandCooldown` as a dependency when they are executed.

### Bugfixes

- Fix `KeyError` preventing error handlers being loaded from extensions.
- Fix menu task exceptions being logged even if they were raised previously.

----

## v3.0.0a12 (2024-08-30)
### Breaking Changes

- `Menu.attach` now has the `wait` parameter set to `True` by default, and the `timeout` parameter set to `30s` by default.

### Bugfixes

- Fix DI creating a new default container every time instead of reusing the existing one.
- Fixed DI failing when trying to create dependencies with more complex dependency trees.

----

## v3.0.0a11 (2024-08-29)
### Bugfixes

- - Improved container hierarchical dependency resolution process.
  - Add significantly more `DEBUG` logging throughout the DI pipeline.
  - `DependencyInjectionManager.enter_context` now needs to be called for every context you wish to enter; it will no longer enter the default context automatically.
  - `DependencyInjectionManager.enter_context` now searches the existing container hierarchy to find an existing container for the passed context before trying to create a new one.
  - `DependencyInjectionManager.enter_context` now returns a no-op container implementation instead of `None` if DI is disabled globally.

  ([#449](https://github.com/tandemdude/hikari-lightbulb/issues/449))
- Fix default injection container being closed when explicitly entering the `DEFAULT` DI context.

### Features

- Add `has_roles` check to the `prefab` subpackage. ([#447](https://github.com/tandemdude/hikari-lightbulb/issues/447))
- Add `set_timeout` method to `MenuContext`. ([#448](https://github.com/tandemdude/hikari-lightbulb/issues/448))
- Add `client` attribute to `ModalContext` and `MenuContext`.
- Add `enable_all_components` and `disable_all_components` methods to `Menu`.
- Add `registered_commands` and `invokable_commands` properties to `Client`.

----

## v3.0.0a10 (2024-08-15)
### Documentation

- Update code examples for version 3 from version 2. ([#436](https://github.com/tandemdude/hikari-lightbulb/issues/436))

### Features

- Add a component and modal handler implementation. You can use these to more easily handle the creation and execution
  of message components, as well as submitted modal forms. ([#438](https://github.com/tandemdude/hikari-lightbulb/issues/438))

### Deprecations and Removals

- The `ephemeral` argument for `Context.defer()` is now keyword-only.

----

## v3.0.0a9 (2024-08-08)
### Features

- Add `prefab` subpackage containing some simple built-in hooks. More will continue to be added.
- `utils.get_command_data()` now works for groups and subgroups.

### Miscellaneous

- Switch to using types from `collections.abc` instead of `typing` wherever possible.

----

## v3.0.0a8 (2024-07-29)
### Features

- Add `hooks` parameter to `client_from_app` - allowing commands to inherit common hooks from the client. ([#430](https://github.com/tandemdude/hikari-lightbulb/issues/430))

### Bugfixes

- Fix autocomplete callbacks not being called if the option had localization enabled.
- Fix command parameter validation failing sometimes when using long localization keys.
- Fix subcommands with localization enabled not being invoked as expected.
- Slightly improved performance of invoking nested subcommands.

### Deprecations and Removals

- - `Client.register_deferred` has been removed. You should now use `Client.register(defer_guilds=True)` instead.

  - `guilds` kwarg for `Client.register` has new semantics. Read the docstring for more information.

  ([#429](https://github.com/tandemdude/hikari-lightbulb/issues/429))
- Removed `HookFailedException`. `ExecutionPipelineFailedException` now has two attributes containing the hooks that
  failed, and the exception that caused them to fail. You may need to update your error handler to reflect this.

----

## v3.0.0a7 (2024-07-23)
### Features

- Dependency injection system has been completely rewritten to make it much more flexible and powerful. See the
  dependencies guide on the 'By Examples' page for details on the new implementation. ([#428](https://github.com/tandemdude/hikari-lightbulb/issues/428))

### Deprecations and Removals

- - Removed `lightbulb.with_di`, it has been replaced by `lightbulb.di.with_di`
  - Removed `lightbulb.INJECTED`, it has been replaced by `lightbulb.di.INJECTED`
  - Removed `Client.di.register_dependency` - see the dependencies guide for details on the replacement

  ([#428](https://github.com/tandemdude/hikari-lightbulb/issues/428))

----

## v3.0.0a6 (2024-07-18)
### Features

- Add support for unloading and atomic reloading of extensions.
- Implement repeating tasks - including uniform and cron-based triggers and support within extensions.

### Bugfixes

- Fix limit for message ID length for options name and description when using `GnuLocalizationProvider`. ([#427](https://github.com/tandemdude/hikari-lightbulb/issues/427))
- Fix localization not being supported correctly for commands using deferred guild registration.

### Deprecations and Removals

- The `unload()` method is now required to be implemented for `Loader`s.

----

## v3.0.0a5 (2024-07-13)
### Features

- Refactor `ExecutionPipelineFailedException` to make writing error handlers more intuitive.

### Bugfixes

- Fix incorrect assertion error happening sometimes when a subcommand is invoked.

----

## v3.0.0a4 (2024-07-02)
### Features

- Add `ephemeral` convenience argument to `Context.respond`.
- Add ability to localize choice names.

----

## v3.0.0a3 (2024-06-28)
### Features

- Add `PRE_INVOKE` execution step to default execution step order.
- Add ability for `Loadable.listener`s to listen for multiple event types.

### Bugfixes

- Fix not being able to access option values when their name and description are localized.

----

## v3.0.0a2 (2024-06-20)
### Features

- A [plugin](https://plugins.jetbrains.com/plugin/24669-hikari-lightbulb-support) for IntelliJ-based IDEs has been 
  released to add autocompletion and type checking support for command parameters. It supports Lightbulb from 
  this version and later. More features are planned.

### Bugfixes

- Use `interaction.registered_guild_id` when resolving command interactions to prevent issues where guild commands
  would sometimes be invoked instead of global commands. ([#426](https://github.com/tandemdude/hikari-lightbulb/issues/426))

### Improved Documentation

- Documentation has been reworked to look nicer and function better. A Lightbulb-by-example section is in-progress for
  better tutorials and explanations for users of the library.

----

## v3.0.0a1 (2024-06-09)
### Features

- Add `lightbulb.INJECTED` flag for dependency injection typing improvements ([#424](https://github.com/tandemdude/hikari-lightbulb/issues/424))
