---
ogp_description_length: 148
---

# Welcome!

![](https://img.shields.io/badge/code%20style-black-black.svg?style=flat-square) ![](https://img.shields.io/badge/pyright-checked-black?style=flat-square)

![](https://img.shields.io/pypi/v/hikari-lightbulb.svg?style=flat-square) ![](https://img.shields.io/pypi/pyversions/hikari-lightbulb?style=flat-square) ![](https://img.shields.io/github/stars/tandemdude/hikari-lightbulb?style=flat-square) ![](https://img.shields.io/github/forks/tandemdude/hikari-lightbulb?style=flat-square)

![](https://img.shields.io/github/actions/workflow/status/tandemdude/hikari-lightbulb/ci.yml?branch=master&event=push&style=flat-square&logo=github) ![](https://img.shields.io/readthedocs/hikari-lightbulb?style=flat-square) ![](https://img.shields.io/badge/License-MIT-limegreen?style=flat-square) ![](https://img.shields.io/pypi/status/hikari-lightbulb?style=flat-square)

---

## Overview

**Lightbulb** is a command handler library designed for use with [Hikari](https://github.com/hikari-py/hikari).

It aims to provide an easy-to-use interface for building commands with your bot.

Repository: [View on GitHub](https://github.com/tandemdude/hikari-lightbulb)

Docs: [View Here](https://hikari-lightbulb.readthedocs.io/)

If you need any help with this library or Hikari at any point feel free to join the [Discord Server](https://discord.gg/hikari)

If you think you have found a bug or other problem with the library, or you would like to suggest a feature,
you should submit an issue on the GitHub repository [here](https://github.com/tandemdude/hikari-lightbulb/issues).
Before doing so you should make sure you are on the latest version of the library and check to see if an issue
already exists for your bug or feature.

## IDE Plugin

Lightbulb now has a plugin for IntelliJ-based IDEs (IntelliJ, Pycharm, etc) to help improve the developer experience 
by providing autocompletion and type checking not yet supported by other tools. More features such as command 
boilerplate generation and further code inspections are planned.

You can install the plugin from the Jetbrains Marketplace within your IDE. View the plugin 
[here](https://plugins.jetbrains.com/plugin/24669-hikari-lightbulb-support).

---

:::{dropdown} Helpful Resources
:icon: question
- [Hikari Documentation](https://docs.hikari-py.dev/en/latest/)
- {doc}`Quickstart <quickstart>`
- {doc}`Lightbulb By Example <by-example>`
:::

:::{dropdown} Maintainers
:icon: git-branch
- [thomm.o (creator)](https://github.com/tandemdude)
- [nulldomain](https://github.com/null-domain)
:::

:::{dropdown} Special Thanks
:icon: heart
- [nekokatt](https://gitlab.com/nekokatt) for helping with the early stages of lightbulb and teaching me much of what I know.
- [davfsa](https://github.com/davfsa) for maintaining Hikari for all this time. Without which lightbulb could not exist.
:::

---

## Next Steps

::::{grid} 1 2 2 2
:gutter: 3

:::{grid-item-card} {material-outlined}`info;2em` Quickstart
:link: quickstart
:link-type: doc

A simple guide to help you bootstrap your first Lightbulb application.
:::

:::{grid-item-card} {material-outlined}`quiz;2em` Lightbulb By Example
:link: by-example
:link-type: doc

A series of tutorial and explanation pages to help you understand Lightbulb's basic concepts.
:::

:::{grid-item-card} {material-outlined}`code;2em` API Reference
:link: api-reference
:link-type: doc

Detailed reference documentation for Lightbulb's public API, autogenerated from the code.
:::

:::{grid-item-card} {material-outlined}`timeline;2em` Changelog
:link: changelog
:link-type: doc

A history of the past versions of Lightbulb and the changes introduced throughout.
:::
::::

:::{toctree}
:hidden:
:maxdepth: 2
quickstart
by-example
api-reference
changelog
:::

* {ref}`genindex`
