"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.HyperledgerFabricClient = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
// Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
// SPDX-License-Identifier: MIT-0
const cdk = require("aws-cdk-lib");
const ec2 = require("aws-cdk-lib/aws-ec2");
const constructs = require("constructs");
/**
 * Creates a VPC and endpoint that allows Hyperledger Fabric client to
 * interact with the Hyperledger Fabric endpoints that Amazon Managed Blockchain
 * exposes for the member and network resources.
 */
class HyperledgerFabricClient extends constructs.Construct {
    constructor(scope, id, props) {
        super(scope, id);
        // Collect metadata on the stack
        const region = cdk.Stack.of(this).region;
        // Populate instance variables from input properties, using defaults if values not provided
        if (typeof props === 'undefined')
            props = {};
        this.vpc = props.vpc ?? new ec2.Vpc(this, 'ClientVpc', { subnetConfiguration: [{ name: 'Private', subnetType: ec2.SubnetType.PRIVATE_ISOLATED }] });
        const vpcEndpointServiceName = scope.vpcEndpointServiceName.replace(`com.amazonaws.${region}.`, '');
        // Add VPC FlowLogs with the default setting of trafficType:ALL and destination:CloudWatchLogs
        this.vpc.addFlowLog('FlowLog');
        // Add a VPC endpoint to access the Managed Blockchain
        const vpcService = new ec2.InterfaceVpcEndpointService(vpcEndpointServiceName);
        this.vpcEndpoint = this.vpc.addInterfaceEndpoint('NetworkEndpoint', { service: vpcService, open: false, privateDnsEnabled: true });
        // Add VPC endpoint to access Secrets Manager
        this.vpc.addInterfaceEndpoint('SecretsManagerEndpoint', { service: ec2.InterfaceVpcEndpointAwsService.SECRETS_MANAGER });
        // Add VPC endpoint to access S3
        this.vpc.addGatewayEndpoint('S3Endpoint', { service: ec2.GatewayVpcEndpointAwsService.S3 });
    }
}
exports.HyperledgerFabricClient = HyperledgerFabricClient;
_a = JSII_RTTI_SYMBOL_1;
HyperledgerFabricClient[_a] = { fqn: "@cdklabs/cdk-hyperledger-fabric-network.HyperledgerFabricClient", version: "0.8.670" };
//# sourceMappingURL=data:application/json;base64,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