## Description

<!-- This section provides the necessary background and information for reviewers to
understand the code and have the correct mindset when examining changes. -->

> [!NOTE]  
> **tldr**: <!-- Write a one sentence summary. -->


### Background - why do we need this PR?

<!-- What problem are you solving? Describe in a few sentences the state before
this PR. Use code examples if useful. -->

### Overview - what changed?

<!-- What aspects and mechanisms of the code base changed? Describe only the general 
idea and overarching features. -->

### Implementation - how did you implement the changes?

<!-- How did you solve the issue technically? Explain why you chose this approach and 
provide code examples if applicable (e.g. change in the API for users). -->


## Changes Made

<!-- This section highlights the important features and files that reviewers should
pay attention to when reviewing. Only list important features or files, this is useful for 
reviewers to correctly assess how deeply the modifications impact the code base.

For instance:

### New features or files
- `NewClass` added to `new_file.py`
- `new_function` added to `existing_file.py`

...
-->

### New features or files

<!-- List new features or files added. -->
-

### Modified features or files

<!-- List important modified features or files. -->
-

### Removed features or files

<!-- List removed features or files. -->
-

## How has this been tested?

<!-- Describe the tests that you ran to verify your changes. This can be a short 
description of the tests added to the PR or code snippet to reproduce the change
in behaviour. -->


## Related Issues

<!-- Link to any related issues or discussions. Use keywords like "Fixes", "Resolves",
or "Closes" to link to issues automatically. -->

- Resolves #

## Breaking changes

<!-- Describe any breaking changes introduced by this PR. -->

## Additional Notes and Examples

<!-- Provide any additional information that will help reviewers understand the
changes. This can be links to documentations, forum posts, past discussions etc. -->

---

**Please ensure your PR meets the following requirements:**

- [ ] Code builds and passes tests locally, including doctests
- [ ] New tests have been added (for bug fixes/features)
- [ ] Pre-commit passes
- [ ] PR to the documentation exists (for bug fixes / features)