"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from .basesdk import BaseSDK
from jsonpath import JSONPath
from meitner import errors, models, utils
from meitner._hooks import HookContext
from meitner.types import OptionalNullable, UNSET
from meitner.utils import get_security_from_env
from meitner.utils.unmarshal_json_response import unmarshal_json_response
from typing import Any, Awaitable, Dict, List, Mapping, Optional, Union


class AuditEvents(BaseSDK):
    def list(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AuditEventListResponse]:
        r"""List AuditEvents

        Returns a paginated list of all `AuditEvents` in your organization.

        :param limit: The maximum number of AuditEvents to return (default: 50) when listing AuditEvents
        :param offset: The number of AuditEvents to skip before starting to return results (default: 0) when listing AuditEvents
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AuditEventListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request(
            method="GET",
            path="/audit-event",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AuditEventList",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.AuditEventListResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.list(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AuditEventListResponse(
                result=unmarshal_json_response(models.AuditEventList, http_res),
                next=next_func,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def list_async(
        self,
        *,
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AuditEventListResponse]:
        r"""List AuditEvents

        Returns a paginated list of all `AuditEvents` in your organization.

        :param limit: The maximum number of AuditEvents to return (default: 50) when listing AuditEvents
        :param offset: The number of AuditEvents to skip before starting to return results (default: 0) when listing AuditEvents
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AuditEventListRequest(
            limit=limit,
            offset=offset,
        )

        req = self._build_request_async(
            method="GET",
            path="/audit-event",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AuditEventList",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.AuditEventListResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.list_async(
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AuditEventListResponse(
                result=unmarshal_json_response(models.AuditEventList, http_res),
                next=next_func,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def search(
        self,
        *,
        filter_: Union[
            models.AuditEventSearchFilter, models.AuditEventSearchFilterTypedDict
        ],
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AuditEventSearchResponseResponse]:
        r"""Search AuditEvents

        Search for `AuditEvents` with filtering capabilities.

        :param filter_: Filter criteria to search for specific records
        :param limit: The maximum number of AuditEvents to return (default: 50) when searching AuditEvents
        :param offset: The number of AuditEvents to skip before starting to return results (default: 0) when searching AuditEvents
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AuditEventSearchRequest(
            limit=limit,
            offset=offset,
            audit_event_search=models.AuditEventSearchRequestBody(
                filter_=utils.get_pydantic_model(
                    filter_, models.AuditEventSearchFilter
                ),
            ),
        )

        req = self._build_request(
            method="POST",
            path="/audit-event/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.audit_event_search,
                False,
                False,
                "json",
                models.AuditEventSearchRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AuditEventSearch",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Optional[models.AuditEventSearchResponseResponse]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return None
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return None
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return None
            next_offset = offset + len(results[0])

            return self.search(
                filter_=filter_,
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AuditEventSearchResponseResponse(
                result=unmarshal_json_response(
                    models.AuditEventSearchResponse, http_res
                ),
                next=next_func,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuditEventSearch422ResponseBodyErrorData, http_res
            )
            raise errors.AuditEventSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def search_async(
        self,
        *,
        filter_: Union[
            models.AuditEventSearchFilter, models.AuditEventSearchFilterTypedDict
        ],
        limit: Optional[int] = 50,
        offset: Optional[int] = 0,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> Optional[models.AuditEventSearchResponseResponse]:
        r"""Search AuditEvents

        Search for `AuditEvents` with filtering capabilities.

        :param filter_: Filter criteria to search for specific records
        :param limit: The maximum number of AuditEvents to return (default: 50) when searching AuditEvents
        :param offset: The number of AuditEvents to skip before starting to return results (default: 0) when searching AuditEvents
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AuditEventSearchRequest(
            limit=limit,
            offset=offset,
            audit_event_search=models.AuditEventSearchRequestBody(
                filter_=utils.get_pydantic_model(
                    filter_, models.AuditEventSearchFilter
                ),
            ),
        )

        req = self._build_request_async(
            method="POST",
            path="/audit-event/_search",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=True,
            request_has_path_params=False,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            get_serialized_body=lambda: utils.serialize_request_body(
                request.audit_event_search,
                False,
                False,
                "json",
                models.AuditEventSearchRequestBody,
            ),
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AuditEventSearch",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "422",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        def next_func() -> Awaitable[Optional[models.AuditEventSearchResponseResponse]]:
            body = utils.unmarshal_json(http_res.text, Union[Dict[Any, Any], List[Any]])

            async def empty_result():
                return None

            offset = request.offset if not request.offset is None else 0

            if not http_res.text:
                return empty_result()
            results = JSONPath("$.data.resultArray").parse(body)
            if len(results) == 0 or len(results[0]) == 0:
                return empty_result()
            limit = request.limit if not request.limit is None else 50
            if len(results[0]) < limit:
                return empty_result()
            next_offset = offset + len(results[0])

            return self.search_async(
                filter_=filter_,
                limit=limit,
                offset=next_offset,
                retries=retries,
            )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AuditEventSearchResponseResponse(
                result=unmarshal_json_response(
                    models.AuditEventSearchResponse, http_res
                ),
                next=next_func,
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "422", "application/json"):
            response_data = unmarshal_json_response(
                errors.AuditEventSearch422ResponseBodyErrorData, http_res
            )
            raise errors.AuditEventSearch422ResponseBodyError(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    def get(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AuditEventGetResponse:
        r"""Get a AuditEvent

        Retrieves the `AuditEvent` with the given ID.

        :param id: The unique identifier of the AuditEvent to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AuditEventGetRequest(
            id=id,
        )

        req = self._build_request(
            method="GET",
            path="/audit-event/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = self.do_request(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AuditEventGet",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AuditEventGetResponse(
                result=unmarshal_json_response(models.AuditEvent, http_res),
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = utils.stream_to_text(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)

    async def get_async(
        self,
        *,
        id: str,
        retries: OptionalNullable[utils.RetryConfig] = UNSET,
        server_url: Optional[str] = None,
        timeout_ms: Optional[int] = None,
        http_headers: Optional[Mapping[str, str]] = None,
    ) -> models.AuditEventGetResponse:
        r"""Get a AuditEvent

        Retrieves the `AuditEvent` with the given ID.

        :param id: The unique identifier of the AuditEvent to retrieve
        :param retries: Override the default retry configuration for this method
        :param server_url: Override the default server URL for this method
        :param timeout_ms: Override the default request timeout configuration for this method in milliseconds
        :param http_headers: Additional headers to set or replace on requests.
        """
        base_url = None
        url_variables = None
        if timeout_ms is None:
            timeout_ms = self.sdk_configuration.timeout_ms

        if timeout_ms is None:
            timeout_ms = 45000

        if server_url is not None:
            base_url = server_url
        else:
            base_url = self._get_url(base_url, url_variables)

        request = models.AuditEventGetRequest(
            id=id,
        )

        req = self._build_request_async(
            method="GET",
            path="/audit-event/{id}",
            base_url=base_url,
            url_variables=url_variables,
            request=request,
            request_body_required=False,
            request_has_path_params=True,
            request_has_query_params=True,
            user_agent_header="user-agent",
            accept_header_value="application/json",
            http_headers=http_headers,
            security=self.sdk_configuration.security,
            timeout_ms=timeout_ms,
        )

        if retries == UNSET:
            if self.sdk_configuration.retry_config is not UNSET:
                retries = self.sdk_configuration.retry_config
            else:
                retries = utils.RetryConfig(
                    "backoff", utils.BackoffStrategy(1000, 30000, 2, 1800000), False
                )

        retry_config = None
        if isinstance(retries, utils.RetryConfig):
            retry_config = (retries, ["500", "502", "503", "504", "429"])

        http_res = await self.do_request_async(
            hook_ctx=HookContext(
                config=self.sdk_configuration,
                base_url=base_url or "",
                operation_id="AuditEventGet",
                oauth2_scopes=None,
                security_source=get_security_from_env(
                    self.sdk_configuration.security, models.Security
                ),
            ),
            request=req,
            error_status_codes=[
                "400",
                "401",
                "403",
                "404",
                "409",
                "429",
                "4XX",
                "500",
                "5XX",
            ],
            retry_config=retry_config,
        )

        response_data: Any = None
        if utils.match_response(http_res, "200", "application/json"):
            return models.AuditEventGetResponse(
                result=unmarshal_json_response(models.AuditEvent, http_res),
                headers=utils.get_response_headers(http_res.headers),
            )
        if utils.match_response(http_res, "400", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error400ResponseBodyData, http_res
            )
            raise errors.Error400ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "401", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error401ResponseBodyData, http_res
            )
            raise errors.Error401ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "403", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error403ResponseBodyData, http_res
            )
            raise errors.Error403ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "404", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error404ResponseBodyData, http_res
            )
            raise errors.Error404ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "409", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error409ResponseBodyData, http_res
            )
            raise errors.Error409ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "429", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error429ResponseBodyData, http_res
            )
            raise errors.Error429ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "500", "application/json"):
            response_data = unmarshal_json_response(
                errors.Error500ResponseBodyData, http_res
            )
            raise errors.Error500ResponseBody(response_data, http_res)
        if utils.match_response(http_res, "4XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )
        if utils.match_response(http_res, "5XX", "*"):
            http_res_text = await utils.stream_to_text_async(http_res)
            raise errors.MeitnerDefaultError(
                "API error occurred", http_res, http_res_text
            )

        raise errors.MeitnerDefaultError("Unexpected response received", http_res)
