"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from dataclasses import dataclass, field
import httpx
from meitner.errors import MeitnerError
from meitner.models import error404responsebody as models_error404responsebody
from meitner.types import BaseModel
from typing import Optional


class Error404ResponseBodyData(BaseModel):
    error: models_error404responsebody.Error404ResponseBodyError


@dataclass(unsafe_hash=True)
class Error404ResponseBody(MeitnerError):
    r"""Not Found - The requested resource does not exist"""

    data: Error404ResponseBodyData = field(hash=False)

    def __init__(
        self,
        data: Error404ResponseBodyData,
        raw_response: httpx.Response,
        body: Optional[str] = None,
    ):
        fallback = body or raw_response.text
        message = str(data.error.message) or fallback
        super().__init__(message, raw_response, body)
        object.__setattr__(self, "data", data)
