"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AuditEventMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: datetime
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class AuditEventMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


AuditEventResource1 = Literal[
    "Group",
    "Guardian",
    "Employee",
    "EmployeePlacement",
    "Student",
    "StudentPlacement",
]
r"""The type of resource the event occured for"""


AuditEventTypeDelete = Literal["Delete",]
r"""The type of the audit event"""


class AuditEventTypedDict(TypedDict):
    r"""AuditEvent holds the information about an audit event."""

    id: str
    r"""Unique identifier for the AuditEvent"""
    timestamp: datetime
    r"""The timestamp of the event"""
    resource: AuditEventResource1
    r"""The type of resource the event occured for"""
    resource_id: str
    r"""The ID of the resource the event belongs to"""
    type: AuditEventTypeDelete
    r"""The type of the audit event"""
    meta: NotRequired[AuditEventMetaTypedDict]
    r"""Metadata information for the AuditEvent"""


class AuditEvent(BaseModel):
    r"""AuditEvent holds the information about an audit event."""

    id: str
    r"""Unique identifier for the AuditEvent"""

    timestamp: datetime
    r"""The timestamp of the event"""

    resource: AuditEventResource1
    r"""The type of resource the event occured for"""

    resource_id: Annotated[str, pydantic.Field(alias="resourceID")]
    r"""The ID of the resource the event belongs to"""

    type: AuditEventTypeDelete
    r"""The type of the audit event"""

    meta: Optional[AuditEventMeta] = None
    r"""Metadata information for the AuditEvent"""
