"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditeventresource import AuditEventResource
from .auditeventtype import AuditEventType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AuditEventFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class AuditEventFilterEqualsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


AuditEventFilterEqualsResource = Literal[
    "Group",
    "Guardian",
    "Employee",
    "EmployeePlacement",
    "Student",
    "StudentPlacement",
]
r"""The type of resource the event occured for"""


AuditEventFilterEqualsType = Literal["Delete",]
r"""The type of the audit event"""


class AuditEventFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for AuditEvent"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventFilterEqualsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""
    resource: NotRequired[Nullable[AuditEventFilterEqualsResource]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[Nullable[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[Nullable[AuditEventFilterEqualsType]]
    r"""The type of the audit event"""


class AuditEventFilterEquals(BaseModel):
    r"""Equality filters for AuditEvent"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventFilterEqualsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    resource: OptionalNullable[AuditEventFilterEqualsResource] = UNSET
    r"""The type of resource the event occured for"""

    resource_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="resourceID")
    ] = UNSET
    r"""The ID of the resource the event belongs to"""

    type: OptionalNullable[AuditEventFilterEqualsType] = UNSET
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        nullable_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class AuditEventFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


AuditEventFilterNotEqualsResource = Literal[
    "Group",
    "Guardian",
    "Employee",
    "EmployeePlacement",
    "Student",
    "StudentPlacement",
]
r"""The type of resource the event occured for"""


AuditEventFilterNotEqualsType = Literal["Delete",]
r"""The type of the audit event"""


class AuditEventFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for AuditEvent"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""
    resource: NotRequired[Nullable[AuditEventFilterNotEqualsResource]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[Nullable[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[Nullable[AuditEventFilterNotEqualsType]]
    r"""The type of the audit event"""


class AuditEventFilterNotEquals(BaseModel):
    r"""Inequality filters for AuditEvent"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    resource: OptionalNullable[AuditEventFilterNotEqualsResource] = UNSET
    r"""The type of resource the event occured for"""

    resource_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="resourceID")
    ] = UNSET
    r"""The ID of the resource the event belongs to"""

    type: OptionalNullable[AuditEventFilterNotEqualsType] = UNSET
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        nullable_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventFilterGreaterThan(BaseModel):
    r"""Greater than filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventFilterSmallerThan(BaseModel):
    r"""Smaller than filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class AuditEventFilterContainsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class AuditEventFilterContainsTypedDict(TypedDict):
    r"""Contains filters for AuditEvent"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventFilterContainsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    resource: NotRequired[List[AuditEventResource]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[List[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[List[AuditEventType]]
    r"""The type of the audit event"""


class AuditEventFilterContains(BaseModel):
    r"""Contains filters for AuditEvent"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventFilterContainsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    resource: Optional[List[AuditEventResource]] = None
    r"""The type of resource the event occured for"""

    resource_id: Annotated[Optional[List[str]], pydantic.Field(alias="resourceID")] = (
        None
    )
    r"""The ID of the resource the event belongs to"""

    type: Optional[List[AuditEventType]] = None
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "resource", "resourceID", "type"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class AuditEventFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class AuditEventFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for AuditEvent"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    resource: NotRequired[List[AuditEventResource]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[List[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[List[AuditEventType]]
    r"""The type of the audit event"""


class AuditEventFilterNotContains(BaseModel):
    r"""Not contains filters for AuditEvent"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventFilterNotContainsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    resource: Optional[List[AuditEventResource]] = None
    r"""The type of resource the event occured for"""

    resource_id: Annotated[Optional[List[str]], pydantic.Field(alias="resourceID")] = (
        None
    )
    r"""The ID of the resource the event belongs to"""

    type: Optional[List[AuditEventType]] = None
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "resource", "resourceID", "type"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterLikeMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterLikeMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterLike(BaseModel):
    r"""LIKE filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterLikeMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterNotLike(BaseModel):
    r"""NOT LIKE filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterNotLikeMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class AuditEventFilterNullMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNullTypedDict(TypedDict):
    r"""Null filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterNullMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterNull(BaseModel):
    r"""Null filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterNullMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class AuditEventFilterNotNullMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventFilterNotNullMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventFilterNotNull(BaseModel):
    r"""Not null filters for AuditEvent"""

    meta: OptionalNullable[AuditEventFilterNotNullMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventFilterTypedDict(TypedDict):
    r"""Filter object for AuditEvent"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[AuditEventFilterEqualsTypedDict]]
    r"""Equality filters for AuditEvent"""
    not_equals: NotRequired[Nullable[AuditEventFilterNotEqualsTypedDict]]
    r"""Inequality filters for AuditEvent"""
    greater_than: NotRequired[Nullable[AuditEventFilterGreaterThanTypedDict]]
    r"""Greater than filters for AuditEvent"""
    smaller_than: NotRequired[Nullable[AuditEventFilterSmallerThanTypedDict]]
    r"""Smaller than filters for AuditEvent"""
    greater_or_equal: NotRequired[Nullable[AuditEventFilterGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for AuditEvent"""
    smaller_or_equal: NotRequired[Nullable[AuditEventFilterSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for AuditEvent"""
    contains: NotRequired[Nullable[AuditEventFilterContainsTypedDict]]
    r"""Contains filters for AuditEvent"""
    not_contains: NotRequired[Nullable[AuditEventFilterNotContainsTypedDict]]
    r"""Not contains filters for AuditEvent"""
    like: NotRequired[Nullable[AuditEventFilterLikeTypedDict]]
    r"""LIKE filters for AuditEvent"""
    not_like: NotRequired[Nullable[AuditEventFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for AuditEvent"""
    null: NotRequired[Nullable[AuditEventFilterNullTypedDict]]
    r"""Null filters for AuditEvent"""
    not_null: NotRequired[Nullable[AuditEventFilterNotNullTypedDict]]
    r"""Not null filters for AuditEvent"""
    nested_filters: NotRequired[List[AuditEventFilterTypedDict]]
    r"""NestedFilters of the AuditEvent, useful for more complex filters"""


class AuditEventFilter(BaseModel):
    r"""Filter object for AuditEvent"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[AuditEventFilterEquals] = UNSET
    r"""Equality filters for AuditEvent"""

    not_equals: Annotated[
        OptionalNullable[AuditEventFilterNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for AuditEvent"""

    greater_than: Annotated[
        OptionalNullable[AuditEventFilterGreaterThan],
        pydantic.Field(alias="greaterThan"),
    ] = UNSET
    r"""Greater than filters for AuditEvent"""

    smaller_than: Annotated[
        OptionalNullable[AuditEventFilterSmallerThan],
        pydantic.Field(alias="smallerThan"),
    ] = UNSET
    r"""Smaller than filters for AuditEvent"""

    greater_or_equal: Annotated[
        OptionalNullable[AuditEventFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for AuditEvent"""

    smaller_or_equal: Annotated[
        OptionalNullable[AuditEventFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for AuditEvent"""

    contains: OptionalNullable[AuditEventFilterContains] = UNSET
    r"""Contains filters for AuditEvent"""

    not_contains: Annotated[
        OptionalNullable[AuditEventFilterNotContains],
        pydantic.Field(alias="notContains"),
    ] = UNSET
    r"""Not contains filters for AuditEvent"""

    like: OptionalNullable[AuditEventFilterLike] = UNSET
    r"""LIKE filters for AuditEvent"""

    not_like: Annotated[
        OptionalNullable[AuditEventFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for AuditEvent"""

    null: OptionalNullable[AuditEventFilterNull] = UNSET
    r"""Null filters for AuditEvent"""

    not_null: Annotated[
        OptionalNullable[AuditEventFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for AuditEvent"""

    nested_filters: Annotated[
        Optional[List[AuditEventFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the AuditEvent, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
