"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditeventfilter import AuditEventFilter, AuditEventFilterTypedDict
from .auditeventresource import AuditEventResource
from .auditeventtype import AuditEventType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class AuditEventSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class AuditEventSearchEqualsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EqualsResourceRequestBody = Literal[
    "Group",
    "Guardian",
    "Employee",
    "EmployeePlacement",
    "Student",
    "StudentPlacement",
]
r"""The type of resource the event occured for"""


EqualsTypeRequestBody = Literal["Delete",]
r"""The type of the audit event"""


class AuditEventSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for AuditEvent"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventSearchEqualsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""
    resource: NotRequired[Nullable[EqualsResourceRequestBody]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[Nullable[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[Nullable[EqualsTypeRequestBody]]
    r"""The type of the audit event"""


class AuditEventSearchEquals(BaseModel):
    r"""Equality filters for AuditEvent"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventSearchEqualsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    resource: OptionalNullable[EqualsResourceRequestBody] = UNSET
    r"""The type of resource the event occured for"""

    resource_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="resourceID")
    ] = UNSET
    r"""The ID of the resource the event belongs to"""

    type: OptionalNullable[EqualsTypeRequestBody] = UNSET
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        nullable_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class AuditEventSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


NotEqualsResourceRequestBody = Literal[
    "Group",
    "Guardian",
    "Employee",
    "EmployeePlacement",
    "Student",
    "StudentPlacement",
]
r"""The type of resource the event occured for"""


NotEqualsTypeRequestBody = Literal["Delete",]
r"""The type of the audit event"""


class AuditEventSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for AuditEvent"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""
    resource: NotRequired[Nullable[NotEqualsResourceRequestBody]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[Nullable[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[Nullable[NotEqualsTypeRequestBody]]
    r"""The type of the audit event"""


class AuditEventSearchNotEquals(BaseModel):
    r"""Inequality filters for AuditEvent"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    resource: OptionalNullable[NotEqualsResourceRequestBody] = UNSET
    r"""The type of resource the event occured for"""

    resource_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="resourceID")
    ] = UNSET
    r"""The ID of the resource the event belongs to"""

    type: OptionalNullable[NotEqualsTypeRequestBody] = UNSET
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        nullable_fields = ["id", "meta", "timestamp", "resource", "resourceID", "type"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventSearchGreaterThan(BaseModel):
    r"""Greater than filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventSearchSmallerThan(BaseModel):
    r"""Smaller than filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class AuditEventSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    timestamp: NotRequired[Nullable[datetime]]
    r"""The timestamp of the event"""


class AuditEventSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    timestamp: OptionalNullable[datetime] = UNSET
    r"""The timestamp of the event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "timestamp"]
        nullable_fields = ["meta", "timestamp"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class AuditEventSearchContainsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class AuditEventSearchContainsTypedDict(TypedDict):
    r"""Contains filters for AuditEvent"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventSearchContainsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    resource: NotRequired[List[AuditEventResource]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[List[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[List[AuditEventType]]
    r"""The type of the audit event"""


class AuditEventSearchContains(BaseModel):
    r"""Contains filters for AuditEvent"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventSearchContainsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    resource: Optional[List[AuditEventResource]] = None
    r"""The type of resource the event occured for"""

    resource_id: Annotated[Optional[List[str]], pydantic.Field(alias="resourceID")] = (
        None
    )
    r"""The ID of the resource the event belongs to"""

    type: Optional[List[AuditEventType]] = None
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "resource", "resourceID", "type"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class AuditEventSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class AuditEventSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for AuditEvent"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the AuditEvent"""
    meta: NotRequired[Nullable[AuditEventSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""
    resource: NotRequired[List[AuditEventResource]]
    r"""The type of resource the event occured for"""
    resource_id: NotRequired[List[str]]
    r"""The ID of the resource the event belongs to"""
    type: NotRequired[List[AuditEventType]]
    r"""The type of the audit event"""


class AuditEventSearchNotContains(BaseModel):
    r"""Not contains filters for AuditEvent"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the AuditEvent"""

    meta: OptionalNullable[AuditEventSearchNotContainsMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    resource: Optional[List[AuditEventResource]] = None
    r"""The type of resource the event occured for"""

    resource_id: Annotated[Optional[List[str]], pydantic.Field(alias="resourceID")] = (
        None
    )
    r"""The ID of the resource the event belongs to"""

    type: Optional[List[AuditEventType]] = None
    r"""The type of the audit event"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["id", "meta", "resource", "resourceID", "type"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchLikeMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchLikeMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchLike(BaseModel):
    r"""LIKE filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchLikeMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchNotLike(BaseModel):
    r"""NOT LIKE filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchNotLikeMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class AuditEventSearchNullMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNullTypedDict(TypedDict):
    r"""Null filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchNullMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchNull(BaseModel):
    r"""Null filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchNullMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the AuditEvent"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class AuditEventSearchNotNullMeta(BaseModel):
    r"""Metadata information for the AuditEvent"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for AuditEvent"""

    meta: NotRequired[Nullable[AuditEventSearchNotNullMetaTypedDict]]
    r"""Metadata information for the AuditEvent"""


class AuditEventSearchNotNull(BaseModel):
    r"""Not null filters for AuditEvent"""

    meta: OptionalNullable[AuditEventSearchNotNullMeta] = UNSET
    r"""Metadata information for the AuditEvent"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta"]
        nullable_fields = ["meta"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[AuditEventSearchEqualsTypedDict]]
    r"""Equality filters for AuditEvent"""
    not_equals: NotRequired[Nullable[AuditEventSearchNotEqualsTypedDict]]
    r"""Inequality filters for AuditEvent"""
    greater_than: NotRequired[Nullable[AuditEventSearchGreaterThanTypedDict]]
    r"""Greater than filters for AuditEvent"""
    smaller_than: NotRequired[Nullable[AuditEventSearchSmallerThanTypedDict]]
    r"""Smaller than filters for AuditEvent"""
    greater_or_equal: NotRequired[Nullable[AuditEventSearchGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for AuditEvent"""
    smaller_or_equal: NotRequired[Nullable[AuditEventSearchSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for AuditEvent"""
    contains: NotRequired[Nullable[AuditEventSearchContainsTypedDict]]
    r"""Contains filters for AuditEvent"""
    not_contains: NotRequired[Nullable[AuditEventSearchNotContainsTypedDict]]
    r"""Not contains filters for AuditEvent"""
    like: NotRequired[Nullable[AuditEventSearchLikeTypedDict]]
    r"""LIKE filters for AuditEvent"""
    not_like: NotRequired[Nullable[AuditEventSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for AuditEvent"""
    null: NotRequired[Nullable[AuditEventSearchNullTypedDict]]
    r"""Null filters for AuditEvent"""
    not_null: NotRequired[Nullable[AuditEventSearchNotNullTypedDict]]
    r"""Not null filters for AuditEvent"""
    nested_filters: NotRequired[List[AuditEventFilterTypedDict]]
    r"""NestedFilters of the AuditEvent, useful for more complex filters"""


class AuditEventSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[AuditEventSearchEquals] = UNSET
    r"""Equality filters for AuditEvent"""

    not_equals: Annotated[
        OptionalNullable[AuditEventSearchNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for AuditEvent"""

    greater_than: Annotated[
        OptionalNullable[AuditEventSearchGreaterThan],
        pydantic.Field(alias="greaterThan"),
    ] = UNSET
    r"""Greater than filters for AuditEvent"""

    smaller_than: Annotated[
        OptionalNullable[AuditEventSearchSmallerThan],
        pydantic.Field(alias="smallerThan"),
    ] = UNSET
    r"""Smaller than filters for AuditEvent"""

    greater_or_equal: Annotated[
        OptionalNullable[AuditEventSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for AuditEvent"""

    smaller_or_equal: Annotated[
        OptionalNullable[AuditEventSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for AuditEvent"""

    contains: OptionalNullable[AuditEventSearchContains] = UNSET
    r"""Contains filters for AuditEvent"""

    not_contains: Annotated[
        OptionalNullable[AuditEventSearchNotContains],
        pydantic.Field(alias="notContains"),
    ] = UNSET
    r"""Not contains filters for AuditEvent"""

    like: OptionalNullable[AuditEventSearchLike] = UNSET
    r"""LIKE filters for AuditEvent"""

    not_like: Annotated[
        OptionalNullable[AuditEventSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for AuditEvent"""

    null: OptionalNullable[AuditEventSearchNull] = UNSET
    r"""Null filters for AuditEvent"""

    not_null: Annotated[
        OptionalNullable[AuditEventSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for AuditEvent"""

    nested_filters: Annotated[
        Optional[List[AuditEventFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the AuditEvent, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class AuditEventSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: AuditEventSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class AuditEventSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[AuditEventSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
