"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .auditeventsearch_requestbody import (
    AuditEventSearchRequestBody,
    AuditEventSearchRequestBodyTypedDict,
)
from .auditeventsearch_response import (
    AuditEventSearchResponse,
    AuditEventSearchResponseTypedDict,
)
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class AuditEventSearchRequestTypedDict(TypedDict):
    audit_event_search: AuditEventSearchRequestBodyTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of AuditEvents to return (default: 50) when searching AuditEvents"""
    offset: NotRequired[int]
    r"""The number of AuditEvents to skip before starting to return results (default: 0) when searching AuditEvents"""


class AuditEventSearchRequest(BaseModel):
    audit_event_search: Annotated[
        AuditEventSearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of AuditEvents to return (default: 50) when searching AuditEvents"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of AuditEvents to skip before starting to return results (default: 0) when searching AuditEvents"""


class AuditEventSearchResponseResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: AuditEventSearchResponseTypedDict


class AuditEventSearchResponseResponse(BaseModel):
    next: Union[
        Callable[[], Optional[AuditEventSearchResponseResponse]],
        Callable[[], Awaitable[Optional[AuditEventSearchResponseResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: AuditEventSearchResponse
