"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeeplacementrole import EmployeePlacementRole
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeePlacementMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: datetime
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeePlacementMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementTypedDict(TypedDict):
    r"""EmployeePlacement holds the information about an employee's placement in a school."""

    id: str
    r"""Unique identifier for the EmployeePlacement"""
    employee_id: str
    r"""The ID of the employee the placement belongs to"""
    school_id: str
    r"""The ID of the school the placement belongs to"""
    start_date: date
    r"""The start date of the placement for the employee"""
    meta: NotRequired[EmployeePlacementMetaTypedDict]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    roles: NotRequired[List[EmployeePlacementRole]]
    r"""The roles of the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacement(BaseModel):
    r"""EmployeePlacement holds the information about an employee's placement in a school."""

    id: str
    r"""Unique identifier for the EmployeePlacement"""

    employee_id: Annotated[str, pydantic.Field(alias="employeeID")]
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[str, pydantic.Field(alias="schoolID")]
    r"""The ID of the school the placement belongs to"""

    start_date: Annotated[date, pydantic.Field(alias="startDate")]
    r"""The start date of the placement for the employee"""

    meta: Optional[EmployeePlacementMeta] = None
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    roles: Optional[List[EmployeePlacementRole]] = None
    r"""The roles of the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "external",
            "signature",
            "title",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
