"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeeplacementfilter import (
    EmployeePlacementFilter,
    EmployeePlacementFilterTypedDict,
)
from .employeeplacementrole import EmployeePlacementRole
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeePlacementSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeePlacementSearchEqualsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EqualsRolesRequestBody = Literal[
    "Admin",
    "CareTeam",
    "Manager",
    "OtherPersonnel",
    "Scheduler",
    "Teacher",
]
r"""The roles of the employee"""


class EmployeePlacementSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for EmployeePlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementSearchEqualsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[Nullable[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[EqualsRolesRequestBody]]
    r"""The roles of the employee"""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchEquals(BaseModel):
    r"""Equality filters for EmployeePlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchEqualsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="employeeID")
    ] = UNSET
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the placement belongs to"""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[EqualsRolesRequestBody] = UNSET
    r"""The roles of the employee"""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeePlacementSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


NotEqualsRolesRequestBody = Literal[
    "Admin",
    "CareTeam",
    "Manager",
    "OtherPersonnel",
    "Scheduler",
    "Teacher",
]
r"""The roles of the employee"""


class EmployeePlacementSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for EmployeePlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[Nullable[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[NotEqualsRolesRequestBody]]
    r"""The roles of the employee"""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchNotEquals(BaseModel):
    r"""Inequality filters for EmployeePlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[
        OptionalNullable[str], pydantic.Field(alias="employeeID")
    ] = UNSET
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the placement belongs to"""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[NotEqualsRolesRequestBody] = UNSET
    r"""The roles of the employee"""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchGreaterThan(BaseModel):
    r"""Greater than filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchSmallerThan(BaseModel):
    r"""Smaller than filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[
        Nullable[EmployeePlacementSearchGreaterOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeePlacementSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class EmployeePlacementSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[
        Nullable[EmployeePlacementSearchSmallerOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeePlacementSearchContainsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeePlacementSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeePlacementSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeePlacementSearchContainsTypedDict(TypedDict):
    r"""Contains filters for EmployeePlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementSearchContainsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[List[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[List[str]]
    r"""The signature of the employee"""
    title: NotRequired[List[str]]
    r"""The title of the employee"""
    roles: NotRequired[List[EmployeePlacementRole]]
    r"""The roles of the employee"""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementSearchContains(BaseModel):
    r"""Contains filters for EmployeePlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchContainsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[Optional[List[str]], pydantic.Field(alias="employeeID")] = (
        None
    )
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the placement belongs to"""

    signature: Optional[List[str]] = None
    r"""The signature of the employee"""

    title: Optional[List[str]] = None
    r"""The title of the employee"""

    roles: Optional[List[EmployeePlacementRole]] = None
    r"""The roles of the employee"""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeePlacementSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeePlacementSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeePlacementSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeePlacementSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for EmployeePlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the EmployeePlacement"""
    meta: NotRequired[Nullable[EmployeePlacementSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    employee_id: NotRequired[List[str]]
    r"""The ID of the employee the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the placement belongs to"""
    signature: NotRequired[List[str]]
    r"""The signature of the employee"""
    title: NotRequired[List[str]]
    r"""The title of the employee"""
    roles: NotRequired[List[EmployeePlacementRole]]
    r"""The roles of the employee"""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement for the employee"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementSearchNotContains(BaseModel):
    r"""Not contains filters for EmployeePlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchNotContainsMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    employee_id: Annotated[Optional[List[str]], pydantic.Field(alias="employeeID")] = (
        None
    )
    r"""The ID of the employee the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the placement belongs to"""

    signature: Optional[List[str]] = None
    r"""The signature of the employee"""

    title: Optional[List[str]] = None
    r"""The title of the employee"""

    roles: Optional[List[EmployeePlacementRole]] = None
    r"""The roles of the employee"""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement for the employee"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "employeeID",
            "schoolID",
            "signature",
            "title",
            "roles",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementSearchLikeMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchLikeMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementSearchLike(BaseModel):
    r"""LIKE filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchLikeMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "signature", "title", "archiveYear"]
        nullable_fields = ["meta", "external", "signature", "title", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""


class EmployeePlacementSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeePlacementSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class EmployeePlacementSearchNotLike(BaseModel):
    r"""NOT LIKE filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchNotLikeMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "signature", "title", "archiveYear"]
        nullable_fields = ["meta", "external", "signature", "title", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeePlacementSearchNullMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeePlacementSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNullTypedDict(TypedDict):
    r"""Null filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchNullMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[bool]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[bool]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[bool]]
    r"""The roles of the employee"""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchNull(BaseModel):
    r"""Null filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchNullMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[bool] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[bool] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[bool] = UNSET
    r"""The roles of the employee"""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the EmployeePlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeePlacementSearchNotNullMeta(BaseModel):
    r"""Metadata information for the EmployeePlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeePlacementSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for EmployeePlacement"""

    meta: NotRequired[Nullable[EmployeePlacementSearchNotNullMetaTypedDict]]
    r"""Metadata information for the EmployeePlacement"""
    external: NotRequired[Nullable[EmployeePlacementSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    signature: NotRequired[Nullable[bool]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[bool]]
    r"""The title of the employee"""
    roles: NotRequired[Nullable[bool]]
    r"""The roles of the employee"""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement for the employee"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the employee"""


class EmployeePlacementSearchNotNull(BaseModel):
    r"""Not null filters for EmployeePlacement"""

    meta: OptionalNullable[EmployeePlacementSearchNotNullMeta] = UNSET
    r"""Metadata information for the EmployeePlacement"""

    external: OptionalNullable[EmployeePlacementSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    signature: OptionalNullable[bool] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[bool] = UNSET
    r"""The title of the employee"""

    roles: OptionalNullable[bool] = UNSET
    r"""The roles of the employee"""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the employee, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "signature",
            "title",
            "roles",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[EmployeePlacementSearchEqualsTypedDict]]
    r"""Equality filters for EmployeePlacement"""
    not_equals: NotRequired[Nullable[EmployeePlacementSearchNotEqualsTypedDict]]
    r"""Inequality filters for EmployeePlacement"""
    greater_than: NotRequired[Nullable[EmployeePlacementSearchGreaterThanTypedDict]]
    r"""Greater than filters for EmployeePlacement"""
    smaller_than: NotRequired[Nullable[EmployeePlacementSearchSmallerThanTypedDict]]
    r"""Smaller than filters for EmployeePlacement"""
    greater_or_equal: NotRequired[
        Nullable[EmployeePlacementSearchGreaterOrEqualTypedDict]
    ]
    r"""Greater than or equal filters for EmployeePlacement"""
    smaller_or_equal: NotRequired[
        Nullable[EmployeePlacementSearchSmallerOrEqualTypedDict]
    ]
    r"""Smaller than or equal filters for EmployeePlacement"""
    contains: NotRequired[Nullable[EmployeePlacementSearchContainsTypedDict]]
    r"""Contains filters for EmployeePlacement"""
    not_contains: NotRequired[Nullable[EmployeePlacementSearchNotContainsTypedDict]]
    r"""Not contains filters for EmployeePlacement"""
    like: NotRequired[Nullable[EmployeePlacementSearchLikeTypedDict]]
    r"""LIKE filters for EmployeePlacement"""
    not_like: NotRequired[Nullable[EmployeePlacementSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for EmployeePlacement"""
    null: NotRequired[Nullable[EmployeePlacementSearchNullTypedDict]]
    r"""Null filters for EmployeePlacement"""
    not_null: NotRequired[Nullable[EmployeePlacementSearchNotNullTypedDict]]
    r"""Not null filters for EmployeePlacement"""
    nested_filters: NotRequired[List[EmployeePlacementFilterTypedDict]]
    r"""NestedFilters of the EmployeePlacement, useful for more complex filters"""


class EmployeePlacementSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[EmployeePlacementSearchEquals] = UNSET
    r"""Equality filters for EmployeePlacement"""

    not_equals: Annotated[
        OptionalNullable[EmployeePlacementSearchNotEquals],
        pydantic.Field(alias="notEquals"),
    ] = UNSET
    r"""Inequality filters for EmployeePlacement"""

    greater_than: Annotated[
        OptionalNullable[EmployeePlacementSearchGreaterThan],
        pydantic.Field(alias="greaterThan"),
    ] = UNSET
    r"""Greater than filters for EmployeePlacement"""

    smaller_than: Annotated[
        OptionalNullable[EmployeePlacementSearchSmallerThan],
        pydantic.Field(alias="smallerThan"),
    ] = UNSET
    r"""Smaller than filters for EmployeePlacement"""

    greater_or_equal: Annotated[
        OptionalNullable[EmployeePlacementSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for EmployeePlacement"""

    smaller_or_equal: Annotated[
        OptionalNullable[EmployeePlacementSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for EmployeePlacement"""

    contains: OptionalNullable[EmployeePlacementSearchContains] = UNSET
    r"""Contains filters for EmployeePlacement"""

    not_contains: Annotated[
        OptionalNullable[EmployeePlacementSearchNotContains],
        pydantic.Field(alias="notContains"),
    ] = UNSET
    r"""Not contains filters for EmployeePlacement"""

    like: OptionalNullable[EmployeePlacementSearchLike] = UNSET
    r"""LIKE filters for EmployeePlacement"""

    not_like: Annotated[
        OptionalNullable[EmployeePlacementSearchNotLike],
        pydantic.Field(alias="notLike"),
    ] = UNSET
    r"""NOT LIKE filters for EmployeePlacement"""

    null: OptionalNullable[EmployeePlacementSearchNull] = UNSET
    r"""Null filters for EmployeePlacement"""

    not_null: Annotated[
        OptionalNullable[EmployeePlacementSearchNotNull],
        pydantic.Field(alias="notNull"),
    ] = UNSET
    r"""Not null filters for EmployeePlacement"""

    nested_filters: Annotated[
        Optional[List[EmployeePlacementFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the EmployeePlacement, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeePlacementSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: EmployeePlacementSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class EmployeePlacementSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[EmployeePlacementSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
