"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeeplacementrole import EmployeePlacementRole
from datetime import date
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeePlacementUpdateExternalTypedDict(TypedDict):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class EmployeePlacementUpdateExternal(BaseModel):
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


class EmployeePlacementUpdateTypedDict(TypedDict):
    r"""Request body"""

    start_date: date
    r"""The start date of the placement for the employee"""
    external: NotRequired[EmployeePlacementUpdateExternalTypedDict]
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""
    signature: NotRequired[Nullable[str]]
    r"""The signature of the employee"""
    title: NotRequired[Nullable[str]]
    r"""The title of the employee"""
    roles: NotRequired[List[EmployeePlacementRole]]
    r"""The roles of the employee"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement for the employee"""


class EmployeePlacementUpdate(BaseModel):
    r"""Request body"""

    start_date: Annotated[date, pydantic.Field(alias="startDate")]
    r"""The start date of the placement for the employee"""

    external: Optional[EmployeePlacementUpdateExternal] = None
    r"""External is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the guardian, the Source-field is not included."""

    signature: OptionalNullable[str] = UNSET
    r"""The signature of the employee"""

    title: OptionalNullable[str] = UNSET
    r"""The title of the employee"""

    roles: Optional[List[EmployeePlacementRole]] = None
    r"""The roles of the employee"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement for the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["external", "signature", "title", "roles", "endDate"]
        nullable_fields = ["signature", "title", "endDate"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
