"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeefilter import EmployeeFilter, EmployeeFilterTypedDict
from .gender import Gender
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeeSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeeSearchEqualsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EmployeeSearchEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the employee"""


class EmployeeSearchEqualsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeSearchEqualsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for Employee"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeSearchEqualsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[EmployeeSearchEqualsGender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchEqualsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchEquals(BaseModel):
    r"""Equality filters for Employee"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeSearchEqualsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[EmployeeSearchEqualsGender] = UNSET
    r"""The gender of the employee"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchEqualsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class EmployeeSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


EmployeeSearchNotEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the employee"""


class EmployeeSearchNotEqualsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeSearchNotEqualsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Employee"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[EmployeeSearchNotEqualsGender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchNotEqualsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchNotEquals(BaseModel):
    r"""Inequality filters for Employee"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[EmployeeSearchNotEqualsGender] = UNSET
    r"""The gender of the employee"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchNotEqualsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchGreaterThanAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeSearchGreaterThanAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchGreaterThanAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeSearchGreaterThan(BaseModel):
    r"""Greater than filters for Employee"""

    meta: OptionalNullable[EmployeeSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchGreaterThanAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchSmallerThanAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeSearchSmallerThanAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchSmallerThanAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeSearchSmallerThan(BaseModel):
    r"""Smaller than filters for Employee"""

    meta: OptionalNullable[EmployeeSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchSmallerThanAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchGreaterOrEqualAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeSearchGreaterOrEqualAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchGreaterOrEqualAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Employee"""

    meta: OptionalNullable[EmployeeSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchGreaterOrEqualAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class EmployeeSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""


class EmployeeSearchSmallerOrEqualAddressTypedDict(TypedDict):
    r"""The address of the employee"""


class EmployeeSearchSmallerOrEqualAddress(BaseModel):
    r"""The address of the employee"""


class EmployeeSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchSmallerOrEqualAddressTypedDict]]
    r"""The address of the employee"""


class EmployeeSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Employee"""

    meta: OptionalNullable[EmployeeSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchSmallerOrEqualAddress] = UNSET
    r"""The address of the employee"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeeSearchContainsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeeSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeeSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeeSearchContainsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class EmployeeSearchContainsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class EmployeeSearchContainsTypedDict(TypedDict):
    r"""Contains filters for Employee"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeSearchContainsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[List[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[List[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchContainsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchContains(BaseModel):
    r"""Contains filters for Employee"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeSearchContainsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the employee"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the employee"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchContainsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class EmployeeSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class EmployeeSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class EmployeeSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class EmployeeSearchNotContainsAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class EmployeeSearchNotContainsAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class EmployeeSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Employee"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Employee"""
    meta: NotRequired[Nullable[EmployeeSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the employee"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the employee"""
    first_name: NotRequired[List[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[List[str]]
    r"""The last name of the employee"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchNotContainsAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchNotContains(BaseModel):
    r"""Not contains filters for Employee"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Employee"""

    meta: OptionalNullable[EmployeeSearchNotContainsMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the employee"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the employee, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the employee"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the employee"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the employee"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchNotContainsAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""


class EmployeeSearchLikeMeta(BaseModel):
    r"""Metadata information for the Employee"""


class EmployeeSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchLikeAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeSearchLikeAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchLikeMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    address: NotRequired[Nullable[EmployeeSearchLikeAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchLike(BaseModel):
    r"""LIKE filters for Employee"""

    meta: OptionalNullable[EmployeeSearchLikeMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    address: OptionalNullable[EmployeeSearchLikeAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""


class EmployeeSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the Employee"""


class EmployeeSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class EmployeeSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotLikeAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeSearchNotLikeAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the employee, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the employee"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the employee"""
    address: NotRequired[Nullable[EmployeeSearchNotLikeAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchNotLike(BaseModel):
    r"""NOT LIKE filters for Employee"""

    meta: OptionalNullable[EmployeeSearchNotLikeMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the employee, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the employee"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the employee"""

    address: OptionalNullable[EmployeeSearchNotLikeAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeeSearchNullMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeeSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNullAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class EmployeeSearchNullAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNullTypedDict(TypedDict):
    r"""Null filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchNullMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the employee"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchNullAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchNull(BaseModel):
    r"""Null filters for Employee"""

    meta: OptionalNullable[EmployeeSearchNullMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchNullAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Employee"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class EmployeeSearchNotNullMeta(BaseModel):
    r"""Metadata information for the Employee"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class EmployeeSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotNullAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class EmployeeSearchNotNullAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for Employee"""

    meta: NotRequired[Nullable[EmployeeSearchNotNullMetaTypedDict]]
    r"""Metadata information for the Employee"""
    external: NotRequired[Nullable[EmployeeSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the employee"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the employee"""
    address: NotRequired[Nullable[EmployeeSearchNotNullAddressTypedDict]]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeSearchNotNull(BaseModel):
    r"""Not null filters for Employee"""

    meta: OptionalNullable[EmployeeSearchNotNullMeta] = UNSET
    r"""Metadata information for the Employee"""

    external: OptionalNullable[EmployeeSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee placement from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the employee"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: OptionalNullable[EmployeeSearchNotNullAddress] = UNSET
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[EmployeeSearchEqualsTypedDict]]
    r"""Equality filters for Employee"""
    not_equals: NotRequired[Nullable[EmployeeSearchNotEqualsTypedDict]]
    r"""Inequality filters for Employee"""
    greater_than: NotRequired[Nullable[EmployeeSearchGreaterThanTypedDict]]
    r"""Greater than filters for Employee"""
    smaller_than: NotRequired[Nullable[EmployeeSearchSmallerThanTypedDict]]
    r"""Smaller than filters for Employee"""
    greater_or_equal: NotRequired[Nullable[EmployeeSearchGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Employee"""
    smaller_or_equal: NotRequired[Nullable[EmployeeSearchSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Employee"""
    contains: NotRequired[Nullable[EmployeeSearchContainsTypedDict]]
    r"""Contains filters for Employee"""
    not_contains: NotRequired[Nullable[EmployeeSearchNotContainsTypedDict]]
    r"""Not contains filters for Employee"""
    like: NotRequired[Nullable[EmployeeSearchLikeTypedDict]]
    r"""LIKE filters for Employee"""
    not_like: NotRequired[Nullable[EmployeeSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for Employee"""
    null: NotRequired[Nullable[EmployeeSearchNullTypedDict]]
    r"""Null filters for Employee"""
    not_null: NotRequired[Nullable[EmployeeSearchNotNullTypedDict]]
    r"""Not null filters for Employee"""
    nested_filters: NotRequired[List[EmployeeFilterTypedDict]]
    r"""NestedFilters of the Employee, useful for more complex filters"""


class EmployeeSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[EmployeeSearchEquals] = UNSET
    r"""Equality filters for Employee"""

    not_equals: Annotated[
        OptionalNullable[EmployeeSearchNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Employee"""

    greater_than: Annotated[
        OptionalNullable[EmployeeSearchGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Employee"""

    smaller_than: Annotated[
        OptionalNullable[EmployeeSearchSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Employee"""

    greater_or_equal: Annotated[
        OptionalNullable[EmployeeSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Employee"""

    smaller_or_equal: Annotated[
        OptionalNullable[EmployeeSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Employee"""

    contains: OptionalNullable[EmployeeSearchContains] = UNSET
    r"""Contains filters for Employee"""

    not_contains: Annotated[
        OptionalNullable[EmployeeSearchNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Employee"""

    like: OptionalNullable[EmployeeSearchLike] = UNSET
    r"""LIKE filters for Employee"""

    not_like: Annotated[
        OptionalNullable[EmployeeSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Employee"""

    null: OptionalNullable[EmployeeSearchNull] = UNSET
    r"""Null filters for Employee"""

    not_null: Annotated[
        OptionalNullable[EmployeeSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Employee"""

    nested_filters: Annotated[
        Optional[List[EmployeeFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Employee, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: EmployeeSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class EmployeeSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[EmployeeSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
