"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .employeesearch_requestbody import (
    EmployeeSearchRequestBody,
    EmployeeSearchRequestBodyTypedDict,
)
from .employeesearch_response import (
    EmployeeSearchResponse,
    EmployeeSearchResponseTypedDict,
)
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeeSearchRequestTypedDict(TypedDict):
    employee_search: EmployeeSearchRequestBodyTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Employees to return (default: 50) when searching Employees"""
    offset: NotRequired[int]
    r"""The number of Employees to skip before starting to return results (default: 0) when searching Employees"""


class EmployeeSearchRequest(BaseModel):
    employee_search: Annotated[
        EmployeeSearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Employees to return (default: 50) when searching Employees"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Employees to skip before starting to return results (default: 0) when searching Employees"""


class EmployeeSearchResponseResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: EmployeeSearchResponseTypedDict


class EmployeeSearchResponseResponse(BaseModel):
    next: Union[
        Callable[[], Optional[EmployeeSearchResponseResponse]],
        Callable[[], Awaitable[Optional[EmployeeSearchResponseResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: EmployeeSearchResponse
