"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import date
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class EmployeeUpdateExternalTypedDict(TypedDict):
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included."""

    source_id: str
    r"""The ID of the external source"""


class EmployeeUpdateExternal(BaseModel):
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included."""

    source_id: Annotated[str, pydantic.Field(alias="sourceID")]
    r"""The ID of the external source"""


EmployeeUpdateGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the employee"""


class EmployeeUpdateAddressTypedDict(TypedDict):
    r"""The address of the employee"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class EmployeeUpdateAddress(BaseModel):
    r"""The address of the employee"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class EmployeeUpdateTypedDict(TypedDict):
    r"""Request body"""

    identity_number: str
    r"""The identity number of the employee, must be unique within the organization."""
    first_name: str
    r"""The first name of the employee"""
    last_name: str
    r"""The last name of the employee"""
    external: NotRequired[EmployeeUpdateExternalTypedDict]
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included."""
    gender: NotRequired[Nullable[EmployeeUpdateGender]]
    r"""The gender of the employee"""
    identity_temporary: NotRequired[bool]
    r"""If the identity number is temporary for the employee"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the employee"""
    address: NotRequired[EmployeeUpdateAddressTypedDict]
    r"""The address of the employee"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""


class EmployeeUpdate(BaseModel):
    r"""Request body"""

    identity_number: Annotated[str, pydantic.Field(alias="identityNumber")]
    r"""The identity number of the employee, must be unique within the organization."""

    first_name: Annotated[str, pydantic.Field(alias="firstName")]
    r"""The first name of the employee"""

    last_name: Annotated[str, pydantic.Field(alias="lastName")]
    r"""The last name of the employee"""

    external: Optional[EmployeeUpdateExternal] = None
    r"""ExternalRequest is the External-object used on Update and Create operations, since it should only be allowed to set SourceID for the employee placement, the Source-field is not included."""

    gender: OptionalNullable[EmployeeUpdateGender] = UNSET
    r"""The gender of the employee"""

    identity_temporary: Annotated[
        Optional[bool], pydantic.Field(alias="identityTemporary")
    ] = False
    r"""If the identity number is temporary for the employee"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the employee"""

    address: Optional[EmployeeUpdateAddress] = None
    r"""The address of the employee"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the employee, will be used for communication with the employee from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the employee, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the employee, will be used for communication with the employee from the system and must be unique within the organization."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the employee, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "external",
            "gender",
            "identityTemporary",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "gender",
            "dateOfBirth",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
