"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .grouptype import GroupType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GroupMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: datetime
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GroupMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GroupCategory1 = Literal[
    "Education",
    "Other",
]
r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

"""


class GroupTypedDict(TypedDict):
    r"""Group holds the information about a group of students."""

    id: str
    r"""Unique identifier for the Group"""
    school_id: str
    r"""The ID of the school the group belongs to"""
    title: str
    r"""The title of the group, must be unique within the school."""
    meta: NotRequired[GroupMetaTypedDict]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    category: NotRequired[GroupCategory1]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class Group(BaseModel):
    r"""Group holds the information about a group of students."""

    id: str
    r"""Unique identifier for the Group"""

    school_id: Annotated[str, pydantic.Field(alias="schoolID")]
    r"""The ID of the school the group belongs to"""

    title: str
    r"""The title of the group, must be unique within the school."""

    meta: Optional[GroupMeta] = None
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    category: Optional[GroupCategory1] = "Education"
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "category",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = ["external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
