"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .groupcategory import GroupCategory
from .grouptype import GroupType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GroupFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GroupFilterEqualsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GroupFilterEqualsCategory = Literal[
    "Education",
    "Other",
]
r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

"""


GroupFilterEqualsTypes = Literal[
    "Class",
    "Childcare",
    "Mentor",
]
r"""The types of the group"""


class GroupFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for Group"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupFilterEqualsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[Nullable[GroupFilterEqualsCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[Nullable[GroupFilterEqualsTypes]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupFilterEquals(BaseModel):
    r"""Equality filters for Group"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupFilterEqualsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the group belongs to"""

    category: OptionalNullable[GroupFilterEqualsCategory] = UNSET
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    types: OptionalNullable[GroupFilterEqualsTypes] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[OptionalNullable[str], pydantic.Field(alias="memberIDs")] = (
        UNSET
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GroupFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GroupFilterNotEqualsCategory = Literal[
    "Education",
    "Other",
]
r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

"""


GroupFilterNotEqualsTypes = Literal[
    "Class",
    "Childcare",
    "Mentor",
]
r"""The types of the group"""


class GroupFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Group"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[Nullable[GroupFilterNotEqualsCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[Nullable[GroupFilterNotEqualsTypes]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupFilterNotEquals(BaseModel):
    r"""Inequality filters for Group"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the group belongs to"""

    category: OptionalNullable[GroupFilterNotEqualsCategory] = UNSET
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    types: OptionalNullable[GroupFilterNotEqualsTypes] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[OptionalNullable[str], pydantic.Field(alias="memberIDs")] = (
        UNSET
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Group"""

    meta: NotRequired[Nullable[GroupFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterGreaterThan(BaseModel):
    r"""Greater than filters for Group"""

    meta: OptionalNullable[GroupFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Group"""

    meta: NotRequired[Nullable[GroupFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterSmallerThan(BaseModel):
    r"""Smaller than filters for Group"""

    meta: OptionalNullable[GroupFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Group"""

    meta: NotRequired[Nullable[GroupFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Group"""

    meta: OptionalNullable[GroupFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Group"""

    meta: NotRequired[Nullable[GroupFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Group"""

    meta: OptionalNullable[GroupFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GroupFilterContainsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GroupFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GroupFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GroupFilterContainsTypedDict(TypedDict):
    r"""Contains filters for Group"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupFilterContainsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[List[GroupCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[List[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupFilterContains(BaseModel):
    r"""Contains filters for Group"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupFilterContainsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the group belongs to"""

    category: Optional[List[GroupCategory]] = None
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: Optional[List[str]] = None
    r"""The title of the group, must be unique within the school."""

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GroupFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GroupFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GroupFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GroupFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Group"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[List[GroupCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[List[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupFilterNotContains(BaseModel):
    r"""Not contains filters for Group"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupFilterNotContainsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the group belongs to"""

    category: Optional[List[GroupCategory]] = None
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: Optional[List[str]] = None
    r"""The title of the group, must be unique within the school."""

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""


class GroupFilterLikeMeta(BaseModel):
    r"""Metadata information for the Group"""


class GroupFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for Group"""

    meta: NotRequired[Nullable[GroupFilterLikeMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""


class GroupFilterLike(BaseModel):
    r"""LIKE filters for Group"""

    meta: OptionalNullable[GroupFilterLikeMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "title"]
        nullable_fields = ["meta", "external", "title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""


class GroupFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the Group"""


class GroupFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Group"""

    meta: NotRequired[Nullable[GroupFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""


class GroupFilterNotLike(BaseModel):
    r"""NOT LIKE filters for Group"""

    meta: OptionalNullable[GroupFilterNotLikeMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "title"]
        nullable_fields = ["meta", "external", "title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GroupFilterNullMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GroupFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNullTypedDict(TypedDict):
    r"""Null filters for Group"""

    meta: NotRequired[Nullable[GroupFilterNullMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    types: NotRequired[Nullable[bool]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupFilterNull(BaseModel):
    r"""Null filters for Group"""

    meta: OptionalNullable[GroupFilterNullMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    types: OptionalNullable[bool] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="memberIDs")
    ] = UNSET
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        nullable_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GroupFilterNotNullMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GroupFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for Group"""

    meta: NotRequired[Nullable[GroupFilterNotNullMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    types: NotRequired[Nullable[bool]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupFilterNotNull(BaseModel):
    r"""Not null filters for Group"""

    meta: OptionalNullable[GroupFilterNotNullMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    types: OptionalNullable[bool] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="memberIDs")
    ] = UNSET
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        nullable_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupFilterTypedDict(TypedDict):
    r"""Filter object for Group"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[GroupFilterEqualsTypedDict]]
    r"""Equality filters for Group"""
    not_equals: NotRequired[Nullable[GroupFilterNotEqualsTypedDict]]
    r"""Inequality filters for Group"""
    greater_than: NotRequired[Nullable[GroupFilterGreaterThanTypedDict]]
    r"""Greater than filters for Group"""
    smaller_than: NotRequired[Nullable[GroupFilterSmallerThanTypedDict]]
    r"""Smaller than filters for Group"""
    greater_or_equal: NotRequired[Nullable[GroupFilterGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Group"""
    smaller_or_equal: NotRequired[Nullable[GroupFilterSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Group"""
    contains: NotRequired[Nullable[GroupFilterContainsTypedDict]]
    r"""Contains filters for Group"""
    not_contains: NotRequired[Nullable[GroupFilterNotContainsTypedDict]]
    r"""Not contains filters for Group"""
    like: NotRequired[Nullable[GroupFilterLikeTypedDict]]
    r"""LIKE filters for Group"""
    not_like: NotRequired[Nullable[GroupFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for Group"""
    null: NotRequired[Nullable[GroupFilterNullTypedDict]]
    r"""Null filters for Group"""
    not_null: NotRequired[Nullable[GroupFilterNotNullTypedDict]]
    r"""Not null filters for Group"""
    nested_filters: NotRequired[List[GroupFilterTypedDict]]
    r"""NestedFilters of the Group, useful for more complex filters"""


class GroupFilter(BaseModel):
    r"""Filter object for Group"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[GroupFilterEquals] = UNSET
    r"""Equality filters for Group"""

    not_equals: Annotated[
        OptionalNullable[GroupFilterNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Group"""

    greater_than: Annotated[
        OptionalNullable[GroupFilterGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Group"""

    smaller_than: Annotated[
        OptionalNullable[GroupFilterSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Group"""

    greater_or_equal: Annotated[
        OptionalNullable[GroupFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Group"""

    smaller_or_equal: Annotated[
        OptionalNullable[GroupFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Group"""

    contains: OptionalNullable[GroupFilterContains] = UNSET
    r"""Contains filters for Group"""

    not_contains: Annotated[
        OptionalNullable[GroupFilterNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Group"""

    like: OptionalNullable[GroupFilterLike] = UNSET
    r"""LIKE filters for Group"""

    not_like: Annotated[
        OptionalNullable[GroupFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Group"""

    null: OptionalNullable[GroupFilterNull] = UNSET
    r"""Null filters for Group"""

    not_null: Annotated[
        OptionalNullable[GroupFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Group"""

    nested_filters: Annotated[
        Optional[List[GroupFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Group, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
