"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .groupcategory import GroupCategory
from .groupfilter import GroupFilter, GroupFilterTypedDict
from .grouptype import GroupType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GroupSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GroupSearchEqualsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GroupSearchEqualsCategory = Literal[
    "Education",
    "Other",
]
r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

"""


EqualsTypesRequestBody = Literal[
    "Class",
    "Childcare",
    "Mentor",
]
r"""The types of the group"""


class GroupSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for Group"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupSearchEqualsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[Nullable[GroupSearchEqualsCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[Nullable[EqualsTypesRequestBody]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupSearchEquals(BaseModel):
    r"""Equality filters for Group"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupSearchEqualsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the group belongs to"""

    category: OptionalNullable[GroupSearchEqualsCategory] = UNSET
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    types: OptionalNullable[EqualsTypesRequestBody] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[OptionalNullable[str], pydantic.Field(alias="memberIDs")] = (
        UNSET
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GroupSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


GroupSearchNotEqualsCategory = Literal[
    "Education",
    "Other",
]
r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

"""


NotEqualsTypesRequestBody = Literal[
    "Class",
    "Childcare",
    "Mentor",
]
r"""The types of the group"""


class GroupSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Group"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[Nullable[GroupSearchNotEqualsCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[Nullable[NotEqualsTypesRequestBody]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupSearchNotEquals(BaseModel):
    r"""Inequality filters for Group"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the group belongs to"""

    category: OptionalNullable[GroupSearchNotEqualsCategory] = UNSET
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    types: OptionalNullable[NotEqualsTypesRequestBody] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[OptionalNullable[str], pydantic.Field(alias="memberIDs")] = (
        UNSET
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Group"""

    meta: NotRequired[Nullable[GroupSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchGreaterThan(BaseModel):
    r"""Greater than filters for Group"""

    meta: OptionalNullable[GroupSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Group"""

    meta: NotRequired[Nullable[GroupSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchSmallerThan(BaseModel):
    r"""Smaller than filters for Group"""

    meta: OptionalNullable[GroupSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Group"""

    meta: NotRequired[Nullable[GroupSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Group"""

    meta: OptionalNullable[GroupSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GroupSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Group"""

    meta: NotRequired[Nullable[GroupSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""


class GroupSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Group"""

    meta: OptionalNullable[GroupSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GroupSearchContainsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GroupSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GroupSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GroupSearchContainsTypedDict(TypedDict):
    r"""Contains filters for Group"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupSearchContainsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[List[GroupCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[List[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupSearchContains(BaseModel):
    r"""Contains filters for Group"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupSearchContainsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the group belongs to"""

    category: Optional[List[GroupCategory]] = None
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: Optional[List[str]] = None
    r"""The title of the group, must be unique within the school."""

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GroupSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GroupSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GroupSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GroupSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Group"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Group"""
    meta: NotRequired[Nullable[GroupSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the group belongs to"""
    category: NotRequired[List[GroupCategory]]
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """
    title: NotRequired[List[str]]
    r"""The title of the group, must be unique within the school."""
    types: NotRequired[List[GroupType]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[List[str]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[List[str]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupSearchNotContains(BaseModel):
    r"""Not contains filters for Group"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Group"""

    meta: OptionalNullable[GroupSearchNotContainsMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the group belongs to"""

    category: Optional[List[GroupCategory]] = None
    r"""If the category is Education, the ModeratorIDs have to be employees and the MemberIDs have to be students of the school. If the category is Other, it will not be possible to use the IsClass, IsChildcare and IsMentor fields.

    """

    title: Optional[List[str]] = None
    r"""The title of the group, must be unique within the school."""

    types: Optional[List[GroupType]] = None
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        Optional[List[str]], pydantic.Field(alias="moderatorIDs")
    ] = None
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="memberIDs")] = (
        None
    )
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "schoolID",
            "category",
            "title",
            "types",
            "moderatorIDs",
            "memberIDs",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""


class GroupSearchLikeMeta(BaseModel):
    r"""Metadata information for the Group"""


class GroupSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for Group"""

    meta: NotRequired[Nullable[GroupSearchLikeMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""


class GroupSearchLike(BaseModel):
    r"""LIKE filters for Group"""

    meta: OptionalNullable[GroupSearchLikeMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "title"]
        nullable_fields = ["meta", "external", "title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""


class GroupSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the Group"""


class GroupSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GroupSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Group"""

    meta: NotRequired[Nullable[GroupSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the group, must be unique within the school."""


class GroupSearchNotLike(BaseModel):
    r"""NOT LIKE filters for Group"""

    meta: OptionalNullable[GroupSearchNotLikeMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the group, must be unique within the school."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "title"]
        nullable_fields = ["meta", "external", "title"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GroupSearchNullMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GroupSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNullTypedDict(TypedDict):
    r"""Null filters for Group"""

    meta: NotRequired[Nullable[GroupSearchNullMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    types: NotRequired[Nullable[bool]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupSearchNull(BaseModel):
    r"""Null filters for Group"""

    meta: OptionalNullable[GroupSearchNullMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    types: OptionalNullable[bool] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="memberIDs")
    ] = UNSET
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        nullable_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Group"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GroupSearchNotNullMeta(BaseModel):
    r"""Metadata information for the Group"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GroupSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for Group"""

    meta: NotRequired[Nullable[GroupSearchNotNullMetaTypedDict]]
    r"""Metadata information for the Group"""
    external: NotRequired[Nullable[GroupSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""
    types: NotRequired[Nullable[bool]]
    r"""The types of the group"""
    moderator_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """
    member_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """


class GroupSearchNotNull(BaseModel):
    r"""Not null filters for Group"""

    meta: OptionalNullable[GroupSearchNotNullMeta] = UNSET
    r"""Metadata information for the Group"""

    external: OptionalNullable[GroupSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the employee from another system, used for third-party integration tracking."""

    types: OptionalNullable[bool] = UNSET
    r"""The types of the group"""

    moderator_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="moderatorIDs")
    ] = UNSET
    r"""The IDs of the moderators of the group.  Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Moderators have to be employees of the school.

    """

    member_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="memberIDs")
    ] = UNSET
    r"""The IDs of the members of the group. Can be any user type (Student, Employee, Guardian) if the Category is Other. If the Category is Education, the Members have to be students of the school.

    """

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        nullable_fields = ["meta", "external", "types", "moderatorIDs", "memberIDs"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[GroupSearchEqualsTypedDict]]
    r"""Equality filters for Group"""
    not_equals: NotRequired[Nullable[GroupSearchNotEqualsTypedDict]]
    r"""Inequality filters for Group"""
    greater_than: NotRequired[Nullable[GroupSearchGreaterThanTypedDict]]
    r"""Greater than filters for Group"""
    smaller_than: NotRequired[Nullable[GroupSearchSmallerThanTypedDict]]
    r"""Smaller than filters for Group"""
    greater_or_equal: NotRequired[Nullable[GroupSearchGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Group"""
    smaller_or_equal: NotRequired[Nullable[GroupSearchSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Group"""
    contains: NotRequired[Nullable[GroupSearchContainsTypedDict]]
    r"""Contains filters for Group"""
    not_contains: NotRequired[Nullable[GroupSearchNotContainsTypedDict]]
    r"""Not contains filters for Group"""
    like: NotRequired[Nullable[GroupSearchLikeTypedDict]]
    r"""LIKE filters for Group"""
    not_like: NotRequired[Nullable[GroupSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for Group"""
    null: NotRequired[Nullable[GroupSearchNullTypedDict]]
    r"""Null filters for Group"""
    not_null: NotRequired[Nullable[GroupSearchNotNullTypedDict]]
    r"""Not null filters for Group"""
    nested_filters: NotRequired[List[GroupFilterTypedDict]]
    r"""NestedFilters of the Group, useful for more complex filters"""


class GroupSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[GroupSearchEquals] = UNSET
    r"""Equality filters for Group"""

    not_equals: Annotated[
        OptionalNullable[GroupSearchNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Group"""

    greater_than: Annotated[
        OptionalNullable[GroupSearchGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Group"""

    smaller_than: Annotated[
        OptionalNullable[GroupSearchSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Group"""

    greater_or_equal: Annotated[
        OptionalNullable[GroupSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Group"""

    smaller_or_equal: Annotated[
        OptionalNullable[GroupSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Group"""

    contains: OptionalNullable[GroupSearchContains] = UNSET
    r"""Contains filters for Group"""

    not_contains: Annotated[
        OptionalNullable[GroupSearchNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Group"""

    like: OptionalNullable[GroupSearchLike] = UNSET
    r"""LIKE filters for Group"""

    not_like: Annotated[
        OptionalNullable[GroupSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Group"""

    null: OptionalNullable[GroupSearchNull] = UNSET
    r"""Null filters for Group"""

    not_null: Annotated[
        OptionalNullable[GroupSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Group"""

    nested_filters: Annotated[
        Optional[List[GroupFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Group, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GroupSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: GroupSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class GroupSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[GroupSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
