"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .groupsearch_requestbody import (
    GroupSearchRequestBody,
    GroupSearchRequestBodyTypedDict,
)
from .groupsearch_response import GroupSearchResponse, GroupSearchResponseTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class GroupSearchRequestTypedDict(TypedDict):
    group_search: GroupSearchRequestBodyTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Groups to return (default: 50) when searching Groups"""
    offset: NotRequired[int]
    r"""The number of Groups to skip before starting to return results (default: 0) when searching Groups"""


class GroupSearchRequest(BaseModel):
    group_search: Annotated[
        GroupSearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Groups to return (default: 50) when searching Groups"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Groups to skip before starting to return results (default: 0) when searching Groups"""


class GroupSearchResponseResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: GroupSearchResponseTypedDict


class GroupSearchResponseResponse(BaseModel):
    next: Union[
        Callable[[], Optional[GroupSearchResponseResponse]],
        Callable[[], Awaitable[Optional[GroupSearchResponseResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: GroupSearchResponse
