"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GuardianFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GuardianFilterEqualsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterEqualsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianFilterEqualsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for Guardian"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianFilterEqualsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianFilterEqualsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianFilterEquals(BaseModel):
    r"""Equality filters for Guardian"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianFilterEqualsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianFilterEqualsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GuardianFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotEqualsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianFilterNotEqualsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Guardian"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianFilterNotEqualsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianFilterNotEquals(BaseModel):
    r"""Inequality filters for Guardian"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianFilterNotEqualsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterGreaterThanAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianFilterGreaterThanAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianFilterGreaterThanAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianFilterGreaterThan(BaseModel):
    r"""Greater than filters for Guardian"""

    meta: OptionalNullable[GuardianFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianFilterGreaterThanAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterSmallerThanAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianFilterSmallerThanAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianFilterSmallerThanAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianFilterSmallerThan(BaseModel):
    r"""Smaller than filters for Guardian"""

    meta: OptionalNullable[GuardianFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianFilterSmallerThanAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterGreaterOrEqualAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianFilterGreaterOrEqualAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianFilterGreaterOrEqualAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Guardian"""

    meta: OptionalNullable[GuardianFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianFilterGreaterOrEqualAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianFilterSmallerOrEqualAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianFilterSmallerOrEqualAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianFilterSmallerOrEqualAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Guardian"""

    meta: OptionalNullable[GuardianFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianFilterSmallerOrEqualAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GuardianFilterContainsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GuardianFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GuardianFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GuardianFilterContainsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class GuardianFilterContainsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class GuardianFilterContainsTypedDict(TypedDict):
    r"""Contains filters for Guardian"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianFilterContainsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[List[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[List[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianFilterContainsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[List[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[List[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianFilterContains(BaseModel):
    r"""Contains filters for Guardian"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianFilterContainsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the guardian"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianFilterContainsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="studentIDs")] = (
        None
    )
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GuardianFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GuardianFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GuardianFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GuardianFilterNotContainsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class GuardianFilterNotContainsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class GuardianFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Guardian"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[List[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[List[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianFilterNotContainsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[List[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[List[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianFilterNotContains(BaseModel):
    r"""Not contains filters for Guardian"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianFilterNotContainsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the guardian"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianFilterNotContainsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="studentIDs")] = (
        None
    )
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""


class GuardianFilterLikeMeta(BaseModel):
    r"""Metadata information for the Guardian"""


class GuardianFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterLikeAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianFilterLikeAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterLikeMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianFilterLikeAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""


class GuardianFilterLike(BaseModel):
    r"""LIKE filters for Guardian"""

    meta: OptionalNullable[GuardianFilterLikeMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianFilterLikeAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""


class GuardianFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the Guardian"""


class GuardianFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotLikeAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianFilterNotLikeAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianFilterNotLikeAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""


class GuardianFilterNotLike(BaseModel):
    r"""NOT LIKE filters for Guardian"""

    meta: OptionalNullable[GuardianFilterNotLikeMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianFilterNotLikeAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GuardianFilterNullMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GuardianFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNullAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class GuardianFilterNullAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNullTypedDict(TypedDict):
    r"""Null filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterNullMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianFilterNullAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianFilterNull(BaseModel):
    r"""Null filters for Guardian"""

    meta: OptionalNullable[GuardianFilterNullMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianFilterNullAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GuardianFilterNotNullMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GuardianFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotNullAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class GuardianFilterNotNullAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for Guardian"""

    meta: NotRequired[Nullable[GuardianFilterNotNullMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianFilterNotNullAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianFilterNotNull(BaseModel):
    r"""Not null filters for Guardian"""

    meta: OptionalNullable[GuardianFilterNotNullMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianFilterNotNullAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianFilterTypedDict(TypedDict):
    r"""Filter object for Guardian"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[GuardianFilterEqualsTypedDict]]
    r"""Equality filters for Guardian"""
    not_equals: NotRequired[Nullable[GuardianFilterNotEqualsTypedDict]]
    r"""Inequality filters for Guardian"""
    greater_than: NotRequired[Nullable[GuardianFilterGreaterThanTypedDict]]
    r"""Greater than filters for Guardian"""
    smaller_than: NotRequired[Nullable[GuardianFilterSmallerThanTypedDict]]
    r"""Smaller than filters for Guardian"""
    greater_or_equal: NotRequired[Nullable[GuardianFilterGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Guardian"""
    smaller_or_equal: NotRequired[Nullable[GuardianFilterSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Guardian"""
    contains: NotRequired[Nullable[GuardianFilterContainsTypedDict]]
    r"""Contains filters for Guardian"""
    not_contains: NotRequired[Nullable[GuardianFilterNotContainsTypedDict]]
    r"""Not contains filters for Guardian"""
    like: NotRequired[Nullable[GuardianFilterLikeTypedDict]]
    r"""LIKE filters for Guardian"""
    not_like: NotRequired[Nullable[GuardianFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for Guardian"""
    null: NotRequired[Nullable[GuardianFilterNullTypedDict]]
    r"""Null filters for Guardian"""
    not_null: NotRequired[Nullable[GuardianFilterNotNullTypedDict]]
    r"""Not null filters for Guardian"""
    nested_filters: NotRequired[List[GuardianFilterTypedDict]]
    r"""NestedFilters of the Guardian, useful for more complex filters"""


class GuardianFilter(BaseModel):
    r"""Filter object for Guardian"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[GuardianFilterEquals] = UNSET
    r"""Equality filters for Guardian"""

    not_equals: Annotated[
        OptionalNullable[GuardianFilterNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Guardian"""

    greater_than: Annotated[
        OptionalNullable[GuardianFilterGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Guardian"""

    smaller_than: Annotated[
        OptionalNullable[GuardianFilterSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Guardian"""

    greater_or_equal: Annotated[
        OptionalNullable[GuardianFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Guardian"""

    smaller_or_equal: Annotated[
        OptionalNullable[GuardianFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Guardian"""

    contains: OptionalNullable[GuardianFilterContains] = UNSET
    r"""Contains filters for Guardian"""

    not_contains: Annotated[
        OptionalNullable[GuardianFilterNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Guardian"""

    like: OptionalNullable[GuardianFilterLike] = UNSET
    r"""LIKE filters for Guardian"""

    not_like: Annotated[
        OptionalNullable[GuardianFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Guardian"""

    null: OptionalNullable[GuardianFilterNull] = UNSET
    r"""Null filters for Guardian"""

    not_null: Annotated[
        OptionalNullable[GuardianFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Guardian"""

    nested_filters: Annotated[
        Optional[List[GuardianFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Guardian, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
