"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .guardianfilter import GuardianFilter, GuardianFilterTypedDict
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class GuardianSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GuardianSearchEqualsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchEqualsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianSearchEqualsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for Guardian"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianSearchEqualsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianSearchEqualsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianSearchEquals(BaseModel):
    r"""Equality filters for Guardian"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianSearchEqualsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianSearchEqualsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class GuardianSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotEqualsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianSearchNotEqualsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Guardian"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianSearchNotEqualsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianSearchNotEquals(BaseModel):
    r"""Inequality filters for Guardian"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianSearchNotEqualsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[str], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchGreaterThanAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianSearchGreaterThanAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianSearchGreaterThanAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianSearchGreaterThan(BaseModel):
    r"""Greater than filters for Guardian"""

    meta: OptionalNullable[GuardianSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianSearchGreaterThanAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchSmallerThanAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianSearchSmallerThanAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianSearchSmallerThanAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianSearchSmallerThan(BaseModel):
    r"""Smaller than filters for Guardian"""

    meta: OptionalNullable[GuardianSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianSearchSmallerThanAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchGreaterOrEqualAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianSearchGreaterOrEqualAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianSearchGreaterOrEqualAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Guardian"""

    meta: OptionalNullable[GuardianSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianSearchGreaterOrEqualAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class GuardianSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""


class GuardianSearchSmallerOrEqualAddressTypedDict(TypedDict):
    r"""The address of the guardian"""


class GuardianSearchSmallerOrEqualAddress(BaseModel):
    r"""The address of the guardian"""


class GuardianSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianSearchSmallerOrEqualAddressTypedDict]]
    r"""The address of the guardian"""


class GuardianSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Guardian"""

    meta: OptionalNullable[GuardianSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianSearchSmallerOrEqualAddress] = UNSET
    r"""The address of the guardian"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "address"]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GuardianSearchContainsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GuardianSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GuardianSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GuardianSearchContainsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class GuardianSearchContainsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class GuardianSearchContainsTypedDict(TypedDict):
    r"""Contains filters for Guardian"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianSearchContainsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[List[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[List[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianSearchContainsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[List[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[List[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianSearchContains(BaseModel):
    r"""Contains filters for Guardian"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianSearchContainsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the guardian"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianSearchContainsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="studentIDs")] = (
        None
    )
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class GuardianSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class GuardianSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class GuardianSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class GuardianSearchNotContainsAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class GuardianSearchNotContainsAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class GuardianSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Guardian"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Guardian"""
    meta: NotRequired[Nullable[GuardianSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the guardian"""
    first_name: NotRequired[List[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[List[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianSearchNotContainsAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[List[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[List[str]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianSearchNotContains(BaseModel):
    r"""Not contains filters for Guardian"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Guardian"""

    meta: OptionalNullable[GuardianSearchNotContainsMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the guardian, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the guardian"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the guardian"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianSearchNotContainsAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[Optional[List[str]], pydantic.Field(alias="studentIDs")] = (
        None
    )
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""


class GuardianSearchLikeMeta(BaseModel):
    r"""Metadata information for the Guardian"""


class GuardianSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchLikeAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianSearchLikeAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchLikeMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianSearchLikeAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""


class GuardianSearchLike(BaseModel):
    r"""LIKE filters for Guardian"""

    meta: OptionalNullable[GuardianSearchLikeMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianSearchLikeAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""


class GuardianSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the Guardian"""


class GuardianSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class GuardianSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotLikeAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class GuardianSearchNotLikeAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the guardian, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the guardian"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the guardian"""
    address: NotRequired[Nullable[GuardianSearchNotLikeAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[str]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""


class GuardianSearchNotLike(BaseModel):
    r"""NOT LIKE filters for Guardian"""

    meta: OptionalNullable[GuardianSearchNotLikeMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the guardian, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the guardian"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the guardian"""

    address: OptionalNullable[GuardianSearchNotLikeAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GuardianSearchNullMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GuardianSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNullAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class GuardianSearchNullAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNullTypedDict(TypedDict):
    r"""Null filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchNullMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianSearchNullAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianSearchNull(BaseModel):
    r"""Null filters for Guardian"""

    meta: OptionalNullable[GuardianSearchNullMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianSearchNullAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Guardian"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class GuardianSearchNotNullMeta(BaseModel):
    r"""Metadata information for the Guardian"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class GuardianSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotNullAddressTypedDict(TypedDict):
    r"""The address of the guardian"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class GuardianSearchNotNullAddress(BaseModel):
    r"""The address of the guardian"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for Guardian"""

    meta: NotRequired[Nullable[GuardianSearchNotNullMetaTypedDict]]
    r"""Metadata information for the Guardian"""
    external: NotRequired[Nullable[GuardianSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""
    address: NotRequired[Nullable[GuardianSearchNotNullAddressTypedDict]]
    r"""The address of the guardian"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""
    student_i_ds: NotRequired[Nullable[bool]]
    r"""The IDs of the students the guardian is responsible for."""


class GuardianSearchNotNull(BaseModel):
    r"""Not null filters for Guardian"""

    meta: OptionalNullable[GuardianSearchNotNullMeta] = UNSET
    r"""Metadata information for the Guardian"""

    external: OptionalNullable[GuardianSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the guardian from another system, used for third-party integration tracking."""

    address: OptionalNullable[GuardianSearchNotNullAddress] = UNSET
    r"""The address of the guardian"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The email address of the guardian, will be used for communication with the guardian from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the guardian, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the guardian, will be used for communication with the guardian from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the guardian, will not be used within the system, but will be displayed for contact information."""

    student_i_ds: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="studentIDs")
    ] = UNSET
    r"""The IDs of the students the guardian is responsible for."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        nullable_fields = [
            "meta",
            "external",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
            "studentIDs",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[GuardianSearchEqualsTypedDict]]
    r"""Equality filters for Guardian"""
    not_equals: NotRequired[Nullable[GuardianSearchNotEqualsTypedDict]]
    r"""Inequality filters for Guardian"""
    greater_than: NotRequired[Nullable[GuardianSearchGreaterThanTypedDict]]
    r"""Greater than filters for Guardian"""
    smaller_than: NotRequired[Nullable[GuardianSearchSmallerThanTypedDict]]
    r"""Smaller than filters for Guardian"""
    greater_or_equal: NotRequired[Nullable[GuardianSearchGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Guardian"""
    smaller_or_equal: NotRequired[Nullable[GuardianSearchSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Guardian"""
    contains: NotRequired[Nullable[GuardianSearchContainsTypedDict]]
    r"""Contains filters for Guardian"""
    not_contains: NotRequired[Nullable[GuardianSearchNotContainsTypedDict]]
    r"""Not contains filters for Guardian"""
    like: NotRequired[Nullable[GuardianSearchLikeTypedDict]]
    r"""LIKE filters for Guardian"""
    not_like: NotRequired[Nullable[GuardianSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for Guardian"""
    null: NotRequired[Nullable[GuardianSearchNullTypedDict]]
    r"""Null filters for Guardian"""
    not_null: NotRequired[Nullable[GuardianSearchNotNullTypedDict]]
    r"""Not null filters for Guardian"""
    nested_filters: NotRequired[List[GuardianFilterTypedDict]]
    r"""NestedFilters of the Guardian, useful for more complex filters"""


class GuardianSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[GuardianSearchEquals] = UNSET
    r"""Equality filters for Guardian"""

    not_equals: Annotated[
        OptionalNullable[GuardianSearchNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Guardian"""

    greater_than: Annotated[
        OptionalNullable[GuardianSearchGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Guardian"""

    smaller_than: Annotated[
        OptionalNullable[GuardianSearchSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Guardian"""

    greater_or_equal: Annotated[
        OptionalNullable[GuardianSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Guardian"""

    smaller_or_equal: Annotated[
        OptionalNullable[GuardianSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Guardian"""

    contains: OptionalNullable[GuardianSearchContains] = UNSET
    r"""Contains filters for Guardian"""

    not_contains: Annotated[
        OptionalNullable[GuardianSearchNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Guardian"""

    like: OptionalNullable[GuardianSearchLike] = UNSET
    r"""LIKE filters for Guardian"""

    not_like: Annotated[
        OptionalNullable[GuardianSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Guardian"""

    null: OptionalNullable[GuardianSearchNull] = UNSET
    r"""Null filters for Guardian"""

    not_null: Annotated[
        OptionalNullable[GuardianSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Guardian"""

    nested_filters: Annotated[
        Optional[List[GuardianFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Guardian, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class GuardianSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: GuardianSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class GuardianSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[GuardianSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
