"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: datetime
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class SchoolMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[datetime, pydantic.Field(alias="createdAt")]
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


SchoolSchoolType = Literal[
    "GR",
    "GY",
    "FS",
]
r"""Type of schooling provided at the school"""


class SchoolTypedDict(TypedDict):
    r"""The `School` resource represents a school where daily operations occur. A school must exist before you can create StudentPlacements, EmployeePlacements, or Groups.

    This resource can be created, Updated, listed, retrieved, and deleted using the standard resource structure. It **does not** support search and filtering.

    """

    id: str
    r"""Unique identifier for the School"""
    title: str
    r"""The title of the school"""
    school_type: SchoolSchoolType
    r"""Type of schooling provided at the school"""
    meta: NotRequired[SchoolMetaTypedDict]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class School(BaseModel):
    r"""The `School` resource represents a school where daily operations occur. A school must exist before you can create StudentPlacements, EmployeePlacements, or Groups.

    This resource can be created, Updated, listed, retrieved, and deleted using the standard resource structure. It **does not** support search and filtering.

    """

    id: str
    r"""Unique identifier for the School"""

    title: str
    r"""The title of the school"""

    school_type: Annotated[SchoolSchoolType, pydantic.Field(alias="schoolType")]
    r"""Type of schooling provided at the school"""

    meta: Optional[SchoolMeta] = None
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = ["external", "unitCode", "csnSchoolCode", "municipalityCode"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
