"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schoollist import SchoolList, SchoolListTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolListRequestTypedDict(TypedDict):
    limit: NotRequired[int]
    r"""The maximum number of Schools to return (default: 50) when listing Schools"""
    offset: NotRequired[int]
    r"""The number of Schools to skip before starting to return results (default: 0) when listing Schools"""


class SchoolListRequest(BaseModel):
    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Schools to return (default: 50) when listing Schools"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Schools to skip before starting to return results (default: 0) when listing Schools"""


class SchoolListResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: SchoolListTypedDict


class SchoolListResponse(BaseModel):
    next: Union[
        Callable[[], Optional[SchoolListResponse]],
        Callable[[], Awaitable[Optional[SchoolListResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: SchoolList
