"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schoolfilter import SchoolFilter, SchoolFilterTypedDict
from .schooltype import SchoolType
from datetime import datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class SchoolSearchEqualsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


SchoolSearchEqualsSchoolType = Literal[
    "GR",
    "GY",
    "FS",
]
r"""Type of schooling provided at the school"""


class SchoolSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for School"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolSearchEqualsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[Nullable[SchoolSearchEqualsSchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolSearchEquals(BaseModel):
    r"""Equality filters for School"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolSearchEqualsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        OptionalNullable[SchoolSearchEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class SchoolSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


SchoolSearchNotEqualsSchoolType = Literal[
    "GR",
    "GY",
    "FS",
]
r"""Type of schooling provided at the school"""


class SchoolSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for School"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[Nullable[SchoolSearchNotEqualsSchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolSearchNotEquals(BaseModel):
    r"""Inequality filters for School"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        OptionalNullable[SchoolSearchNotEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for School"""

    meta: NotRequired[Nullable[SchoolSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchGreaterThan(BaseModel):
    r"""Greater than filters for School"""

    meta: OptionalNullable[SchoolSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for School"""

    meta: NotRequired[Nullable[SchoolSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchSmallerThan(BaseModel):
    r"""Smaller than filters for School"""

    meta: OptionalNullable[SchoolSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for School"""

    meta: NotRequired[Nullable[SchoolSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for School"""

    meta: OptionalNullable[SchoolSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class SchoolSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the School"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for School"""

    meta: NotRequired[Nullable[SchoolSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""


class SchoolSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for School"""

    meta: OptionalNullable[SchoolSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external"]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class SchoolSearchContainsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class SchoolSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class SchoolSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class SchoolSearchContainsTypedDict(TypedDict):
    r"""Contains filters for School"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolSearchContainsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[List[str]]
    r"""The title of the school"""
    unit_code: NotRequired[List[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[List[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[List[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[List[SchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolSearchContains(BaseModel):
    r"""Contains filters for School"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolSearchContainsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: Optional[List[str]] = None
    r"""The title of the school"""

    unit_code: Annotated[Optional[List[str]], pydantic.Field(alias="unitCode")] = None
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="csnSchoolCode")
    ] = None
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        Optional[List[SchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class SchoolSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class SchoolSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class SchoolSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class SchoolSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for School"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the School"""
    meta: NotRequired[Nullable[SchoolSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[List[str]]
    r"""The title of the school"""
    unit_code: NotRequired[List[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[List[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[List[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""
    school_type: NotRequired[List[SchoolType]]
    r"""Type of schooling provided at the school"""


class SchoolSearchNotContains(BaseModel):
    r"""Not contains filters for School"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the School"""

    meta: OptionalNullable[SchoolSearchNotContainsMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: Optional[List[str]] = None
    r"""The title of the school"""

    unit_code: Annotated[Optional[List[str]], pydantic.Field(alias="unitCode")] = None
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="csnSchoolCode")
    ] = None
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    school_type: Annotated[
        Optional[List[SchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""Type of schooling provided at the school"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
            "schoolType",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""


class SchoolSearchLikeMeta(BaseModel):
    r"""Metadata information for the School"""


class SchoolSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for School"""

    meta: NotRequired[Nullable[SchoolSearchLikeMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolSearchLike(BaseModel):
    r"""LIKE filters for School"""

    meta: OptionalNullable[SchoolSearchLikeMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""


class SchoolSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the School"""


class SchoolSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class SchoolSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for School"""

    meta: NotRequired[Nullable[SchoolSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    title: NotRequired[Nullable[str]]
    r"""The title of the school"""
    unit_code: NotRequired[Nullable[str]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[str]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[str]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolSearchNotLike(BaseModel):
    r"""NOT LIKE filters for School"""

    meta: OptionalNullable[SchoolSearchNotLikeMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    title: OptionalNullable[str] = UNSET
    r"""The title of the school"""

    unit_code: Annotated[OptionalNullable[str], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "title",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class SchoolSearchNullMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class SchoolSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNullTypedDict(TypedDict):
    r"""Null filters for School"""

    meta: NotRequired[Nullable[SchoolSearchNullMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    unit_code: NotRequired[Nullable[bool]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[bool]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolSearchNull(BaseModel):
    r"""Null filters for School"""

    meta: OptionalNullable[SchoolSearchNullMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    unit_code: Annotated[OptionalNullable[bool], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the School"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class SchoolSearchNotNullMeta(BaseModel):
    r"""Metadata information for the School"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class SchoolSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for School"""

    meta: NotRequired[Nullable[SchoolSearchNotNullMetaTypedDict]]
    r"""Metadata information for the School"""
    external: NotRequired[Nullable[SchoolSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""
    unit_code: NotRequired[Nullable[bool]]
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""
    csn_school_code: NotRequired[Nullable[bool]]
    r"""The School Code provided by CSN, required for reports to CSN"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""Municipality code of the school, is used in reports and printed on grade documents"""


class SchoolSearchNotNull(BaseModel):
    r"""Not null filters for School"""

    meta: OptionalNullable[SchoolSearchNotNullMeta] = UNSET
    r"""Metadata information for the School"""

    external: OptionalNullable[SchoolSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the school from another system, used for third-party integration tracking."""

    unit_code: Annotated[OptionalNullable[bool], pydantic.Field(alias="unitCode")] = (
        UNSET
    )
    r"""The School Unit Code provided by SCB, is used in reports and printed on grade documents"""

    csn_school_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="csnSchoolCode")
    ] = UNSET
    r"""The School Code provided by CSN, required for reports to CSN"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""Municipality code of the school, is used in reports and printed on grade documents"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "meta",
            "external",
            "unitCode",
            "csnSchoolCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[SchoolSearchEqualsTypedDict]]
    r"""Equality filters for School"""
    not_equals: NotRequired[Nullable[SchoolSearchNotEqualsTypedDict]]
    r"""Inequality filters for School"""
    greater_than: NotRequired[Nullable[SchoolSearchGreaterThanTypedDict]]
    r"""Greater than filters for School"""
    smaller_than: NotRequired[Nullable[SchoolSearchSmallerThanTypedDict]]
    r"""Smaller than filters for School"""
    greater_or_equal: NotRequired[Nullable[SchoolSearchGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for School"""
    smaller_or_equal: NotRequired[Nullable[SchoolSearchSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for School"""
    contains: NotRequired[Nullable[SchoolSearchContainsTypedDict]]
    r"""Contains filters for School"""
    not_contains: NotRequired[Nullable[SchoolSearchNotContainsTypedDict]]
    r"""Not contains filters for School"""
    like: NotRequired[Nullable[SchoolSearchLikeTypedDict]]
    r"""LIKE filters for School"""
    not_like: NotRequired[Nullable[SchoolSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for School"""
    null: NotRequired[Nullable[SchoolSearchNullTypedDict]]
    r"""Null filters for School"""
    not_null: NotRequired[Nullable[SchoolSearchNotNullTypedDict]]
    r"""Not null filters for School"""
    nested_filters: NotRequired[List[SchoolFilterTypedDict]]
    r"""NestedFilters of the School, useful for more complex filters"""


class SchoolSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[SchoolSearchEquals] = UNSET
    r"""Equality filters for School"""

    not_equals: Annotated[
        OptionalNullable[SchoolSearchNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for School"""

    greater_than: Annotated[
        OptionalNullable[SchoolSearchGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for School"""

    smaller_than: Annotated[
        OptionalNullable[SchoolSearchSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for School"""

    greater_or_equal: Annotated[
        OptionalNullable[SchoolSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for School"""

    smaller_or_equal: Annotated[
        OptionalNullable[SchoolSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for School"""

    contains: OptionalNullable[SchoolSearchContains] = UNSET
    r"""Contains filters for School"""

    not_contains: Annotated[
        OptionalNullable[SchoolSearchNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for School"""

    like: OptionalNullable[SchoolSearchLike] = UNSET
    r"""LIKE filters for School"""

    not_like: Annotated[
        OptionalNullable[SchoolSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for School"""

    null: OptionalNullable[SchoolSearchNull] = UNSET
    r"""Null filters for School"""

    not_null: Annotated[
        OptionalNullable[SchoolSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for School"""

    nested_filters: Annotated[
        Optional[List[SchoolFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the School, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class SchoolSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: SchoolSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class SchoolSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[SchoolSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
