"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schoolsearch_requestbody import (
    SchoolSearchRequestBody,
    SchoolSearchRequestBodyTypedDict,
)
from .schoolsearch_response import SchoolSearchResponse, SchoolSearchResponseTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class SchoolSearchRequestTypedDict(TypedDict):
    school_search: SchoolSearchRequestBodyTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Schools to return (default: 50) when searching Schools"""
    offset: NotRequired[int]
    r"""The number of Schools to skip before starting to return results (default: 0) when searching Schools"""


class SchoolSearchRequest(BaseModel):
    school_search: Annotated[
        SchoolSearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Schools to return (default: 50) when searching Schools"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Schools to skip before starting to return results (default: 0) when searching Schools"""


class SchoolSearchResponseResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: SchoolSearchResponseTypedDict


class SchoolSearchResponseResponse(BaseModel):
    next: Union[
        Callable[[], Optional[SchoolSearchResponseResponse]],
        Callable[[], Awaitable[Optional[SchoolSearchResponseResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: SchoolSearchResponse
