"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .gender import Gender
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentFilterEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentFilterEqualsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentFilterEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentFilterEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the student"""


class StudentFilterEqualsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentFilterEqualsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterEqualsTypedDict(TypedDict):
    r"""Equality filters for Student"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentFilterEqualsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[StudentFilterEqualsGender]]
    r"""The gender of the student"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterEqualsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterEquals(BaseModel):
    r"""Equality filters for Student"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentFilterEqualsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[StudentFilterEqualsGender] = UNSET
    r"""The gender of the student"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterEqualsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentFilterNotEqualsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentFilterNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentFilterNotEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the student"""


class StudentFilterNotEqualsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentFilterNotEqualsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Student"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentFilterNotEqualsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[StudentFilterNotEqualsGender]]
    r"""The gender of the student"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterNotEqualsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterNotEquals(BaseModel):
    r"""Inequality filters for Student"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentFilterNotEqualsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[StudentFilterNotEqualsGender] = UNSET
    r"""The gender of the student"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterNotEqualsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentFilterGreaterThanMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterGreaterThanAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentFilterGreaterThanAddress(BaseModel):
    r"""The address of the student"""


class StudentFilterGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Student"""

    meta: NotRequired[Nullable[StudentFilterGreaterThanMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterGreaterThanAddressTypedDict]]
    r"""The address of the student"""


class StudentFilterGreaterThan(BaseModel):
    r"""Greater than filters for Student"""

    meta: OptionalNullable[StudentFilterGreaterThanMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterGreaterThanAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentFilterSmallerThanMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterSmallerThanAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentFilterSmallerThanAddress(BaseModel):
    r"""The address of the student"""


class StudentFilterSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Student"""

    meta: NotRequired[Nullable[StudentFilterSmallerThanMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterSmallerThanAddressTypedDict]]
    r"""The address of the student"""


class StudentFilterSmallerThan(BaseModel):
    r"""Smaller than filters for Student"""

    meta: OptionalNullable[StudentFilterSmallerThanMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterSmallerThanAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentFilterGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterGreaterOrEqualAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentFilterGreaterOrEqualAddress(BaseModel):
    r"""The address of the student"""


class StudentFilterGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Student"""

    meta: NotRequired[Nullable[StudentFilterGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterGreaterOrEqualAddressTypedDict]]
    r"""The address of the student"""


class StudentFilterGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Student"""

    meta: OptionalNullable[StudentFilterGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterGreaterOrEqualAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentFilterSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentFilterSmallerOrEqualAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentFilterSmallerOrEqualAddress(BaseModel):
    r"""The address of the student"""


class StudentFilterSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Student"""

    meta: NotRequired[Nullable[StudentFilterSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterSmallerOrEqualAddressTypedDict]]
    r"""The address of the student"""


class StudentFilterSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Student"""

    meta: OptionalNullable[StudentFilterSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterSmallerOrEqualAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentFilterContainsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentFilterContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentFilterContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentFilterContainsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class StudentFilterContainsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class StudentFilterContainsTypedDict(TypedDict):
    r"""Contains filters for Student"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentFilterContainsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the student"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[List[str]]
    r"""The first name of the student"""
    last_name: NotRequired[List[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterContainsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterContains(BaseModel):
    r"""Contains filters for Student"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentFilterContainsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the student"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the student"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the student"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterContainsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentFilterNotContainsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentFilterNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentFilterNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentFilterNotContainsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class StudentFilterNotContainsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class StudentFilterNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Student"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentFilterNotContainsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the student"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[List[str]]
    r"""The first name of the student"""
    last_name: NotRequired[List[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterNotContainsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterNotContains(BaseModel):
    r"""Not contains filters for Student"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentFilterNotContainsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the student"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the student"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the student"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterNotContainsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""


class StudentFilterLikeMeta(BaseModel):
    r"""Metadata information for the Student"""


class StudentFilterLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentFilterLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterLikeAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentFilterLikeAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterLikeTypedDict(TypedDict):
    r"""LIKE filters for Student"""

    meta: NotRequired[Nullable[StudentFilterLikeMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    address: NotRequired[Nullable[StudentFilterLikeAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterLike(BaseModel):
    r"""LIKE filters for Student"""

    meta: OptionalNullable[StudentFilterLikeMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    address: OptionalNullable[StudentFilterLikeAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""


class StudentFilterNotLikeMeta(BaseModel):
    r"""Metadata information for the Student"""


class StudentFilterNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentFilterNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotLikeAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentFilterNotLikeAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Student"""

    meta: NotRequired[Nullable[StudentFilterNotLikeMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    address: NotRequired[Nullable[StudentFilterNotLikeAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterNotLike(BaseModel):
    r"""NOT LIKE filters for Student"""

    meta: OptionalNullable[StudentFilterNotLikeMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    address: OptionalNullable[StudentFilterNotLikeAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentFilterNullMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentFilterNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNullAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class StudentFilterNullAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNullTypedDict(TypedDict):
    r"""Null filters for Student"""

    meta: NotRequired[Nullable[StudentFilterNullMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the student"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterNullAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterNull(BaseModel):
    r"""Null filters for Student"""

    meta: OptionalNullable[StudentFilterNullMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the student"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterNullAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentFilterNotNullMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentFilterNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotNullAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class StudentFilterNotNullAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterNotNullTypedDict(TypedDict):
    r"""Not null filters for Student"""

    meta: NotRequired[Nullable[StudentFilterNotNullMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentFilterNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the student"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentFilterNotNullAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentFilterNotNull(BaseModel):
    r"""Not null filters for Student"""

    meta: OptionalNullable[StudentFilterNotNullMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentFilterNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the student"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentFilterNotNullAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentFilterTypedDict(TypedDict):
    r"""Filter object for Student"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[StudentFilterEqualsTypedDict]]
    r"""Equality filters for Student"""
    not_equals: NotRequired[Nullable[StudentFilterNotEqualsTypedDict]]
    r"""Inequality filters for Student"""
    greater_than: NotRequired[Nullable[StudentFilterGreaterThanTypedDict]]
    r"""Greater than filters for Student"""
    smaller_than: NotRequired[Nullable[StudentFilterSmallerThanTypedDict]]
    r"""Smaller than filters for Student"""
    greater_or_equal: NotRequired[Nullable[StudentFilterGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Student"""
    smaller_or_equal: NotRequired[Nullable[StudentFilterSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Student"""
    contains: NotRequired[Nullable[StudentFilterContainsTypedDict]]
    r"""Contains filters for Student"""
    not_contains: NotRequired[Nullable[StudentFilterNotContainsTypedDict]]
    r"""Not contains filters for Student"""
    like: NotRequired[Nullable[StudentFilterLikeTypedDict]]
    r"""LIKE filters for Student"""
    not_like: NotRequired[Nullable[StudentFilterNotLikeTypedDict]]
    r"""NOT LIKE filters for Student"""
    null: NotRequired[Nullable[StudentFilterNullTypedDict]]
    r"""Null filters for Student"""
    not_null: NotRequired[Nullable[StudentFilterNotNullTypedDict]]
    r"""Not null filters for Student"""
    nested_filters: NotRequired[List[StudentFilterTypedDict]]
    r"""NestedFilters of the Student, useful for more complex filters"""


class StudentFilter(BaseModel):
    r"""Filter object for Student"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[StudentFilterEquals] = UNSET
    r"""Equality filters for Student"""

    not_equals: Annotated[
        OptionalNullable[StudentFilterNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Student"""

    greater_than: Annotated[
        OptionalNullable[StudentFilterGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Student"""

    smaller_than: Annotated[
        OptionalNullable[StudentFilterSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Student"""

    greater_or_equal: Annotated[
        OptionalNullable[StudentFilterGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Student"""

    smaller_or_equal: Annotated[
        OptionalNullable[StudentFilterSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Student"""

    contains: OptionalNullable[StudentFilterContains] = UNSET
    r"""Contains filters for Student"""

    not_contains: Annotated[
        OptionalNullable[StudentFilterNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Student"""

    like: OptionalNullable[StudentFilterLike] = UNSET
    r"""LIKE filters for Student"""

    not_like: Annotated[
        OptionalNullable[StudentFilterNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Student"""

    null: OptionalNullable[StudentFilterNull] = UNSET
    r"""Null filters for Student"""

    not_null: Annotated[
        OptionalNullable[StudentFilterNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Student"""

    nested_filters: Annotated[
        Optional[List[StudentFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Student, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m
