"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .studentlist import StudentList, StudentListTypedDict
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentListRequestTypedDict(TypedDict):
    limit: NotRequired[int]
    r"""The maximum number of Students to return (default: 50) when listing Students"""
    offset: NotRequired[int]
    r"""The number of Students to skip before starting to return results (default: 0) when listing Students"""


class StudentListRequest(BaseModel):
    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Students to return (default: 50) when listing Students"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Students to skip before starting to return results (default: 0) when listing Students"""


class StudentListResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: StudentListTypedDict


class StudentListResponse(BaseModel):
    next: Union[
        Callable[[], Optional[StudentListResponse]],
        Callable[[], Awaitable[Optional[StudentListResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: StudentList
