"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .schoolyear import SchoolYear
from .studentplacementfilter import (
    StudentPlacementFilter,
    StudentPlacementFilterTypedDict,
)
from .studentplacementschooltype import StudentPlacementSchoolType
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentPlacementSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentPlacementSearchEqualsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentPlacementSearchEqualsSchoolType = Literal[
    "GR",
    "GRAN",
    "GY",
    "GYAN",
    "FS",
]
r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""


StudentPlacementSearchEqualsSchoolYear = Literal[
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
]
r"""The school year the student is placed in"""


class StudentPlacementSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for StudentPlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementSearchEqualsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[Nullable[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[Nullable[StudentPlacementSearchEqualsSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[Nullable[StudentPlacementSearchEqualsSchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[Nullable[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchEquals(BaseModel):
    r"""Equality filters for StudentPlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchEqualsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[OptionalNullable[str], pydantic.Field(alias="studentID")] = (
        UNSET
    )
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        OptionalNullable[StudentPlacementSearchEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        OptionalNullable[StudentPlacementSearchEqualsSchoolYear],
        pydantic.Field(alias="schoolYear"),
    ] = UNSET
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="hasChildcare")
    ] = UNSET
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentPlacementSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentPlacementSearchNotEqualsSchoolType = Literal[
    "GR",
    "GRAN",
    "GY",
    "GYAN",
    "FS",
]
r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""


StudentPlacementSearchNotEqualsSchoolYear = Literal[
    "0",
    "1",
    "2",
    "3",
    "4",
    "5",
    "6",
    "7",
    "8",
    "9",
]
r"""The school year the student is placed in"""


class StudentPlacementSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for StudentPlacement"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[Nullable[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[Nullable[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[Nullable[StudentPlacementSearchNotEqualsSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[Nullable[StudentPlacementSearchNotEqualsSchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[Nullable[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchNotEquals(BaseModel):
    r"""Inequality filters for StudentPlacement"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[OptionalNullable[str], pydantic.Field(alias="studentID")] = (
        UNSET
    )
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[OptionalNullable[str], pydantic.Field(alias="schoolID")] = (
        UNSET
    )
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        OptionalNullable[StudentPlacementSearchNotEqualsSchoolType],
        pydantic.Field(alias="schoolType"),
    ] = UNSET
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        OptionalNullable[StudentPlacementSearchNotEqualsSchoolYear],
        pydantic.Field(alias="schoolYear"),
    ] = UNSET
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="hasChildcare")
    ] = UNSET
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchGreaterThan(BaseModel):
    r"""Greater than filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchSmallerThan(BaseModel):
    r"""Smaller than filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[
        Nullable[StudentPlacementSearchGreaterOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentPlacementSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""


class StudentPlacementSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[
        Nullable[StudentPlacementSearchSmallerOrEqualExternalTypedDict]
    ]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    start_date: NotRequired[Nullable[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[Nullable[date]]
    r"""The end date of the placement"""
    archived_at: NotRequired[Nullable[datetime]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    start_date: Annotated[OptionalNullable[date], pydantic.Field(alias="startDate")] = (
        UNSET
    )
    r"""The start date of the placement"""

    end_date: Annotated[OptionalNullable[date], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archived_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        nullable_fields = ["meta", "external", "startDate", "endDate", "archivedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentPlacementSearchContainsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentPlacementSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentPlacementSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentPlacementSearchContainsTypedDict(TypedDict):
    r"""Contains filters for StudentPlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementSearchContainsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[List[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[List[StudentPlacementSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[List[SchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[List[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[List[str]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementSearchContains(BaseModel):
    r"""Contains filters for StudentPlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchContainsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[Optional[List[str]], pydantic.Field(alias="studentID")] = None
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        Optional[List[StudentPlacementSchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        Optional[List[SchoolYear]], pydantic.Field(alias="schoolYear")
    ] = None
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        Optional[List[bool]], pydantic.Field(alias="hasChildcare")
    ] = None
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        Optional[List[str]], pydantic.Field(alias="motherTongue")
    ] = None
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentPlacementSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentPlacementSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentPlacementSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentPlacementSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for StudentPlacement"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the StudentPlacement"""
    meta: NotRequired[Nullable[StudentPlacementSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    student_id: NotRequired[List[str]]
    r"""The ID of the student the placement belongs to"""
    school_id: NotRequired[List[str]]
    r"""The ID of the school the student is placed in"""
    school_type: NotRequired[List[StudentPlacementSchoolType]]
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""
    school_year: NotRequired[List[SchoolYear]]
    r"""The school year the student is placed in"""
    has_childcare: NotRequired[List[bool]]
    r"""Whether the student has childcare"""
    mother_tongue: NotRequired[List[str]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    start_date: NotRequired[List[date]]
    r"""The start date of the placement"""
    end_date: NotRequired[List[date]]
    r"""The end date of the placement"""
    archive_year: NotRequired[List[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementSearchNotContains(BaseModel):
    r"""Not contains filters for StudentPlacement"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchNotContainsMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    student_id: Annotated[Optional[List[str]], pydantic.Field(alias="studentID")] = None
    r"""The ID of the student the placement belongs to"""

    school_id: Annotated[Optional[List[str]], pydantic.Field(alias="schoolID")] = None
    r"""The ID of the school the student is placed in"""

    school_type: Annotated[
        Optional[List[StudentPlacementSchoolType]], pydantic.Field(alias="schoolType")
    ] = None
    r"""The school type for the student, if not provided on Create, the school type will be fetched from the school."""

    school_year: Annotated[
        Optional[List[SchoolYear]], pydantic.Field(alias="schoolYear")
    ] = None
    r"""The school year the student is placed in"""

    has_childcare: Annotated[
        Optional[List[bool]], pydantic.Field(alias="hasChildcare")
    ] = None
    r"""Whether the student has childcare"""

    mother_tongue: Annotated[
        Optional[List[str]], pydantic.Field(alias="motherTongue")
    ] = None
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    start_date: Annotated[Optional[List[date]], pydantic.Field(alias="startDate")] = (
        None
    )
    r"""The start date of the placement"""

    end_date: Annotated[Optional[List[date]], pydantic.Field(alias="endDate")] = None
    r"""The end date of the placement"""

    archive_year: Annotated[
        Optional[List[str]], pydantic.Field(alias="archiveYear")
    ] = None
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "studentID",
            "schoolID",
            "schoolType",
            "schoolYear",
            "hasChildcare",
            "motherTongue",
            "startDate",
            "endDate",
            "archiveYear",
        ]
        nullable_fields = ["meta", "external"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementSearchLikeMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchLikeMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementSearchLike(BaseModel):
    r"""LIKE filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchLikeMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "motherTongue", "archiveYear"]
        nullable_fields = ["meta", "external", "motherTongue", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""


class StudentPlacementSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentPlacementSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    mother_tongue: NotRequired[Nullable[str]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    archive_year: NotRequired[Nullable[str]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""


class StudentPlacementSearchNotLike(BaseModel):
    r"""NOT LIKE filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchNotLikeMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    mother_tongue: Annotated[
        OptionalNullable[str], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    archive_year: Annotated[
        OptionalNullable[str], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "motherTongue", "archiveYear"]
        nullable_fields = ["meta", "external", "motherTongue", "archiveYear"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentPlacementSearchNullMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentPlacementSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNullTypedDict(TypedDict):
    r"""Null filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchNullMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    school_year: NotRequired[Nullable[bool]]
    r"""The school year the student is placed in"""
    mother_tongue: NotRequired[Nullable[bool]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchNull(BaseModel):
    r"""Null filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchNullMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    school_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    mother_tongue: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the StudentPlacement"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentPlacementSearchNotNullMeta(BaseModel):
    r"""Metadata information for the StudentPlacement"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentPlacementSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for StudentPlacement"""

    meta: NotRequired[Nullable[StudentPlacementSearchNotNullMetaTypedDict]]
    r"""Metadata information for the StudentPlacement"""
    external: NotRequired[Nullable[StudentPlacementSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""
    school_year: NotRequired[Nullable[bool]]
    r"""The school year the student is placed in"""
    mother_tongue: NotRequired[Nullable[bool]]
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""
    end_date: NotRequired[Nullable[bool]]
    r"""The end date of the placement"""
    archive_year: NotRequired[Nullable[bool]]
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""
    archived_at: NotRequired[Nullable[bool]]
    r"""The timestamp the placement was archived for the student"""


class StudentPlacementSearchNotNull(BaseModel):
    r"""Not null filters for StudentPlacement"""

    meta: OptionalNullable[StudentPlacementSearchNotNullMeta] = UNSET
    r"""Metadata information for the StudentPlacement"""

    external: OptionalNullable[StudentPlacementSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student placement from another system, used for third-party integration tracking."""

    school_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="schoolYear")
    ] = UNSET
    r"""The school year the student is placed in"""

    mother_tongue: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="motherTongue")
    ] = UNSET
    r"""The mother tongue of the student. Language codes follow the ISO 639-3 standard (three-letter codes)."""

    end_date: Annotated[OptionalNullable[bool], pydantic.Field(alias="endDate")] = UNSET
    r"""The end date of the placement"""

    archive_year: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archiveYear")
    ] = UNSET
    r"""The year the placement was archived for the student, in the format YYYY_YYYY where the first year is the autumn and the second year is the spring."""

    archived_at: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="archivedAt")
    ] = UNSET
    r"""The timestamp the placement was archived for the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        nullable_fields = [
            "meta",
            "external",
            "schoolYear",
            "motherTongue",
            "endDate",
            "archiveYear",
            "archivedAt",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[StudentPlacementSearchEqualsTypedDict]]
    r"""Equality filters for StudentPlacement"""
    not_equals: NotRequired[Nullable[StudentPlacementSearchNotEqualsTypedDict]]
    r"""Inequality filters for StudentPlacement"""
    greater_than: NotRequired[Nullable[StudentPlacementSearchGreaterThanTypedDict]]
    r"""Greater than filters for StudentPlacement"""
    smaller_than: NotRequired[Nullable[StudentPlacementSearchSmallerThanTypedDict]]
    r"""Smaller than filters for StudentPlacement"""
    greater_or_equal: NotRequired[
        Nullable[StudentPlacementSearchGreaterOrEqualTypedDict]
    ]
    r"""Greater than or equal filters for StudentPlacement"""
    smaller_or_equal: NotRequired[
        Nullable[StudentPlacementSearchSmallerOrEqualTypedDict]
    ]
    r"""Smaller than or equal filters for StudentPlacement"""
    contains: NotRequired[Nullable[StudentPlacementSearchContainsTypedDict]]
    r"""Contains filters for StudentPlacement"""
    not_contains: NotRequired[Nullable[StudentPlacementSearchNotContainsTypedDict]]
    r"""Not contains filters for StudentPlacement"""
    like: NotRequired[Nullable[StudentPlacementSearchLikeTypedDict]]
    r"""LIKE filters for StudentPlacement"""
    not_like: NotRequired[Nullable[StudentPlacementSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for StudentPlacement"""
    null: NotRequired[Nullable[StudentPlacementSearchNullTypedDict]]
    r"""Null filters for StudentPlacement"""
    not_null: NotRequired[Nullable[StudentPlacementSearchNotNullTypedDict]]
    r"""Not null filters for StudentPlacement"""
    nested_filters: NotRequired[List[StudentPlacementFilterTypedDict]]
    r"""NestedFilters of the StudentPlacement, useful for more complex filters"""


class StudentPlacementSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[StudentPlacementSearchEquals] = UNSET
    r"""Equality filters for StudentPlacement"""

    not_equals: Annotated[
        OptionalNullable[StudentPlacementSearchNotEquals],
        pydantic.Field(alias="notEquals"),
    ] = UNSET
    r"""Inequality filters for StudentPlacement"""

    greater_than: Annotated[
        OptionalNullable[StudentPlacementSearchGreaterThan],
        pydantic.Field(alias="greaterThan"),
    ] = UNSET
    r"""Greater than filters for StudentPlacement"""

    smaller_than: Annotated[
        OptionalNullable[StudentPlacementSearchSmallerThan],
        pydantic.Field(alias="smallerThan"),
    ] = UNSET
    r"""Smaller than filters for StudentPlacement"""

    greater_or_equal: Annotated[
        OptionalNullable[StudentPlacementSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for StudentPlacement"""

    smaller_or_equal: Annotated[
        OptionalNullable[StudentPlacementSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for StudentPlacement"""

    contains: OptionalNullable[StudentPlacementSearchContains] = UNSET
    r"""Contains filters for StudentPlacement"""

    not_contains: Annotated[
        OptionalNullable[StudentPlacementSearchNotContains],
        pydantic.Field(alias="notContains"),
    ] = UNSET
    r"""Not contains filters for StudentPlacement"""

    like: OptionalNullable[StudentPlacementSearchLike] = UNSET
    r"""LIKE filters for StudentPlacement"""

    not_like: Annotated[
        OptionalNullable[StudentPlacementSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for StudentPlacement"""

    null: OptionalNullable[StudentPlacementSearchNull] = UNSET
    r"""Null filters for StudentPlacement"""

    not_null: Annotated[
        OptionalNullable[StudentPlacementSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for StudentPlacement"""

    nested_filters: Annotated[
        Optional[List[StudentPlacementFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the StudentPlacement, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentPlacementSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: StudentPlacementSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class StudentPlacementSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[StudentPlacementSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
