"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .studentplacementsearch_requestbody import (
    StudentPlacementSearchRequestBody,
    StudentPlacementSearchRequestBodyTypedDict,
)
from .studentplacementsearch_response import (
    StudentPlacementSearchResponse,
    StudentPlacementSearchResponseTypedDict,
)
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentPlacementSearchRequestTypedDict(TypedDict):
    student_placement_search: StudentPlacementSearchRequestBodyTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of StudentPlacements to return (default: 50) when searching StudentPlacements"""
    offset: NotRequired[int]
    r"""The number of StudentPlacements to skip before starting to return results (default: 0) when searching StudentPlacements"""


class StudentPlacementSearchRequest(BaseModel):
    student_placement_search: Annotated[
        StudentPlacementSearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of StudentPlacements to return (default: 50) when searching StudentPlacements"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of StudentPlacements to skip before starting to return results (default: 0) when searching StudentPlacements"""


class StudentPlacementSearchResponseResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: StudentPlacementSearchResponseTypedDict


class StudentPlacementSearchResponseResponse(BaseModel):
    next: Union[
        Callable[[], Optional[StudentPlacementSearchResponseResponse]],
        Callable[[], Awaitable[Optional[StudentPlacementSearchResponseResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: StudentPlacementSearchResponse
