"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .gender import Gender
from .studentfilter import StudentFilter, StudentFilterTypedDict
from datetime import date, datetime
from meitner.types import BaseModel, Nullable, OptionalNullable, UNSET, UNSET_SENTINEL
import pydantic
from pydantic import model_serializer
from typing import List, Literal, Optional
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentSearchEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentSearchEqualsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentSearchEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentSearchEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the student"""


class StudentSearchEqualsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentSearchEqualsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchEqualsTypedDict(TypedDict):
    r"""Equality filters for Student"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentSearchEqualsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[StudentSearchEqualsGender]]
    r"""The gender of the student"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchEqualsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchEquals(BaseModel):
    r"""Equality filters for Student"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentSearchEqualsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[StudentSearchEqualsGender] = UNSET
    r"""The gender of the student"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchEqualsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotEqualsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    created_by: NotRequired[Nullable[str]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[str]]
    r"""User who last updated the resource"""


class StudentSearchNotEqualsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    created_by: Annotated[OptionalNullable[str], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[str], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdAt", "createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotEqualsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentSearchNotEqualsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


StudentSearchNotEqualsGender = Literal[
    "Female",
    "Male",
    "Other",
]
r"""The gender of the student"""


class StudentSearchNotEqualsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentSearchNotEqualsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotEqualsTypedDict(TypedDict):
    r"""Inequality filters for Student"""

    id: NotRequired[Nullable[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentSearchNotEqualsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchNotEqualsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[StudentSearchNotEqualsGender]]
    r"""The gender of the student"""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[Nullable[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchNotEqualsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchNotEquals(BaseModel):
    r"""Inequality filters for Student"""

    id: OptionalNullable[str] = UNSET
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentSearchNotEqualsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchNotEqualsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[StudentSearchNotEqualsGender] = UNSET
    r"""The gender of the student"""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="identityTemporary")
    ] = UNSET
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchNotEqualsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchGreaterThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentSearchGreaterThanMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchGreaterThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchGreaterThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchGreaterThanAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentSearchGreaterThanAddress(BaseModel):
    r"""The address of the student"""


class StudentSearchGreaterThanTypedDict(TypedDict):
    r"""Greater than filters for Student"""

    meta: NotRequired[Nullable[StudentSearchGreaterThanMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchGreaterThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchGreaterThanAddressTypedDict]]
    r"""The address of the student"""


class StudentSearchGreaterThan(BaseModel):
    r"""Greater than filters for Student"""

    meta: OptionalNullable[StudentSearchGreaterThanMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchGreaterThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchGreaterThanAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchSmallerThanMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentSearchSmallerThanMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchSmallerThanExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchSmallerThanExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchSmallerThanAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentSearchSmallerThanAddress(BaseModel):
    r"""The address of the student"""


class StudentSearchSmallerThanTypedDict(TypedDict):
    r"""Smaller than filters for Student"""

    meta: NotRequired[Nullable[StudentSearchSmallerThanMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchSmallerThanExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchSmallerThanAddressTypedDict]]
    r"""The address of the student"""


class StudentSearchSmallerThan(BaseModel):
    r"""Smaller than filters for Student"""

    meta: OptionalNullable[StudentSearchSmallerThanMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchSmallerThanExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchSmallerThanAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchGreaterOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentSearchGreaterOrEqualMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchGreaterOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchGreaterOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchGreaterOrEqualAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentSearchGreaterOrEqualAddress(BaseModel):
    r"""The address of the student"""


class StudentSearchGreaterOrEqualTypedDict(TypedDict):
    r"""Greater than or equal filters for Student"""

    meta: NotRequired[Nullable[StudentSearchGreaterOrEqualMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchGreaterOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchGreaterOrEqualAddressTypedDict]]
    r"""The address of the student"""


class StudentSearchGreaterOrEqual(BaseModel):
    r"""Greater than or equal filters for Student"""

    meta: OptionalNullable[StudentSearchGreaterOrEqualMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchGreaterOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchGreaterOrEqualAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchSmallerOrEqualMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was created"""
    updated_at: NotRequired[Nullable[datetime]]
    r"""Timestamp when the resource was last updated"""


class StudentSearchSmallerOrEqualMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="createdAt")
    ] = UNSET
    r"""Timestamp when the resource was created"""

    updated_at: Annotated[
        OptionalNullable[datetime], pydantic.Field(alias="updatedAt")
    ] = UNSET
    r"""Timestamp when the resource was last updated"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdAt", "updatedAt"]
        nullable_fields = ["createdAt", "updatedAt"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchSmallerOrEqualExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchSmallerOrEqualExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""


class StudentSearchSmallerOrEqualAddressTypedDict(TypedDict):
    r"""The address of the student"""


class StudentSearchSmallerOrEqualAddress(BaseModel):
    r"""The address of the student"""


class StudentSearchSmallerOrEqualTypedDict(TypedDict):
    r"""Smaller than or equal filters for Student"""

    meta: NotRequired[Nullable[StudentSearchSmallerOrEqualMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchSmallerOrEqualExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    date_of_birth: NotRequired[Nullable[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchSmallerOrEqualAddressTypedDict]]
    r"""The address of the student"""


class StudentSearchSmallerOrEqual(BaseModel):
    r"""Smaller than or equal filters for Student"""

    meta: OptionalNullable[StudentSearchSmallerOrEqualMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchSmallerOrEqualExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    date_of_birth: Annotated[
        OptionalNullable[date], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchSmallerOrEqualAddress] = UNSET
    r"""The address of the student"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["meta", "external", "dateOfBirth", "address"]
        nullable_fields = ["meta", "external", "dateOfBirth", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentSearchContainsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentSearchContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentSearchContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentSearchContainsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class StudentSearchContainsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class StudentSearchContainsTypedDict(TypedDict):
    r"""Contains filters for Student"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentSearchContainsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the student"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[List[str]]
    r"""The first name of the student"""
    last_name: NotRequired[List[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchContainsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchContains(BaseModel):
    r"""Contains filters for Student"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentSearchContainsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the student"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the student"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the student"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchContainsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotContainsMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[List[str]]
    r"""User who created the resource"""
    updated_by: NotRequired[List[str]]
    r"""User who last updated the resource"""


class StudentSearchNotContainsMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[Optional[List[str]], pydantic.Field(alias="createdBy")] = None
    r"""User who created the resource"""

    updated_by: Annotated[Optional[List[str]], pydantic.Field(alias="updatedBy")] = None
    r"""User who last updated the resource"""


class StudentSearchNotContainsExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[List[str]]
    r"""The ID of the external source"""
    source: NotRequired[List[str]]
    r"""The source of the external information"""


class StudentSearchNotContainsExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[Optional[List[str]], pydantic.Field(alias="sourceID")] = None
    r"""The ID of the external source"""

    source: Optional[List[str]] = None
    r"""The source of the external information"""


class StudentSearchNotContainsAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[List[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[List[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[List[str]]
    r"""The city of the address"""
    country_code: NotRequired[List[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[List[str]]
    r"""The municipality code of the address"""


class StudentSearchNotContainsAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        Optional[List[str]], pydantic.Field(alias="postalAddress")
    ] = None
    r"""The postal address of the address"""

    postal_code: Annotated[Optional[List[str]], pydantic.Field(alias="postalCode")] = (
        None
    )
    r"""The postal code of the address"""

    postal_city: Annotated[Optional[List[str]], pydantic.Field(alias="postalCity")] = (
        None
    )
    r"""The city of the address"""

    country_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="countryCode")
    ] = None
    r"""The country code of the address"""

    municipality_code: Annotated[
        Optional[List[str]], pydantic.Field(alias="municipalityCode")
    ] = None
    r"""The municipality code of the address"""


class StudentSearchNotContainsTypedDict(TypedDict):
    r"""Not contains filters for Student"""

    id: NotRequired[List[str]]
    r"""Unique identifier for the Student"""
    meta: NotRequired[Nullable[StudentSearchNotContainsMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchNotContainsExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[List[Gender]]
    r"""The gender of the student"""
    identity_number: NotRequired[List[str]]
    r"""The identity number of the student, must be unique within the organization."""
    identity_temporary: NotRequired[List[bool]]
    r"""If the identity number is temporary for the student"""
    first_name: NotRequired[List[str]]
    r"""The first name of the student"""
    last_name: NotRequired[List[str]]
    r"""The last name of the student"""
    date_of_birth: NotRequired[List[date]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchNotContainsAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[List[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[List[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[List[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[List[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchNotContains(BaseModel):
    r"""Not contains filters for Student"""

    id: Optional[List[str]] = None
    r"""Unique identifier for the Student"""

    meta: OptionalNullable[StudentSearchNotContainsMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchNotContainsExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: Optional[List[Gender]] = None
    r"""The gender of the student"""

    identity_number: Annotated[
        Optional[List[str]], pydantic.Field(alias="identityNumber")
    ] = None
    r"""The identity number of the student, must be unique within the organization."""

    identity_temporary: Annotated[
        Optional[List[bool]], pydantic.Field(alias="identityTemporary")
    ] = None
    r"""If the identity number is temporary for the student"""

    first_name: Annotated[Optional[List[str]], pydantic.Field(alias="firstName")] = None
    r"""The first name of the student"""

    last_name: Annotated[Optional[List[str]], pydantic.Field(alias="lastName")] = None
    r"""The last name of the student"""

    date_of_birth: Annotated[
        Optional[List[date]], pydantic.Field(alias="dateOfBirth")
    ] = None
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchNotContainsAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress1")
    ] = None
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        Optional[List[str]], pydantic.Field(alias="emailAddress2")
    ] = None
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber1")
    ] = None
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        Optional[List[str]], pydantic.Field(alias="phoneNumber2")
    ] = None
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "id",
            "meta",
            "external",
            "gender",
            "identityNumber",
            "identityTemporary",
            "firstName",
            "lastName",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = ["meta", "external", "address"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""


class StudentSearchLikeMeta(BaseModel):
    r"""Metadata information for the Student"""


class StudentSearchLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentSearchLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchLikeAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentSearchLikeAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchLikeTypedDict(TypedDict):
    r"""LIKE filters for Student"""

    meta: NotRequired[Nullable[StudentSearchLikeMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    address: NotRequired[Nullable[StudentSearchLikeAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchLike(BaseModel):
    r"""LIKE filters for Student"""

    meta: OptionalNullable[StudentSearchLikeMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    address: OptionalNullable[StudentSearchLikeAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotLikeMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""


class StudentSearchNotLikeMeta(BaseModel):
    r"""Metadata information for the Student"""


class StudentSearchNotLikeExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[str]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[str]]
    r"""The source of the external information"""


class StudentSearchNotLikeExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[str], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[str] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotLikeAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[str]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[str]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[str]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[str]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[str]]
    r"""The municipality code of the address"""


class StudentSearchNotLikeAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[str], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[str], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotLikeTypedDict(TypedDict):
    r"""NOT LIKE filters for Student"""

    meta: NotRequired[Nullable[StudentSearchNotLikeMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchNotLikeExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    identity_number: NotRequired[Nullable[str]]
    r"""The identity number of the student, must be unique within the organization."""
    first_name: NotRequired[Nullable[str]]
    r"""The first name of the student"""
    last_name: NotRequired[Nullable[str]]
    r"""The last name of the student"""
    address: NotRequired[Nullable[StudentSearchNotLikeAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[str]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[str]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[str]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[str]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchNotLike(BaseModel):
    r"""NOT LIKE filters for Student"""

    meta: OptionalNullable[StudentSearchNotLikeMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchNotLikeExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    identity_number: Annotated[
        OptionalNullable[str], pydantic.Field(alias="identityNumber")
    ] = UNSET
    r"""The identity number of the student, must be unique within the organization."""

    first_name: Annotated[OptionalNullable[str], pydantic.Field(alias="firstName")] = (
        UNSET
    )
    r"""The first name of the student"""

    last_name: Annotated[OptionalNullable[str], pydantic.Field(alias="lastName")] = (
        UNSET
    )
    r"""The last name of the student"""

    address: OptionalNullable[StudentSearchNotLikeAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[str], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "identityNumber",
            "firstName",
            "lastName",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentSearchNullMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentSearchNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNullAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class StudentSearchNullAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNullTypedDict(TypedDict):
    r"""Null filters for Student"""

    meta: NotRequired[Nullable[StudentSearchNullMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the student"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchNullAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchNull(BaseModel):
    r"""Null filters for Student"""

    meta: OptionalNullable[StudentSearchNullMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the student"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchNullAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotNullMetaTypedDict(TypedDict):
    r"""Metadata information for the Student"""

    created_by: NotRequired[Nullable[bool]]
    r"""User who created the resource"""
    updated_at: NotRequired[Nullable[bool]]
    r"""Timestamp when the resource was last updated"""
    updated_by: NotRequired[Nullable[bool]]
    r"""User who last updated the resource"""


class StudentSearchNotNullMeta(BaseModel):
    r"""Metadata information for the Student"""

    created_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="createdBy")] = (
        UNSET
    )
    r"""User who created the resource"""

    updated_at: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedAt")] = (
        UNSET
    )
    r"""Timestamp when the resource was last updated"""

    updated_by: Annotated[OptionalNullable[bool], pydantic.Field(alias="updatedBy")] = (
        UNSET
    )
    r"""User who last updated the resource"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["createdBy", "updatedAt", "updatedBy"]
        nullable_fields = ["createdBy", "updatedAt", "updatedBy"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotNullExternalTypedDict(TypedDict):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: NotRequired[Nullable[bool]]
    r"""The ID of the external source"""
    source: NotRequired[Nullable[bool]]
    r"""The source of the external information"""


class StudentSearchNotNullExternal(BaseModel):
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    source_id: Annotated[OptionalNullable[bool], pydantic.Field(alias="sourceID")] = (
        UNSET
    )
    r"""The ID of the external source"""

    source: OptionalNullable[bool] = UNSET
    r"""The source of the external information"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = ["sourceID", "source"]
        nullable_fields = ["sourceID", "source"]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotNullAddressTypedDict(TypedDict):
    r"""The address of the student"""

    postal_address: NotRequired[Nullable[bool]]
    r"""The postal address of the address"""
    postal_code: NotRequired[Nullable[bool]]
    r"""The postal code of the address"""
    postal_city: NotRequired[Nullable[bool]]
    r"""The city of the address"""
    country_code: NotRequired[Nullable[bool]]
    r"""The country code of the address"""
    municipality_code: NotRequired[Nullable[bool]]
    r"""The municipality code of the address"""


class StudentSearchNotNullAddress(BaseModel):
    r"""The address of the student"""

    postal_address: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalAddress")
    ] = UNSET
    r"""The postal address of the address"""

    postal_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCode")
    ] = UNSET
    r"""The postal code of the address"""

    postal_city: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="postalCity")
    ] = UNSET
    r"""The city of the address"""

    country_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="countryCode")
    ] = UNSET
    r"""The country code of the address"""

    municipality_code: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="municipalityCode")
    ] = UNSET
    r"""The municipality code of the address"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        nullable_fields = [
            "postalAddress",
            "postalCode",
            "postalCity",
            "countryCode",
            "municipalityCode",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchNotNullTypedDict(TypedDict):
    r"""Not null filters for Student"""

    meta: NotRequired[Nullable[StudentSearchNotNullMetaTypedDict]]
    r"""Metadata information for the Student"""
    external: NotRequired[Nullable[StudentSearchNotNullExternalTypedDict]]
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""
    gender: NotRequired[Nullable[bool]]
    r"""The gender of the student"""
    date_of_birth: NotRequired[Nullable[bool]]
    r"""The date of birth of the student"""
    address: NotRequired[Nullable[StudentSearchNotNullAddressTypedDict]]
    r"""The address of the student"""
    email_address1: NotRequired[Nullable[bool]]
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """
    email_address2: NotRequired[Nullable[bool]]
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""
    phone_number1: NotRequired[Nullable[bool]]
    r"""The primary phone number of the student, will be used for communication with the student from the system."""
    phone_number2: NotRequired[Nullable[bool]]
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""


class StudentSearchNotNull(BaseModel):
    r"""Not null filters for Student"""

    meta: OptionalNullable[StudentSearchNotNullMeta] = UNSET
    r"""Metadata information for the Student"""

    external: OptionalNullable[StudentSearchNotNullExternal] = UNSET
    r"""External is a reusable object that can be used to store external information about the student from another system, used for third-party integration tracking."""

    gender: OptionalNullable[bool] = UNSET
    r"""The gender of the student"""

    date_of_birth: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="dateOfBirth")
    ] = UNSET
    r"""The date of birth of the student"""

    address: OptionalNullable[StudentSearchNotNullAddress] = UNSET
    r"""The address of the student"""

    email_address1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress1")
    ] = UNSET
    r"""The primary email address of the student, will be used for communication with the student from the system and must be unique within the organization.
    Can be used to login to the system if password-authentication is enabled for the organization.

    """

    email_address2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="emailAddress2")
    ] = UNSET
    r"""The secondary email address of the student, will not be used within the system, but will be displayed for contact information."""

    phone_number1: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber1")
    ] = UNSET
    r"""The primary phone number of the student, will be used for communication with the student from the system."""

    phone_number2: Annotated[
        OptionalNullable[bool], pydantic.Field(alias="phoneNumber2")
    ] = UNSET
    r"""The secondary phone number of the student, will not be used within the system, but will be displayed for contact information."""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        nullable_fields = [
            "meta",
            "external",
            "gender",
            "dateOfBirth",
            "address",
            "emailAddress1",
            "emailAddress2",
            "phoneNumber1",
            "phoneNumber2",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchFilterTypedDict(TypedDict):
    r"""Filter criteria to search for specific records"""

    or_condition: bool
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""
    equals: NotRequired[Nullable[StudentSearchEqualsTypedDict]]
    r"""Equality filters for Student"""
    not_equals: NotRequired[Nullable[StudentSearchNotEqualsTypedDict]]
    r"""Inequality filters for Student"""
    greater_than: NotRequired[Nullable[StudentSearchGreaterThanTypedDict]]
    r"""Greater than filters for Student"""
    smaller_than: NotRequired[Nullable[StudentSearchSmallerThanTypedDict]]
    r"""Smaller than filters for Student"""
    greater_or_equal: NotRequired[Nullable[StudentSearchGreaterOrEqualTypedDict]]
    r"""Greater than or equal filters for Student"""
    smaller_or_equal: NotRequired[Nullable[StudentSearchSmallerOrEqualTypedDict]]
    r"""Smaller than or equal filters for Student"""
    contains: NotRequired[Nullable[StudentSearchContainsTypedDict]]
    r"""Contains filters for Student"""
    not_contains: NotRequired[Nullable[StudentSearchNotContainsTypedDict]]
    r"""Not contains filters for Student"""
    like: NotRequired[Nullable[StudentSearchLikeTypedDict]]
    r"""LIKE filters for Student"""
    not_like: NotRequired[Nullable[StudentSearchNotLikeTypedDict]]
    r"""NOT LIKE filters for Student"""
    null: NotRequired[Nullable[StudentSearchNullTypedDict]]
    r"""Null filters for Student"""
    not_null: NotRequired[Nullable[StudentSearchNotNullTypedDict]]
    r"""Not null filters for Student"""
    nested_filters: NotRequired[List[StudentFilterTypedDict]]
    r"""NestedFilters of the Student, useful for more complex filters"""


class StudentSearchFilter(BaseModel):
    r"""Filter criteria to search for specific records"""

    or_condition: Annotated[bool, pydantic.Field(alias="orCondition")]
    r"""OrCondition decides if this filter is within an OR-condition or AND-condition"""

    equals: OptionalNullable[StudentSearchEquals] = UNSET
    r"""Equality filters for Student"""

    not_equals: Annotated[
        OptionalNullable[StudentSearchNotEquals], pydantic.Field(alias="notEquals")
    ] = UNSET
    r"""Inequality filters for Student"""

    greater_than: Annotated[
        OptionalNullable[StudentSearchGreaterThan], pydantic.Field(alias="greaterThan")
    ] = UNSET
    r"""Greater than filters for Student"""

    smaller_than: Annotated[
        OptionalNullable[StudentSearchSmallerThan], pydantic.Field(alias="smallerThan")
    ] = UNSET
    r"""Smaller than filters for Student"""

    greater_or_equal: Annotated[
        OptionalNullable[StudentSearchGreaterOrEqual],
        pydantic.Field(alias="greaterOrEqual"),
    ] = UNSET
    r"""Greater than or equal filters for Student"""

    smaller_or_equal: Annotated[
        OptionalNullable[StudentSearchSmallerOrEqual],
        pydantic.Field(alias="smallerOrEqual"),
    ] = UNSET
    r"""Smaller than or equal filters for Student"""

    contains: OptionalNullable[StudentSearchContains] = UNSET
    r"""Contains filters for Student"""

    not_contains: Annotated[
        OptionalNullable[StudentSearchNotContains], pydantic.Field(alias="notContains")
    ] = UNSET
    r"""Not contains filters for Student"""

    like: OptionalNullable[StudentSearchLike] = UNSET
    r"""LIKE filters for Student"""

    not_like: Annotated[
        OptionalNullable[StudentSearchNotLike], pydantic.Field(alias="notLike")
    ] = UNSET
    r"""NOT LIKE filters for Student"""

    null: OptionalNullable[StudentSearchNull] = UNSET
    r"""Null filters for Student"""

    not_null: Annotated[
        OptionalNullable[StudentSearchNotNull], pydantic.Field(alias="notNull")
    ] = UNSET
    r"""Not null filters for Student"""

    nested_filters: Annotated[
        Optional[List[StudentFilter]], pydantic.Field(alias="nestedFilters")
    ] = None
    r"""NestedFilters of the Student, useful for more complex filters"""

    @model_serializer(mode="wrap")
    def serialize_model(self, handler):
        optional_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
            "nestedFilters",
        ]
        nullable_fields = [
            "equals",
            "notEquals",
            "greaterThan",
            "smallerThan",
            "greaterOrEqual",
            "smallerOrEqual",
            "contains",
            "notContains",
            "like",
            "notLike",
            "null",
            "notNull",
        ]
        null_default_fields = []

        serialized = handler(self)

        m = {}

        for n, f in type(self).model_fields.items():
            k = f.alias or n
            val = serialized.get(k)
            serialized.pop(k, None)

            optional_nullable = k in optional_fields and k in nullable_fields
            is_set = (
                self.__pydantic_fields_set__.intersection({n})
                or k in null_default_fields
            )  # pylint: disable=no-member

            if val is not None and val != UNSET_SENTINEL:
                m[k] = val
            elif val != UNSET_SENTINEL and (
                not k in optional_fields or (optional_nullable and is_set)
            ):
                m[k] = val

        return m


class StudentSearchRequestBodyTypedDict(TypedDict):
    r"""Request body"""

    filter_: StudentSearchFilterTypedDict
    r"""Filter criteria to search for specific records"""


class StudentSearchRequestBody(BaseModel):
    r"""Request body"""

    filter_: Annotated[StudentSearchFilter, pydantic.Field(alias="filter")]
    r"""Filter criteria to search for specific records"""
