"""Code generated by Speakeasy (https://speakeasy.com). DO NOT EDIT."""

from __future__ import annotations
from .studentsearch_requestbody import (
    StudentSearchRequestBody,
    StudentSearchRequestBodyTypedDict,
)
from .studentsearch_response import (
    StudentSearchResponse,
    StudentSearchResponseTypedDict,
)
from meitner.types import BaseModel
from meitner.utils import FieldMetadata, QueryParamMetadata, RequestMetadata
from typing import Awaitable, Callable, Dict, List, Optional, Union
from typing_extensions import Annotated, NotRequired, TypedDict


class StudentSearchRequestTypedDict(TypedDict):
    student_search: StudentSearchRequestBodyTypedDict
    r"""Request body"""
    limit: NotRequired[int]
    r"""The maximum number of Students to return (default: 50) when searching Students"""
    offset: NotRequired[int]
    r"""The number of Students to skip before starting to return results (default: 0) when searching Students"""


class StudentSearchRequest(BaseModel):
    student_search: Annotated[
        StudentSearchRequestBody,
        FieldMetadata(request=RequestMetadata(media_type="application/json")),
    ]
    r"""Request body"""

    limit: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 50
    r"""The maximum number of Students to return (default: 50) when searching Students"""

    offset: Annotated[
        Optional[int],
        FieldMetadata(query=QueryParamMetadata(style="form", explode=True)),
    ] = 0
    r"""The number of Students to skip before starting to return results (default: 0) when searching Students"""


class StudentSearchResponseResponseTypedDict(TypedDict):
    headers: Dict[str, List[str]]
    result: StudentSearchResponseTypedDict


class StudentSearchResponseResponse(BaseModel):
    next: Union[
        Callable[[], Optional[StudentSearchResponseResponse]],
        Callable[[], Awaitable[Optional[StudentSearchResponseResponse]]],
    ]

    headers: Dict[str, List[str]]

    result: StudentSearchResponse
