//! # tools that make printing stuff better

//// ATTRIBUTES ////////////////////////////////////////////////////////////////////////////////////
// we want docs
#![warn(missing_docs)]
#![warn(rustdoc::missing_crate_level_docs)]
// we want Debug everywhere.
#![warn(missing_debug_implementations)]
// enable clippy's extra lints, the pedantic version
#![warn(clippy::pedantic)]

//// IMPORTS ///////////////////////////////////////////////////////////////////////////////////////
// reimport our macros to this module, so the user does not get confused when importing the macros
pub use crate::divider;
pub use crate::print_divider;

use pyo3::prelude::*;

//// TYPES /////////////////////////////////////////////////////////////////////////////////////////

//// CONSTANTS /////////////////////////////////////////////////////////////////////////////////////

//// STATICS ///////////////////////////////////////////////////////////////////////////////////////

//// MACROS ////////////////////////////////////////////////////////////////////////////////////////
/// Quickly get a one line visual divider
#[macro_export]
macro_rules! divider {
    () => {{
        format!("{:=^80}", "=")
    }};
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// Quickly print a one line visual divider
#[macro_export]
macro_rules! print_divider {
    () => {{
        println!("{}", divider!())
    }};
}

//// ENUMS /////////////////////////////////////////////////////////////////////////////////////////

//// STRUCTS ///////////////////////////////////////////////////////////////////////////////////////

//// IMPLEMENTATION ////////////////////////////////////////////////////////////////////////////////

//// PUBLIC FUNCTIONS //////////////////////////////////////////////////////////////////////////////
/// python interface for [`divider!`], can also be used with rust
#[pyfunction]
pub fn divider() -> String {
    divider!()
}

////////////////////////////////////////////////////////////////////////////////////////////////////
/// python interface for [`print_divider!`], can also be used with rust
#[pyfunction]
pub fn print_divider() {
    print_divider!()
}

//// PRIVATE FUNCTIONS /////////////////////////////////////////////////////////////////////////////
