# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ServicePerimeterIngressPolicyArgs', 'ServicePerimeterIngressPolicy']

@pulumi.input_type
class ServicePerimeterIngressPolicyArgs:
    def __init__(__self__, *,
                 perimeter: pulumi.Input[_builtins.str],
                 ingress_from: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a ServicePerimeterIngressPolicy resource.
        :param pulumi.Input[_builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs'] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        pulumi.set(__self__, "perimeter", perimeter)
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter
    def perimeter(self) -> pulumi.Input[_builtins.str]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "perimeter", value)

    @_builtins.property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @_builtins.property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]):
        pulumi.set(self, "ingress_to", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class _ServicePerimeterIngressPolicyState:
    def __init__(__self__, *,
                 access_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 ingress_from: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']] = None,
                 ingress_to: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']] = None,
                 perimeter: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering ServicePerimeterIngressPolicy resources.
        :param pulumi.Input[_builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input[_builtins.str] etag: The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs'] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs'] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        if access_policy_id is not None:
            pulumi.set(__self__, "access_policy_id", access_policy_id)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if ingress_from is not None:
            pulumi.set(__self__, "ingress_from", ingress_from)
        if ingress_to is not None:
            pulumi.set(__self__, "ingress_to", ingress_to)
        if perimeter is not None:
            pulumi.set(__self__, "perimeter", perimeter)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @_builtins.property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @access_policy_id.setter
    def access_policy_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_policy_id", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @ingress_from.setter
    def ingress_from(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressFromArgs']]):
        pulumi.set(self, "ingress_from", value)

    @_builtins.property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @ingress_to.setter
    def ingress_to(self, value: Optional[pulumi.Input['ServicePerimeterIngressPolicyIngressToArgs']]):
        pulumi.set(self, "ingress_to", value)

    @_builtins.property
    @pulumi.getter
    def perimeter(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "perimeter")

    @perimeter.setter
    def perimeter(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "perimeter", value)

    @_builtins.property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "title", value)


@pulumi.type_token("gcp:accesscontextmanager/servicePerimeterIngressPolicy:ServicePerimeterIngressPolicy")
class ServicePerimeterIngressPolicy(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_from: Optional[pulumi.Input[Union['ServicePerimeterIngressPolicyIngressFromArgs', 'ServicePerimeterIngressPolicyIngressFromArgsDict']]] = None,
                 ingress_to: Optional[pulumi.Input[Union['ServicePerimeterIngressPolicyIngressToArgs', 'ServicePerimeterIngressPolicyIngressToArgsDict']]] = None,
                 perimeter: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Manage a single IngressPolicy in the status (enforced) configuration for a service perimeter.
        IngressPolicies match requests based on ingressFrom and ingressTo stanzas. For an ingress policy to match,
        both the ingressFrom and ingressTo stanzas must be matched. If an IngressPolicy matches a request,
        the request is allowed through the perimeter boundary from outside the perimeter.
        For example, access from the internet can be allowed either based on an AccessLevel or,
        for traffic hosted on Google Cloud, the project of the source network.
        For access from private networks, using the project of the hosting network is required.
        Individual ingress policies can be limited by restricting which services and/
        or actions they match using the ingressTo field.

        > **Note:** By default, updates to this resource will remove the IngressPolicy from the
        from the perimeter and add it back in a non-atomic manner. To ensure that the new IngressPolicy
        is added before the old one is removed, add a `lifecycle` block with `create_before_destroy = true` to this resource.
        **Note:** If this resource is used alongside a `accesscontextmanager.ServicePerimeter` resource,
        the service perimeter resource must have a `lifecycle` block with `ignore_changes = [status[0].ingress_policies]` so
        they don't fight over which ingress rules should be in the policy.

        To get more information about ServicePerimeterIngressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#ingresspolicy)
        * How-to Guides
            * [Guide to Ingress and Egress Rules](https://cloud.google.com/vpc-service-controls/docs/ingress-egress-rules)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Union['ServicePerimeterIngressPolicyIngressFromArgs', 'ServicePerimeterIngressPolicyIngressFromArgsDict']] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input[Union['ServicePerimeterIngressPolicyIngressToArgs', 'ServicePerimeterIngressPolicyIngressToArgsDict']] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ServicePerimeterIngressPolicyArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Manage a single IngressPolicy in the status (enforced) configuration for a service perimeter.
        IngressPolicies match requests based on ingressFrom and ingressTo stanzas. For an ingress policy to match,
        both the ingressFrom and ingressTo stanzas must be matched. If an IngressPolicy matches a request,
        the request is allowed through the perimeter boundary from outside the perimeter.
        For example, access from the internet can be allowed either based on an AccessLevel or,
        for traffic hosted on Google Cloud, the project of the source network.
        For access from private networks, using the project of the hosting network is required.
        Individual ingress policies can be limited by restricting which services and/
        or actions they match using the ingressTo field.

        > **Note:** By default, updates to this resource will remove the IngressPolicy from the
        from the perimeter and add it back in a non-atomic manner. To ensure that the new IngressPolicy
        is added before the old one is removed, add a `lifecycle` block with `create_before_destroy = true` to this resource.
        **Note:** If this resource is used alongside a `accesscontextmanager.ServicePerimeter` resource,
        the service perimeter resource must have a `lifecycle` block with `ignore_changes = [status[0].ingress_policies]` so
        they don't fight over which ingress rules should be in the policy.

        To get more information about ServicePerimeterIngressPolicy, see:

        * [API documentation](https://cloud.google.com/access-context-manager/docs/reference/rest/v1/accessPolicies.servicePerimeters#ingresspolicy)
        * How-to Guides
            * [Guide to Ingress and Egress Rules](https://cloud.google.com/vpc-service-controls/docs/ingress-egress-rules)

        ## Example Usage

        :param str resource_name: The name of the resource.
        :param ServicePerimeterIngressPolicyArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ServicePerimeterIngressPolicyArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ingress_from: Optional[pulumi.Input[Union['ServicePerimeterIngressPolicyIngressFromArgs', 'ServicePerimeterIngressPolicyIngressFromArgsDict']]] = None,
                 ingress_to: Optional[pulumi.Input[Union['ServicePerimeterIngressPolicyIngressToArgs', 'ServicePerimeterIngressPolicyIngressToArgsDict']]] = None,
                 perimeter: Optional[pulumi.Input[_builtins.str]] = None,
                 title: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ServicePerimeterIngressPolicyArgs.__new__(ServicePerimeterIngressPolicyArgs)

            __props__.__dict__["ingress_from"] = ingress_from
            __props__.__dict__["ingress_to"] = ingress_to
            if perimeter is None and not opts.urn:
                raise TypeError("Missing required property 'perimeter'")
            __props__.__dict__["perimeter"] = perimeter
            __props__.__dict__["title"] = title
            __props__.__dict__["access_policy_id"] = None
            __props__.__dict__["etag"] = None
        super(ServicePerimeterIngressPolicy, __self__).__init__(
            'gcp:accesscontextmanager/servicePerimeterIngressPolicy:ServicePerimeterIngressPolicy',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_policy_id: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            ingress_from: Optional[pulumi.Input[Union['ServicePerimeterIngressPolicyIngressFromArgs', 'ServicePerimeterIngressPolicyIngressFromArgsDict']]] = None,
            ingress_to: Optional[pulumi.Input[Union['ServicePerimeterIngressPolicyIngressToArgs', 'ServicePerimeterIngressPolicyIngressToArgsDict']]] = None,
            perimeter: Optional[pulumi.Input[_builtins.str]] = None,
            title: Optional[pulumi.Input[_builtins.str]] = None) -> 'ServicePerimeterIngressPolicy':
        """
        Get an existing ServicePerimeterIngressPolicy resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_policy_id: The name of the Access Policy this resource belongs to.
        :param pulumi.Input[_builtins.str] etag: The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        :param pulumi.Input[Union['ServicePerimeterIngressPolicyIngressFromArgs', 'ServicePerimeterIngressPolicyIngressFromArgsDict']] ingress_from: Defines the conditions on the source of a request causing this `IngressPolicy`
               to apply.
               Structure is documented below.
        :param pulumi.Input[Union['ServicePerimeterIngressPolicyIngressToArgs', 'ServicePerimeterIngressPolicyIngressToArgsDict']] ingress_to: Defines the conditions on the `ApiOperation` and request destination that cause
               this `IngressPolicy` to apply.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] perimeter: The name of the Service Perimeter to add this resource to.
        :param pulumi.Input[_builtins.str] title: Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ServicePerimeterIngressPolicyState.__new__(_ServicePerimeterIngressPolicyState)

        __props__.__dict__["access_policy_id"] = access_policy_id
        __props__.__dict__["etag"] = etag
        __props__.__dict__["ingress_from"] = ingress_from
        __props__.__dict__["ingress_to"] = ingress_to
        __props__.__dict__["perimeter"] = perimeter
        __props__.__dict__["title"] = title
        return ServicePerimeterIngressPolicy(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessPolicyId")
    def access_policy_id(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Access Policy this resource belongs to.
        """
        return pulumi.get(self, "access_policy_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        The perimeter etag is internally used to prevent overwriting the list of policies on PATCH calls. It is retrieved from the same GET perimeter API call that's used to get the current list of policies. The policy defined in this resource is added or removed from that list, and then this etag is sent with the PATCH call along with the updated policies.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="ingressFrom")
    def ingress_from(self) -> pulumi.Output[Optional['outputs.ServicePerimeterIngressPolicyIngressFrom']]:
        """
        Defines the conditions on the source of a request causing this `IngressPolicy`
        to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_from")

    @_builtins.property
    @pulumi.getter(name="ingressTo")
    def ingress_to(self) -> pulumi.Output[Optional['outputs.ServicePerimeterIngressPolicyIngressTo']]:
        """
        Defines the conditions on the `ApiOperation` and request destination that cause
        this `IngressPolicy` to apply.
        Structure is documented below.
        """
        return pulumi.get(self, "ingress_to")

    @_builtins.property
    @pulumi.getter
    def perimeter(self) -> pulumi.Output[_builtins.str]:
        """
        The name of the Service Perimeter to add this resource to.
        """
        return pulumi.get(self, "perimeter")

    @_builtins.property
    @pulumi.getter
    def title(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Human readable title. Must be unique within the perimeter. Does not affect behavior.
        """
        return pulumi.get(self, "title")

