# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetEnvironmentIamPolicyResult',
    'AwaitableGetEnvironmentIamPolicyResult',
    'get_environment_iam_policy',
    'get_environment_iam_policy_output',
]

@pulumi.output_type
class GetEnvironmentIamPolicyResult:
    """
    A collection of values returned by getEnvironmentIamPolicy.
    """
    def __init__(__self__, env_id=None, etag=None, id=None, org_id=None, policy_data=None):
        if env_id and not isinstance(env_id, str):
            raise TypeError("Expected argument 'env_id' to be a str")
        pulumi.set(__self__, "env_id", env_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if org_id and not isinstance(org_id, str):
            raise TypeError("Expected argument 'org_id' to be a str")
        pulumi.set(__self__, "org_id", org_id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @_builtins.property
    @pulumi.getter(name="envId")
    def env_id(self) -> _builtins.str:
        return pulumi.get(self, "env_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="orgId")
    def org_id(self) -> _builtins.str:
        return pulumi.get(self, "org_id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Required only by `apigee.EnvironmentIamPolicy`) The policy data generated by
        a `organizations_get_iam_policy` data source.
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetEnvironmentIamPolicyResult(GetEnvironmentIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetEnvironmentIamPolicyResult(
            env_id=self.env_id,
            etag=self.etag,
            id=self.id,
            org_id=self.org_id,
            policy_data=self.policy_data)


def get_environment_iam_policy(env_id: Optional[_builtins.str] = None,
                               org_id: Optional[_builtins.str] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetEnvironmentIamPolicyResult:
    """
    Retrieves the current IAM policy data for environment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.apigee.get_environment_iam_policy(org_id=apigee_environment["orgId"],
        env_id=apigee_environment["name"])
    ```


    :param _builtins.str env_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str org_id: The Apigee Organization associated with the Apigee environment,
           in the format `organizations/{{org_name}}`.
           Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['envId'] = env_id
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:apigee/getEnvironmentIamPolicy:getEnvironmentIamPolicy', __args__, opts=opts, typ=GetEnvironmentIamPolicyResult).value

    return AwaitableGetEnvironmentIamPolicyResult(
        env_id=pulumi.get(__ret__, 'env_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        org_id=pulumi.get(__ret__, 'org_id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))
def get_environment_iam_policy_output(env_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      org_id: Optional[pulumi.Input[_builtins.str]] = None,
                                      opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetEnvironmentIamPolicyResult]:
    """
    Retrieves the current IAM policy data for environment

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.apigee.get_environment_iam_policy(org_id=apigee_environment["orgId"],
        env_id=apigee_environment["name"])
    ```


    :param _builtins.str env_id: Used to find the parent resource to bind the IAM policy to
    :param _builtins.str org_id: The Apigee Organization associated with the Apigee environment,
           in the format `organizations/{{org_name}}`.
           Used to find the parent resource to bind the IAM policy to
    """
    __args__ = dict()
    __args__['envId'] = env_id
    __args__['orgId'] = org_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:apigee/getEnvironmentIamPolicy:getEnvironmentIamPolicy', __args__, opts=opts, typ=GetEnvironmentIamPolicyResult)
    return __ret__.apply(lambda __response__: GetEnvironmentIamPolicyResult(
        env_id=pulumi.get(__response__, 'env_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        org_id=pulumi.get(__response__, 'org_id'),
        policy_data=pulumi.get(__response__, 'policy_data')))
