# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'ApplicationFeatureSettings',
    'ApplicationIap',
    'ApplicationUrlDispatchRule',
    'ApplicationUrlDispatchRulesDispatchRule',
    'DomainMappingResourceRecord',
    'DomainMappingSslSettings',
    'EngineSplitTrafficSplit',
    'FlexibleAppVersionApiConfig',
    'FlexibleAppVersionAutomaticScaling',
    'FlexibleAppVersionAutomaticScalingCpuUtilization',
    'FlexibleAppVersionAutomaticScalingDiskUtilization',
    'FlexibleAppVersionAutomaticScalingNetworkUtilization',
    'FlexibleAppVersionAutomaticScalingRequestUtilization',
    'FlexibleAppVersionDeployment',
    'FlexibleAppVersionDeploymentCloudBuildOptions',
    'FlexibleAppVersionDeploymentContainer',
    'FlexibleAppVersionDeploymentFile',
    'FlexibleAppVersionDeploymentZip',
    'FlexibleAppVersionEndpointsApiService',
    'FlexibleAppVersionEntrypoint',
    'FlexibleAppVersionFlexibleRuntimeSettings',
    'FlexibleAppVersionHandler',
    'FlexibleAppVersionHandlerScript',
    'FlexibleAppVersionHandlerStaticFiles',
    'FlexibleAppVersionLivenessCheck',
    'FlexibleAppVersionManualScaling',
    'FlexibleAppVersionNetwork',
    'FlexibleAppVersionReadinessCheck',
    'FlexibleAppVersionResources',
    'FlexibleAppVersionResourcesVolume',
    'FlexibleAppVersionVpcAccessConnector',
    'ServiceNetworkSettingsNetworkSettings',
    'StandardAppVersionAutomaticScaling',
    'StandardAppVersionAutomaticScalingStandardSchedulerSettings',
    'StandardAppVersionBasicScaling',
    'StandardAppVersionDeployment',
    'StandardAppVersionDeploymentFile',
    'StandardAppVersionDeploymentZip',
    'StandardAppVersionEntrypoint',
    'StandardAppVersionHandler',
    'StandardAppVersionHandlerScript',
    'StandardAppVersionHandlerStaticFiles',
    'StandardAppVersionLibrary',
    'StandardAppVersionManualScaling',
    'StandardAppVersionVpcAccessConnector',
]

@pulumi.output_type
class ApplicationFeatureSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "splitHealthChecks":
            suggest = "split_health_checks"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationFeatureSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationFeatureSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationFeatureSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 split_health_checks: _builtins.bool):
        """
        :param _builtins.bool split_health_checks: Set to false to use the legacy health check instead of the readiness
               and liveness checks.
        """
        pulumi.set(__self__, "split_health_checks", split_health_checks)

    @_builtins.property
    @pulumi.getter(name="splitHealthChecks")
    def split_health_checks(self) -> _builtins.bool:
        """
        Set to false to use the legacy health check instead of the readiness
        and liveness checks.
        """
        return pulumi.get(self, "split_health_checks")


@pulumi.output_type
class ApplicationIap(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "oauth2ClientId":
            suggest = "oauth2_client_id"
        elif key == "oauth2ClientSecret":
            suggest = "oauth2_client_secret"
        elif key == "oauth2ClientSecretSha256":
            suggest = "oauth2_client_secret_sha256"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ApplicationIap. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ApplicationIap.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ApplicationIap.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 oauth2_client_id: _builtins.str,
                 oauth2_client_secret: _builtins.str,
                 enabled: Optional[_builtins.bool] = None,
                 oauth2_client_secret_sha256: Optional[_builtins.str] = None):
        """
        :param _builtins.str oauth2_client_id: OAuth2 client ID to use for the authentication flow.
        :param _builtins.str oauth2_client_secret: OAuth2 client secret to use for the authentication flow.
               The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
        :param _builtins.bool enabled: (Optional) Whether the serving infrastructure will authenticate and authorize all incoming requests. 
               (default is false)
        :param _builtins.str oauth2_client_secret_sha256: Hex-encoded SHA-256 hash of the client secret.
        """
        pulumi.set(__self__, "oauth2_client_id", oauth2_client_id)
        pulumi.set(__self__, "oauth2_client_secret", oauth2_client_secret)
        if enabled is not None:
            pulumi.set(__self__, "enabled", enabled)
        if oauth2_client_secret_sha256 is not None:
            pulumi.set(__self__, "oauth2_client_secret_sha256", oauth2_client_secret_sha256)

    @_builtins.property
    @pulumi.getter(name="oauth2ClientId")
    def oauth2_client_id(self) -> _builtins.str:
        """
        OAuth2 client ID to use for the authentication flow.
        """
        return pulumi.get(self, "oauth2_client_id")

    @_builtins.property
    @pulumi.getter(name="oauth2ClientSecret")
    def oauth2_client_secret(self) -> _builtins.str:
        """
        OAuth2 client secret to use for the authentication flow.
        The SHA-256 hash of the value is returned in the oauth2ClientSecretSha256 field.
        """
        return pulumi.get(self, "oauth2_client_secret")

    @_builtins.property
    @pulumi.getter
    def enabled(self) -> Optional[_builtins.bool]:
        """
        (Optional) Whether the serving infrastructure will authenticate and authorize all incoming requests. 
        (default is false)
        """
        return pulumi.get(self, "enabled")

    @_builtins.property
    @pulumi.getter(name="oauth2ClientSecretSha256")
    def oauth2_client_secret_sha256(self) -> Optional[_builtins.str]:
        """
        Hex-encoded SHA-256 hash of the client secret.
        """
        return pulumi.get(self, "oauth2_client_secret_sha256")


@pulumi.output_type
class ApplicationUrlDispatchRule(dict):
    def __init__(__self__, *,
                 domain: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 service: Optional[_builtins.str] = None):
        if domain is not None:
            pulumi.set(__self__, "domain", domain)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if service is not None:
            pulumi.set(__self__, "service", service)

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "domain")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def service(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "service")


@pulumi.output_type
class ApplicationUrlDispatchRulesDispatchRule(dict):
    def __init__(__self__, *,
                 path: _builtins.str,
                 service: _builtins.str,
                 domain: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.
               The sum of the lengths of the domain and path may not exceed 100 characters.
        :param _builtins.str service: Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.
               The sum of the lengths of the domain and path may not exceed 100 characters.
        :param _builtins.str domain: Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".
               Defaults to matching all domains: "*".
        """
        pulumi.set(__self__, "path", path)
        pulumi.set(__self__, "service", service)
        if domain is not None:
            pulumi.set(__self__, "domain", domain)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.
        The sum of the lengths of the domain and path may not exceed 100 characters.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter
    def service(self) -> _builtins.str:
        """
        Pathname within the host. Must start with a "/". A single "*" can be included at the end of the path.
        The sum of the lengths of the domain and path may not exceed 100 characters.
        """
        return pulumi.get(self, "service")

    @_builtins.property
    @pulumi.getter
    def domain(self) -> Optional[_builtins.str]:
        """
        Domain name to match against. The wildcard "*" is supported if specified before a period: "*.".
        Defaults to matching all domains: "*".
        """
        return pulumi.get(self, "domain")


@pulumi.output_type
class DomainMappingResourceRecord(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 rrdata: Optional[_builtins.str] = None,
                 type: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        :param _builtins.str rrdata: Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        :param _builtins.str type: Resource record type. Example: `AAAA`.
               Possible values are: `A`, `AAAA`, `CNAME`.
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if rrdata is not None:
            pulumi.set(__self__, "rrdata", rrdata)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Relative name of the object affected by this record. Only applicable for CNAME records. Example: 'www'.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def rrdata(self) -> Optional[_builtins.str]:
        """
        Data for this record. Values vary by record type, as defined in RFC 1035 (section 5) and RFC 1034 (section 3.6.1).
        """
        return pulumi.get(self, "rrdata")

    @_builtins.property
    @pulumi.getter
    def type(self) -> Optional[_builtins.str]:
        """
        Resource record type. Example: `AAAA`.
        Possible values are: `A`, `AAAA`, `CNAME`.
        """
        return pulumi.get(self, "type")


@pulumi.output_type
class DomainMappingSslSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sslManagementType":
            suggest = "ssl_management_type"
        elif key == "certificateId":
            suggest = "certificate_id"
        elif key == "pendingManagedCertificateId":
            suggest = "pending_managed_certificate_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DomainMappingSslSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DomainMappingSslSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DomainMappingSslSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ssl_management_type: _builtins.str,
                 certificate_id: Optional[_builtins.str] = None,
                 pending_managed_certificate_id: Optional[_builtins.str] = None):
        """
        :param _builtins.str ssl_management_type: SSL management type for this domain. If `AUTOMATIC`, a managed certificate is automatically provisioned.
               If `MANUAL`, `certificateId` must be manually specified in order to configure SSL for this domain.
               Possible values are: `AUTOMATIC`, `MANUAL`.
        :param _builtins.str certificate_id: ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will
               remove SSL support.
               By default, a managed certificate is automatically created for every domain mapping. To omit SSL support
               or to configure SSL manually, specify `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must be
               authorized to administer the `AuthorizedCertificate` resource to manually map it to a DomainMapping resource.
               Example: 12345.
        :param _builtins.str pending_managed_certificate_id: (Output)
               ID of the managed `AuthorizedCertificate` resource currently being provisioned, if applicable. Until the new
               managed certificate has been successfully provisioned, the previous SSL state will be preserved. Once the
               provisioning process completes, the `certificateId` field will reflect the new managed certificate and this
               field will be left empty. To remove SSL support while there is still a pending managed certificate, clear the
               `certificateId` field with an update request.
        """
        pulumi.set(__self__, "ssl_management_type", ssl_management_type)
        if certificate_id is not None:
            pulumi.set(__self__, "certificate_id", certificate_id)
        if pending_managed_certificate_id is not None:
            pulumi.set(__self__, "pending_managed_certificate_id", pending_managed_certificate_id)

    @_builtins.property
    @pulumi.getter(name="sslManagementType")
    def ssl_management_type(self) -> _builtins.str:
        """
        SSL management type for this domain. If `AUTOMATIC`, a managed certificate is automatically provisioned.
        If `MANUAL`, `certificateId` must be manually specified in order to configure SSL for this domain.
        Possible values are: `AUTOMATIC`, `MANUAL`.
        """
        return pulumi.get(self, "ssl_management_type")

    @_builtins.property
    @pulumi.getter(name="certificateId")
    def certificate_id(self) -> Optional[_builtins.str]:
        """
        ID of the AuthorizedCertificate resource configuring SSL for the application. Clearing this field will
        remove SSL support.
        By default, a managed certificate is automatically created for every domain mapping. To omit SSL support
        or to configure SSL manually, specify `SslManagementType.MANUAL` on a `CREATE` or `UPDATE` request. You must be
        authorized to administer the `AuthorizedCertificate` resource to manually map it to a DomainMapping resource.
        Example: 12345.
        """
        return pulumi.get(self, "certificate_id")

    @_builtins.property
    @pulumi.getter(name="pendingManagedCertificateId")
    def pending_managed_certificate_id(self) -> Optional[_builtins.str]:
        """
        (Output)
        ID of the managed `AuthorizedCertificate` resource currently being provisioned, if applicable. Until the new
        managed certificate has been successfully provisioned, the previous SSL state will be preserved. Once the
        provisioning process completes, the `certificateId` field will reflect the new managed certificate and this
        field will be left empty. To remove SSL support while there is still a pending managed certificate, clear the
        `certificateId` field with an update request.
        """
        return pulumi.get(self, "pending_managed_certificate_id")


@pulumi.output_type
class EngineSplitTrafficSplit(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "shardBy":
            suggest = "shard_by"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EngineSplitTrafficSplit. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EngineSplitTrafficSplit.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EngineSplitTrafficSplit.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 allocations: Mapping[str, _builtins.str],
                 shard_by: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] allocations: Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
        :param _builtins.str shard_by: Mechanism used to determine which version a request is sent to. The traffic selection algorithm will be stable for either type until allocations are changed.
               Possible values are: `UNSPECIFIED`, `COOKIE`, `IP`, `RANDOM`.
        """
        pulumi.set(__self__, "allocations", allocations)
        if shard_by is not None:
            pulumi.set(__self__, "shard_by", shard_by)

    @_builtins.property
    @pulumi.getter
    def allocations(self) -> Mapping[str, _builtins.str]:
        """
        Mapping from version IDs within the service to fractional (0.000, 1] allocations of traffic for that version. Each version can be specified only once, but some versions in the service may not have any traffic allocation. Services that have traffic allocated cannot be deleted until either the service is deleted or their traffic allocation is removed. Allocations must sum to 1. Up to two decimal place precision is supported for IP-based splits and up to three decimal places is supported for cookie-based splits.
        """
        return pulumi.get(self, "allocations")

    @_builtins.property
    @pulumi.getter(name="shardBy")
    def shard_by(self) -> Optional[_builtins.str]:
        """
        Mechanism used to determine which version a request is sent to. The traffic selection algorithm will be stable for either type until allocations are changed.
        Possible values are: `UNSPECIFIED`, `COOKIE`, `IP`, `RANDOM`.
        """
        return pulumi.get(self, "shard_by")


@pulumi.output_type
class FlexibleAppVersionApiConfig(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authFailAction":
            suggest = "auth_fail_action"
        elif key == "securityLevel":
            suggest = "security_level"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionApiConfig. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionApiConfig.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionApiConfig.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script: _builtins.str,
                 auth_fail_action: Optional[_builtins.str] = None,
                 login: Optional[_builtins.str] = None,
                 security_level: Optional[_builtins.str] = None,
                 url: Optional[_builtins.str] = None):
        """
        :param _builtins.str script: Path to the script from the application root directory.
        :param _builtins.str auth_fail_action: Action to take when users access resources that require authentication.
               Default value is `AUTH_FAIL_ACTION_REDIRECT`.
               Possible values are: `AUTH_FAIL_ACTION_REDIRECT`, `AUTH_FAIL_ACTION_UNAUTHORIZED`.
        :param _builtins.str login: Level of login required to access this resource.
               Default value is `LOGIN_OPTIONAL`.
               Possible values are: `LOGIN_OPTIONAL`, `LOGIN_ADMIN`, `LOGIN_REQUIRED`.
        :param _builtins.str security_level: Security (HTTPS) enforcement for this URL.
               Possible values are: `SECURE_DEFAULT`, `SECURE_NEVER`, `SECURE_OPTIONAL`, `SECURE_ALWAYS`.
        :param _builtins.str url: URL to serve the endpoint at.
        """
        pulumi.set(__self__, "script", script)
        if auth_fail_action is not None:
            pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @_builtins.property
    @pulumi.getter
    def script(self) -> _builtins.str:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> Optional[_builtins.str]:
        """
        Action to take when users access resources that require authentication.
        Default value is `AUTH_FAIL_ACTION_REDIRECT`.
        Possible values are: `AUTH_FAIL_ACTION_REDIRECT`, `AUTH_FAIL_ACTION_UNAUTHORIZED`.
        """
        return pulumi.get(self, "auth_fail_action")

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[_builtins.str]:
        """
        Level of login required to access this resource.
        Default value is `LOGIN_OPTIONAL`.
        Possible values are: `LOGIN_OPTIONAL`, `LOGIN_ADMIN`, `LOGIN_REQUIRED`.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[_builtins.str]:
        """
        Security (HTTPS) enforcement for this URL.
        Possible values are: `SECURE_DEFAULT`, `SECURE_NEVER`, `SECURE_OPTIONAL`, `SECURE_ALWAYS`.
        """
        return pulumi.get(self, "security_level")

    @_builtins.property
    @pulumi.getter
    def url(self) -> Optional[_builtins.str]:
        """
        URL to serve the endpoint at.
        """
        return pulumi.get(self, "url")


@pulumi.output_type
class FlexibleAppVersionAutomaticScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cpuUtilization":
            suggest = "cpu_utilization"
        elif key == "coolDownPeriod":
            suggest = "cool_down_period"
        elif key == "diskUtilization":
            suggest = "disk_utilization"
        elif key == "maxConcurrentRequests":
            suggest = "max_concurrent_requests"
        elif key == "maxIdleInstances":
            suggest = "max_idle_instances"
        elif key == "maxPendingLatency":
            suggest = "max_pending_latency"
        elif key == "maxTotalInstances":
            suggest = "max_total_instances"
        elif key == "minIdleInstances":
            suggest = "min_idle_instances"
        elif key == "minPendingLatency":
            suggest = "min_pending_latency"
        elif key == "minTotalInstances":
            suggest = "min_total_instances"
        elif key == "networkUtilization":
            suggest = "network_utilization"
        elif key == "requestUtilization":
            suggest = "request_utilization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionAutomaticScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionAutomaticScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionAutomaticScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu_utilization: 'outputs.FlexibleAppVersionAutomaticScalingCpuUtilization',
                 cool_down_period: Optional[_builtins.str] = None,
                 disk_utilization: Optional['outputs.FlexibleAppVersionAutomaticScalingDiskUtilization'] = None,
                 max_concurrent_requests: Optional[_builtins.int] = None,
                 max_idle_instances: Optional[_builtins.int] = None,
                 max_pending_latency: Optional[_builtins.str] = None,
                 max_total_instances: Optional[_builtins.int] = None,
                 min_idle_instances: Optional[_builtins.int] = None,
                 min_pending_latency: Optional[_builtins.str] = None,
                 min_total_instances: Optional[_builtins.int] = None,
                 network_utilization: Optional['outputs.FlexibleAppVersionAutomaticScalingNetworkUtilization'] = None,
                 request_utilization: Optional['outputs.FlexibleAppVersionAutomaticScalingRequestUtilization'] = None):
        """
        :param 'FlexibleAppVersionAutomaticScalingCpuUtilizationArgs' cpu_utilization: Target scaling by CPU usage.
               Structure is documented below.
        :param _builtins.str cool_down_period: The time period that the Autoscaler should wait before it starts collecting information from a new instance.
               This prevents the autoscaler from collecting information when the instance is initializing,
               during which the collected usage would not be reliable. Default: 120s
        :param 'FlexibleAppVersionAutomaticScalingDiskUtilizationArgs' disk_utilization: Target scaling by disk usage.
               Structure is documented below.
        :param _builtins.int max_concurrent_requests: Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
               Defaults to a runtime-specific value.
        :param _builtins.int max_idle_instances: Maximum number of idle instances that should be maintained for this version.
        :param _builtins.str max_pending_latency: Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        :param _builtins.int max_total_instances: Maximum number of instances that should be started to handle requests for this version. Default: 20
        :param _builtins.int min_idle_instances: Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        :param _builtins.str min_pending_latency: Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        :param _builtins.int min_total_instances: Minimum number of running instances that should be maintained for this version. Default: 2
        :param 'FlexibleAppVersionAutomaticScalingNetworkUtilizationArgs' network_utilization: Target scaling by network usage.
               Structure is documented below.
        :param 'FlexibleAppVersionAutomaticScalingRequestUtilizationArgs' request_utilization: Target scaling by request utilization.
               Structure is documented below.
        """
        pulumi.set(__self__, "cpu_utilization", cpu_utilization)
        if cool_down_period is not None:
            pulumi.set(__self__, "cool_down_period", cool_down_period)
        if disk_utilization is not None:
            pulumi.set(__self__, "disk_utilization", disk_utilization)
        if max_concurrent_requests is not None:
            pulumi.set(__self__, "max_concurrent_requests", max_concurrent_requests)
        if max_idle_instances is not None:
            pulumi.set(__self__, "max_idle_instances", max_idle_instances)
        if max_pending_latency is not None:
            pulumi.set(__self__, "max_pending_latency", max_pending_latency)
        if max_total_instances is not None:
            pulumi.set(__self__, "max_total_instances", max_total_instances)
        if min_idle_instances is not None:
            pulumi.set(__self__, "min_idle_instances", min_idle_instances)
        if min_pending_latency is not None:
            pulumi.set(__self__, "min_pending_latency", min_pending_latency)
        if min_total_instances is not None:
            pulumi.set(__self__, "min_total_instances", min_total_instances)
        if network_utilization is not None:
            pulumi.set(__self__, "network_utilization", network_utilization)
        if request_utilization is not None:
            pulumi.set(__self__, "request_utilization", request_utilization)

    @_builtins.property
    @pulumi.getter(name="cpuUtilization")
    def cpu_utilization(self) -> 'outputs.FlexibleAppVersionAutomaticScalingCpuUtilization':
        """
        Target scaling by CPU usage.
        Structure is documented below.
        """
        return pulumi.get(self, "cpu_utilization")

    @_builtins.property
    @pulumi.getter(name="coolDownPeriod")
    def cool_down_period(self) -> Optional[_builtins.str]:
        """
        The time period that the Autoscaler should wait before it starts collecting information from a new instance.
        This prevents the autoscaler from collecting information when the instance is initializing,
        during which the collected usage would not be reliable. Default: 120s
        """
        return pulumi.get(self, "cool_down_period")

    @_builtins.property
    @pulumi.getter(name="diskUtilization")
    def disk_utilization(self) -> Optional['outputs.FlexibleAppVersionAutomaticScalingDiskUtilization']:
        """
        Target scaling by disk usage.
        Structure is documented below.
        """
        return pulumi.get(self, "disk_utilization")

    @_builtins.property
    @pulumi.getter(name="maxConcurrentRequests")
    def max_concurrent_requests(self) -> Optional[_builtins.int]:
        """
        Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
        Defaults to a runtime-specific value.
        """
        return pulumi.get(self, "max_concurrent_requests")

    @_builtins.property
    @pulumi.getter(name="maxIdleInstances")
    def max_idle_instances(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle instances that should be maintained for this version.
        """
        return pulumi.get(self, "max_idle_instances")

    @_builtins.property
    @pulumi.getter(name="maxPendingLatency")
    def max_pending_latency(self) -> Optional[_builtins.str]:
        """
        Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        """
        return pulumi.get(self, "max_pending_latency")

    @_builtins.property
    @pulumi.getter(name="maxTotalInstances")
    def max_total_instances(self) -> Optional[_builtins.int]:
        """
        Maximum number of instances that should be started to handle requests for this version. Default: 20
        """
        return pulumi.get(self, "max_total_instances")

    @_builtins.property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> Optional[_builtins.int]:
        """
        Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        """
        return pulumi.get(self, "min_idle_instances")

    @_builtins.property
    @pulumi.getter(name="minPendingLatency")
    def min_pending_latency(self) -> Optional[_builtins.str]:
        """
        Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        """
        return pulumi.get(self, "min_pending_latency")

    @_builtins.property
    @pulumi.getter(name="minTotalInstances")
    def min_total_instances(self) -> Optional[_builtins.int]:
        """
        Minimum number of running instances that should be maintained for this version. Default: 2
        """
        return pulumi.get(self, "min_total_instances")

    @_builtins.property
    @pulumi.getter(name="networkUtilization")
    def network_utilization(self) -> Optional['outputs.FlexibleAppVersionAutomaticScalingNetworkUtilization']:
        """
        Target scaling by network usage.
        Structure is documented below.
        """
        return pulumi.get(self, "network_utilization")

    @_builtins.property
    @pulumi.getter(name="requestUtilization")
    def request_utilization(self) -> Optional['outputs.FlexibleAppVersionAutomaticScalingRequestUtilization']:
        """
        Target scaling by request utilization.
        Structure is documented below.
        """
        return pulumi.get(self, "request_utilization")


@pulumi.output_type
class FlexibleAppVersionAutomaticScalingCpuUtilization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetUtilization":
            suggest = "target_utilization"
        elif key == "aggregationWindowLength":
            suggest = "aggregation_window_length"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionAutomaticScalingCpuUtilization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionAutomaticScalingCpuUtilization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionAutomaticScalingCpuUtilization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_utilization: _builtins.float,
                 aggregation_window_length: Optional[_builtins.str] = None):
        """
        :param _builtins.float target_utilization: Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        :param _builtins.str aggregation_window_length: Period of time over which CPU utilization is calculated.
        """
        pulumi.set(__self__, "target_utilization", target_utilization)
        if aggregation_window_length is not None:
            pulumi.set(__self__, "aggregation_window_length", aggregation_window_length)

    @_builtins.property
    @pulumi.getter(name="targetUtilization")
    def target_utilization(self) -> _builtins.float:
        """
        Target CPU utilization ratio to maintain when scaling. Must be between 0 and 1.
        """
        return pulumi.get(self, "target_utilization")

    @_builtins.property
    @pulumi.getter(name="aggregationWindowLength")
    def aggregation_window_length(self) -> Optional[_builtins.str]:
        """
        Period of time over which CPU utilization is calculated.
        """
        return pulumi.get(self, "aggregation_window_length")


@pulumi.output_type
class FlexibleAppVersionAutomaticScalingDiskUtilization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetReadBytesPerSecond":
            suggest = "target_read_bytes_per_second"
        elif key == "targetReadOpsPerSecond":
            suggest = "target_read_ops_per_second"
        elif key == "targetWriteBytesPerSecond":
            suggest = "target_write_bytes_per_second"
        elif key == "targetWriteOpsPerSecond":
            suggest = "target_write_ops_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionAutomaticScalingDiskUtilization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionAutomaticScalingDiskUtilization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionAutomaticScalingDiskUtilization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_read_bytes_per_second: Optional[_builtins.int] = None,
                 target_read_ops_per_second: Optional[_builtins.int] = None,
                 target_write_bytes_per_second: Optional[_builtins.int] = None,
                 target_write_ops_per_second: Optional[_builtins.int] = None):
        """
        :param _builtins.int target_read_bytes_per_second: Target bytes read per second.
        :param _builtins.int target_read_ops_per_second: Target ops read per seconds.
        :param _builtins.int target_write_bytes_per_second: Target bytes written per second.
        :param _builtins.int target_write_ops_per_second: Target ops written per second.
        """
        if target_read_bytes_per_second is not None:
            pulumi.set(__self__, "target_read_bytes_per_second", target_read_bytes_per_second)
        if target_read_ops_per_second is not None:
            pulumi.set(__self__, "target_read_ops_per_second", target_read_ops_per_second)
        if target_write_bytes_per_second is not None:
            pulumi.set(__self__, "target_write_bytes_per_second", target_write_bytes_per_second)
        if target_write_ops_per_second is not None:
            pulumi.set(__self__, "target_write_ops_per_second", target_write_ops_per_second)

    @_builtins.property
    @pulumi.getter(name="targetReadBytesPerSecond")
    def target_read_bytes_per_second(self) -> Optional[_builtins.int]:
        """
        Target bytes read per second.
        """
        return pulumi.get(self, "target_read_bytes_per_second")

    @_builtins.property
    @pulumi.getter(name="targetReadOpsPerSecond")
    def target_read_ops_per_second(self) -> Optional[_builtins.int]:
        """
        Target ops read per seconds.
        """
        return pulumi.get(self, "target_read_ops_per_second")

    @_builtins.property
    @pulumi.getter(name="targetWriteBytesPerSecond")
    def target_write_bytes_per_second(self) -> Optional[_builtins.int]:
        """
        Target bytes written per second.
        """
        return pulumi.get(self, "target_write_bytes_per_second")

    @_builtins.property
    @pulumi.getter(name="targetWriteOpsPerSecond")
    def target_write_ops_per_second(self) -> Optional[_builtins.int]:
        """
        Target ops written per second.
        """
        return pulumi.get(self, "target_write_ops_per_second")


@pulumi.output_type
class FlexibleAppVersionAutomaticScalingNetworkUtilization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetReceivedBytesPerSecond":
            suggest = "target_received_bytes_per_second"
        elif key == "targetReceivedPacketsPerSecond":
            suggest = "target_received_packets_per_second"
        elif key == "targetSentBytesPerSecond":
            suggest = "target_sent_bytes_per_second"
        elif key == "targetSentPacketsPerSecond":
            suggest = "target_sent_packets_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionAutomaticScalingNetworkUtilization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionAutomaticScalingNetworkUtilization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionAutomaticScalingNetworkUtilization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_received_bytes_per_second: Optional[_builtins.int] = None,
                 target_received_packets_per_second: Optional[_builtins.int] = None,
                 target_sent_bytes_per_second: Optional[_builtins.int] = None,
                 target_sent_packets_per_second: Optional[_builtins.int] = None):
        """
        :param _builtins.int target_received_bytes_per_second: Target bytes received per second.
        :param _builtins.int target_received_packets_per_second: Target packets received per second.
        :param _builtins.int target_sent_bytes_per_second: Target bytes sent per second.
        :param _builtins.int target_sent_packets_per_second: Target packets sent per second.
        """
        if target_received_bytes_per_second is not None:
            pulumi.set(__self__, "target_received_bytes_per_second", target_received_bytes_per_second)
        if target_received_packets_per_second is not None:
            pulumi.set(__self__, "target_received_packets_per_second", target_received_packets_per_second)
        if target_sent_bytes_per_second is not None:
            pulumi.set(__self__, "target_sent_bytes_per_second", target_sent_bytes_per_second)
        if target_sent_packets_per_second is not None:
            pulumi.set(__self__, "target_sent_packets_per_second", target_sent_packets_per_second)

    @_builtins.property
    @pulumi.getter(name="targetReceivedBytesPerSecond")
    def target_received_bytes_per_second(self) -> Optional[_builtins.int]:
        """
        Target bytes received per second.
        """
        return pulumi.get(self, "target_received_bytes_per_second")

    @_builtins.property
    @pulumi.getter(name="targetReceivedPacketsPerSecond")
    def target_received_packets_per_second(self) -> Optional[_builtins.int]:
        """
        Target packets received per second.
        """
        return pulumi.get(self, "target_received_packets_per_second")

    @_builtins.property
    @pulumi.getter(name="targetSentBytesPerSecond")
    def target_sent_bytes_per_second(self) -> Optional[_builtins.int]:
        """
        Target bytes sent per second.
        """
        return pulumi.get(self, "target_sent_bytes_per_second")

    @_builtins.property
    @pulumi.getter(name="targetSentPacketsPerSecond")
    def target_sent_packets_per_second(self) -> Optional[_builtins.int]:
        """
        Target packets sent per second.
        """
        return pulumi.get(self, "target_sent_packets_per_second")


@pulumi.output_type
class FlexibleAppVersionAutomaticScalingRequestUtilization(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "targetConcurrentRequests":
            suggest = "target_concurrent_requests"
        elif key == "targetRequestCountPerSecond":
            suggest = "target_request_count_per_second"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionAutomaticScalingRequestUtilization. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionAutomaticScalingRequestUtilization.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionAutomaticScalingRequestUtilization.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 target_concurrent_requests: Optional[_builtins.float] = None,
                 target_request_count_per_second: Optional[_builtins.str] = None):
        """
        :param _builtins.float target_concurrent_requests: Target number of concurrent requests.
        :param _builtins.str target_request_count_per_second: Target requests per second.
        """
        if target_concurrent_requests is not None:
            pulumi.set(__self__, "target_concurrent_requests", target_concurrent_requests)
        if target_request_count_per_second is not None:
            pulumi.set(__self__, "target_request_count_per_second", target_request_count_per_second)

    @_builtins.property
    @pulumi.getter(name="targetConcurrentRequests")
    def target_concurrent_requests(self) -> Optional[_builtins.float]:
        """
        Target number of concurrent requests.
        """
        return pulumi.get(self, "target_concurrent_requests")

    @_builtins.property
    @pulumi.getter(name="targetRequestCountPerSecond")
    def target_request_count_per_second(self) -> Optional[_builtins.str]:
        """
        Target requests per second.
        """
        return pulumi.get(self, "target_request_count_per_second")


@pulumi.output_type
class FlexibleAppVersionDeployment(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cloudBuildOptions":
            suggest = "cloud_build_options"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionDeployment. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionDeployment.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionDeployment.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cloud_build_options: Optional['outputs.FlexibleAppVersionDeploymentCloudBuildOptions'] = None,
                 container: Optional['outputs.FlexibleAppVersionDeploymentContainer'] = None,
                 files: Optional[Sequence['outputs.FlexibleAppVersionDeploymentFile']] = None,
                 zip: Optional['outputs.FlexibleAppVersionDeploymentZip'] = None):
        """
        :param 'FlexibleAppVersionDeploymentCloudBuildOptionsArgs' cloud_build_options: Options for the build operations performed as a part of the version deployment. Only applicable when creating a version using source code directly.
               Structure is documented below.
        :param 'FlexibleAppVersionDeploymentContainerArgs' container: The Docker image for the container that runs the version.
               Structure is documented below.
        :param Sequence['FlexibleAppVersionDeploymentFileArgs'] files: Manifest of the files stored in Google Cloud Storage that are included as part of this version.
               All files must be readable using the credentials supplied with this call.
               Structure is documented below.
        :param 'FlexibleAppVersionDeploymentZipArgs' zip: Zip File
               Structure is documented below.
        """
        if cloud_build_options is not None:
            pulumi.set(__self__, "cloud_build_options", cloud_build_options)
        if container is not None:
            pulumi.set(__self__, "container", container)
        if files is not None:
            pulumi.set(__self__, "files", files)
        if zip is not None:
            pulumi.set(__self__, "zip", zip)

    @_builtins.property
    @pulumi.getter(name="cloudBuildOptions")
    def cloud_build_options(self) -> Optional['outputs.FlexibleAppVersionDeploymentCloudBuildOptions']:
        """
        Options for the build operations performed as a part of the version deployment. Only applicable when creating a version using source code directly.
        Structure is documented below.
        """
        return pulumi.get(self, "cloud_build_options")

    @_builtins.property
    @pulumi.getter
    def container(self) -> Optional['outputs.FlexibleAppVersionDeploymentContainer']:
        """
        The Docker image for the container that runs the version.
        Structure is documented below.
        """
        return pulumi.get(self, "container")

    @_builtins.property
    @pulumi.getter
    def files(self) -> Optional[Sequence['outputs.FlexibleAppVersionDeploymentFile']]:
        """
        Manifest of the files stored in Google Cloud Storage that are included as part of this version.
        All files must be readable using the credentials supplied with this call.
        Structure is documented below.
        """
        return pulumi.get(self, "files")

    @_builtins.property
    @pulumi.getter
    def zip(self) -> Optional['outputs.FlexibleAppVersionDeploymentZip']:
        """
        Zip File
        Structure is documented below.
        """
        return pulumi.get(self, "zip")


@pulumi.output_type
class FlexibleAppVersionDeploymentCloudBuildOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appYamlPath":
            suggest = "app_yaml_path"
        elif key == "cloudBuildTimeout":
            suggest = "cloud_build_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionDeploymentCloudBuildOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionDeploymentCloudBuildOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionDeploymentCloudBuildOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 app_yaml_path: _builtins.str,
                 cloud_build_timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str app_yaml_path: Path to the yaml file used in deployment, used to determine runtime configuration details.
        :param _builtins.str cloud_build_timeout: The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        pulumi.set(__self__, "app_yaml_path", app_yaml_path)
        if cloud_build_timeout is not None:
            pulumi.set(__self__, "cloud_build_timeout", cloud_build_timeout)

    @_builtins.property
    @pulumi.getter(name="appYamlPath")
    def app_yaml_path(self) -> _builtins.str:
        """
        Path to the yaml file used in deployment, used to determine runtime configuration details.
        """
        return pulumi.get(self, "app_yaml_path")

    @_builtins.property
    @pulumi.getter(name="cloudBuildTimeout")
    def cloud_build_timeout(self) -> Optional[_builtins.str]:
        """
        The Cloud Build timeout used as part of any dependent builds performed by version creation. Defaults to 10 minutes.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "cloud_build_timeout")


@pulumi.output_type
class FlexibleAppVersionDeploymentContainer(dict):
    def __init__(__self__, *,
                 image: _builtins.str):
        """
        :param _builtins.str image: URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest.
               Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        pulumi.set(__self__, "image", image)

    @_builtins.property
    @pulumi.getter
    def image(self) -> _builtins.str:
        """
        URI to the hosted container image in Google Container Registry. The URI must be fully qualified and include a tag or digest.
        Examples: "gcr.io/my-project/image:tag" or "gcr.io/my-project/image@digest"
        """
        return pulumi.get(self, "image")


@pulumi.output_type
class FlexibleAppVersionDeploymentFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceUrl":
            suggest = "source_url"
        elif key == "sha1Sum":
            suggest = "sha1_sum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionDeploymentFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionDeploymentFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionDeploymentFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 source_url: _builtins.str,
                 sha1_sum: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The identifier for this object. Format specified above.
        :param _builtins.str source_url: Source URL
        :param _builtins.str sha1_sum: SHA1 checksum of the file
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source_url", source_url)
        if sha1_sum is not None:
            pulumi.set(__self__, "sha1_sum", sha1_sum)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> _builtins.str:
        """
        Source URL
        """
        return pulumi.get(self, "source_url")

    @_builtins.property
    @pulumi.getter(name="sha1Sum")
    def sha1_sum(self) -> Optional[_builtins.str]:
        """
        SHA1 checksum of the file
        """
        return pulumi.get(self, "sha1_sum")


@pulumi.output_type
class FlexibleAppVersionDeploymentZip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceUrl":
            suggest = "source_url"
        elif key == "filesCount":
            suggest = "files_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionDeploymentZip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionDeploymentZip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionDeploymentZip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_url: _builtins.str,
                 files_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str source_url: Source URL
        :param _builtins.int files_count: files count
        """
        pulumi.set(__self__, "source_url", source_url)
        if files_count is not None:
            pulumi.set(__self__, "files_count", files_count)

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> _builtins.str:
        """
        Source URL
        """
        return pulumi.get(self, "source_url")

    @_builtins.property
    @pulumi.getter(name="filesCount")
    def files_count(self) -> Optional[_builtins.int]:
        """
        files count
        """
        return pulumi.get(self, "files_count")


@pulumi.output_type
class FlexibleAppVersionEndpointsApiService(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "configId":
            suggest = "config_id"
        elif key == "disableTraceSampling":
            suggest = "disable_trace_sampling"
        elif key == "rolloutStrategy":
            suggest = "rollout_strategy"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionEndpointsApiService. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionEndpointsApiService.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionEndpointsApiService.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 config_id: Optional[_builtins.str] = None,
                 disable_trace_sampling: Optional[_builtins.bool] = None,
                 rollout_strategy: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Endpoints service name which is the name of the "service" resource in the Service Management API.
               For example "myapi.endpoints.myproject.cloud.goog"
        :param _builtins.str config_id: Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".
               By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
               When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
               and is required in this case.
               Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
               the configuration ID. In this case, configId must be omitted.
        :param _builtins.bool disable_trace_sampling: Enable or disable trace sampling. By default, this is set to false for enabled.
        :param _builtins.str rollout_strategy: Endpoints rollout strategy. If FIXED, configId must be specified. If MANAGED, configId must be omitted.
               Default value is `FIXED`.
               Possible values are: `FIXED`, `MANAGED`.
        """
        pulumi.set(__self__, "name", name)
        if config_id is not None:
            pulumi.set(__self__, "config_id", config_id)
        if disable_trace_sampling is not None:
            pulumi.set(__self__, "disable_trace_sampling", disable_trace_sampling)
        if rollout_strategy is not None:
            pulumi.set(__self__, "rollout_strategy", rollout_strategy)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Endpoints service name which is the name of the "service" resource in the Service Management API.
        For example "myapi.endpoints.myproject.cloud.goog"
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="configId")
    def config_id(self) -> Optional[_builtins.str]:
        """
        Endpoints service configuration ID as specified by the Service Management API. For example "2016-09-19r1".
        By default, the rollout strategy for Endpoints is "FIXED". This means that Endpoints starts up with a particular configuration ID.
        When a new configuration is rolled out, Endpoints must be given the new configuration ID. The configId field is used to give the configuration ID
        and is required in this case.
        Endpoints also has a rollout strategy called "MANAGED". When using this, Endpoints fetches the latest configuration and does not need
        the configuration ID. In this case, configId must be omitted.
        """
        return pulumi.get(self, "config_id")

    @_builtins.property
    @pulumi.getter(name="disableTraceSampling")
    def disable_trace_sampling(self) -> Optional[_builtins.bool]:
        """
        Enable or disable trace sampling. By default, this is set to false for enabled.
        """
        return pulumi.get(self, "disable_trace_sampling")

    @_builtins.property
    @pulumi.getter(name="rolloutStrategy")
    def rollout_strategy(self) -> Optional[_builtins.str]:
        """
        Endpoints rollout strategy. If FIXED, configId must be specified. If MANAGED, configId must be omitted.
        Default value is `FIXED`.
        Possible values are: `FIXED`, `MANAGED`.
        """
        return pulumi.get(self, "rollout_strategy")


@pulumi.output_type
class FlexibleAppVersionEntrypoint(dict):
    def __init__(__self__, *,
                 shell: _builtins.str):
        """
        :param _builtins.str shell: The format should be a shell command that can be fed to bash -c.
        """
        pulumi.set(__self__, "shell", shell)

    @_builtins.property
    @pulumi.getter
    def shell(self) -> _builtins.str:
        """
        The format should be a shell command that can be fed to bash -c.
        """
        return pulumi.get(self, "shell")


@pulumi.output_type
class FlexibleAppVersionFlexibleRuntimeSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "operatingSystem":
            suggest = "operating_system"
        elif key == "runtimeVersion":
            suggest = "runtime_version"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionFlexibleRuntimeSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionFlexibleRuntimeSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionFlexibleRuntimeSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 operating_system: Optional[_builtins.str] = None,
                 runtime_version: Optional[_builtins.str] = None):
        """
        :param _builtins.str operating_system: Operating System of the application runtime.
        :param _builtins.str runtime_version: The runtime version of an App Engine flexible application.
        """
        if operating_system is not None:
            pulumi.set(__self__, "operating_system", operating_system)
        if runtime_version is not None:
            pulumi.set(__self__, "runtime_version", runtime_version)

    @_builtins.property
    @pulumi.getter(name="operatingSystem")
    def operating_system(self) -> Optional[_builtins.str]:
        """
        Operating System of the application runtime.
        """
        return pulumi.get(self, "operating_system")

    @_builtins.property
    @pulumi.getter(name="runtimeVersion")
    def runtime_version(self) -> Optional[_builtins.str]:
        """
        The runtime version of an App Engine flexible application.
        """
        return pulumi.get(self, "runtime_version")


@pulumi.output_type
class FlexibleAppVersionHandler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authFailAction":
            suggest = "auth_fail_action"
        elif key == "redirectHttpResponseCode":
            suggest = "redirect_http_response_code"
        elif key == "securityLevel":
            suggest = "security_level"
        elif key == "staticFiles":
            suggest = "static_files"
        elif key == "urlRegex":
            suggest = "url_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionHandler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionHandler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionHandler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_fail_action: Optional[_builtins.str] = None,
                 login: Optional[_builtins.str] = None,
                 redirect_http_response_code: Optional[_builtins.str] = None,
                 script: Optional['outputs.FlexibleAppVersionHandlerScript'] = None,
                 security_level: Optional[_builtins.str] = None,
                 static_files: Optional['outputs.FlexibleAppVersionHandlerStaticFiles'] = None,
                 url_regex: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_fail_action: Actions to take when the user is not logged in.
               Possible values are: `AUTH_FAIL_ACTION_REDIRECT`, `AUTH_FAIL_ACTION_UNAUTHORIZED`.
        :param _builtins.str login: Methods to restrict access to a URL based on login status.
               Possible values are: `LOGIN_OPTIONAL`, `LOGIN_ADMIN`, `LOGIN_REQUIRED`.
        :param _builtins.str redirect_http_response_code: 30x code to use when performing redirects for the secure field.
               Possible values are: `REDIRECT_HTTP_RESPONSE_CODE_301`, `REDIRECT_HTTP_RESPONSE_CODE_302`, `REDIRECT_HTTP_RESPONSE_CODE_303`, `REDIRECT_HTTP_RESPONSE_CODE_307`.
        :param 'FlexibleAppVersionHandlerScriptArgs' script: Executes a script to handle the requests that match this URL pattern.
               Only the auto value is supported for Node.js in the App Engine standard environment, for example "script:" "auto".
               Structure is documented below.
        :param _builtins.str security_level: Security (HTTPS) enforcement for this URL.
               Possible values are: `SECURE_DEFAULT`, `SECURE_NEVER`, `SECURE_OPTIONAL`, `SECURE_ALWAYS`.
        :param 'FlexibleAppVersionHandlerStaticFilesArgs' static_files: Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files.
               Static file handlers describe which files in the application directory are static files, and which URLs serve them.
               Structure is documented below.
        :param _builtins.str url_regex: URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
               All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        if auth_fail_action is not None:
            pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if redirect_http_response_code is not None:
            pulumi.set(__self__, "redirect_http_response_code", redirect_http_response_code)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)
        if static_files is not None:
            pulumi.set(__self__, "static_files", static_files)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)

    @_builtins.property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> Optional[_builtins.str]:
        """
        Actions to take when the user is not logged in.
        Possible values are: `AUTH_FAIL_ACTION_REDIRECT`, `AUTH_FAIL_ACTION_UNAUTHORIZED`.
        """
        return pulumi.get(self, "auth_fail_action")

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[_builtins.str]:
        """
        Methods to restrict access to a URL based on login status.
        Possible values are: `LOGIN_OPTIONAL`, `LOGIN_ADMIN`, `LOGIN_REQUIRED`.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="redirectHttpResponseCode")
    def redirect_http_response_code(self) -> Optional[_builtins.str]:
        """
        30x code to use when performing redirects for the secure field.
        Possible values are: `REDIRECT_HTTP_RESPONSE_CODE_301`, `REDIRECT_HTTP_RESPONSE_CODE_302`, `REDIRECT_HTTP_RESPONSE_CODE_303`, `REDIRECT_HTTP_RESPONSE_CODE_307`.
        """
        return pulumi.get(self, "redirect_http_response_code")

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional['outputs.FlexibleAppVersionHandlerScript']:
        """
        Executes a script to handle the requests that match this URL pattern.
        Only the auto value is supported for Node.js in the App Engine standard environment, for example "script:" "auto".
        Structure is documented below.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[_builtins.str]:
        """
        Security (HTTPS) enforcement for this URL.
        Possible values are: `SECURE_DEFAULT`, `SECURE_NEVER`, `SECURE_OPTIONAL`, `SECURE_ALWAYS`.
        """
        return pulumi.get(self, "security_level")

    @_builtins.property
    @pulumi.getter(name="staticFiles")
    def static_files(self) -> Optional['outputs.FlexibleAppVersionHandlerStaticFiles']:
        """
        Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files.
        Static file handlers describe which files in the application directory are static files, and which URLs serve them.
        Structure is documented below.
        """
        return pulumi.get(self, "static_files")

    @_builtins.property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[_builtins.str]:
        """
        URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
        All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        return pulumi.get(self, "url_regex")


@pulumi.output_type
class FlexibleAppVersionHandlerScript(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionHandlerScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionHandlerScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionHandlerScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_path: _builtins.str):
        """
        :param _builtins.str script_path: Path to the script from the application root directory.
        """
        pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> _builtins.str:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class FlexibleAppVersionHandlerStaticFiles(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationReadable":
            suggest = "application_readable"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "mimeType":
            suggest = "mime_type"
        elif key == "requireMatchingFile":
            suggest = "require_matching_file"
        elif key == "uploadPathRegex":
            suggest = "upload_path_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionHandlerStaticFiles. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionHandlerStaticFiles.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionHandlerStaticFiles.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_readable: Optional[_builtins.bool] = None,
                 expiration: Optional[_builtins.str] = None,
                 http_headers: Optional[Mapping[str, _builtins.str]] = None,
                 mime_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 require_matching_file: Optional[_builtins.bool] = None,
                 upload_path_regex: Optional[_builtins.str] = None):
        """
        :param _builtins.bool application_readable: Whether files should also be uploaded as code data. By default, files declared in static file handlers are
               uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
               uploads are charged against both your code and static data storage resource quotas.
        :param _builtins.str expiration: Time a static file served by this handler should be cached by web proxies and browsers.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
               Default is '0s'
        :param Mapping[str, _builtins.str] http_headers: HTTP headers to use for all responses from these URLs.
               An object containing a list of "key:value" value pairs.".
        :param _builtins.str mime_type: MIME type used to serve all files served by this handler.
               Defaults to file-specific MIME types, which are derived from each file's filename extension.
        :param _builtins.str path: Path to the static files matched by the URL pattern, from the application root directory.
               The path can refer to text matched in groupings in the URL pattern.
        :param _builtins.bool require_matching_file: Whether this handler should match the request if the file referenced by the handler does not exist.
        :param _builtins.str upload_path_regex: Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        if application_readable is not None:
            pulumi.set(__self__, "application_readable", application_readable)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if require_matching_file is not None:
            pulumi.set(__self__, "require_matching_file", require_matching_file)
        if upload_path_regex is not None:
            pulumi.set(__self__, "upload_path_regex", upload_path_regex)

    @_builtins.property
    @pulumi.getter(name="applicationReadable")
    def application_readable(self) -> Optional[_builtins.bool]:
        """
        Whether files should also be uploaded as code data. By default, files declared in static file handlers are
        uploaded as static data and are only served to end users; they cannot be read by the application. If enabled,
        uploads are charged against both your code and static data storage resource quotas.
        """
        return pulumi.get(self, "application_readable")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[_builtins.str]:
        """
        Time a static file served by this handler should be cached by web proxies and browsers.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
        Default is '0s'
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        HTTP headers to use for all responses from these URLs.
        An object containing a list of "key:value" value pairs.".
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[_builtins.str]:
        """
        MIME type used to serve all files served by this handler.
        Defaults to file-specific MIME types, which are derived from each file's filename extension.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to the static files matched by the URL pattern, from the application root directory.
        The path can refer to text matched in groupings in the URL pattern.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="requireMatchingFile")
    def require_matching_file(self) -> Optional[_builtins.bool]:
        """
        Whether this handler should match the request if the file referenced by the handler does not exist.
        """
        return pulumi.get(self, "require_matching_file")

    @_builtins.property
    @pulumi.getter(name="uploadPathRegex")
    def upload_path_regex(self) -> Optional[_builtins.str]:
        """
        Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        return pulumi.get(self, "upload_path_regex")


@pulumi.output_type
class FlexibleAppVersionLivenessCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "checkInterval":
            suggest = "check_interval"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "initialDelay":
            suggest = "initial_delay"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionLivenessCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionLivenessCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionLivenessCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 check_interval: Optional[_builtins.str] = None,
                 failure_threshold: Optional[_builtins.float] = None,
                 host: Optional[_builtins.str] = None,
                 initial_delay: Optional[_builtins.str] = None,
                 success_threshold: Optional[_builtins.float] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The request path.
        :param _builtins.str check_interval: Interval between health checks.
        :param _builtins.float failure_threshold: Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
        :param _builtins.str host: Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        :param _builtins.str initial_delay: The initial delay before starting to execute the checks. Default: "300s"
        :param _builtins.float success_threshold: Number of consecutive successful checks required before considering the VM healthy. Default: 2.
        :param _builtins.str timeout: Time before the check is considered failed. Default: "4s"
        """
        pulumi.set(__self__, "path", path)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if initial_delay is not None:
            pulumi.set(__self__, "initial_delay", initial_delay)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The request path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[_builtins.str]:
        """
        Interval between health checks.
        """
        return pulumi.get(self, "check_interval")

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.float]:
        """
        Number of consecutive failed checks required before considering the VM unhealthy. Default: 4.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="initialDelay")
    def initial_delay(self) -> Optional[_builtins.str]:
        """
        The initial delay before starting to execute the checks. Default: "300s"
        """
        return pulumi.get(self, "initial_delay")

    @_builtins.property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[_builtins.float]:
        """
        Number of consecutive successful checks required before considering the VM healthy. Default: 2.
        """
        return pulumi.get(self, "success_threshold")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Time before the check is considered failed. Default: "4s"
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class FlexibleAppVersionManualScaling(dict):
    def __init__(__self__, *,
                 instances: _builtins.int):
        """
        :param _builtins.int instances: Number of instances to assign to the service at the start.
               **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
               Modules API set_num_instances() you must use `lifecycle.ignore_changes = ["manual_scaling"[0].instances]` to prevent drift detection.
        """
        pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> _builtins.int:
        """
        Number of instances to assign to the service at the start.
        **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
        Modules API set_num_instances() you must use `lifecycle.ignore_changes = ["manual_scaling"[0].instances]` to prevent drift detection.
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class FlexibleAppVersionNetwork(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "forwardedPorts":
            suggest = "forwarded_ports"
        elif key == "instanceIpMode":
            suggest = "instance_ip_mode"
        elif key == "instanceTag":
            suggest = "instance_tag"
        elif key == "sessionAffinity":
            suggest = "session_affinity"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionNetwork. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionNetwork.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionNetwork.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 forwarded_ports: Optional[Sequence[_builtins.str]] = None,
                 instance_ip_mode: Optional[_builtins.str] = None,
                 instance_tag: Optional[_builtins.str] = None,
                 session_affinity: Optional[_builtins.bool] = None,
                 subnetwork: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
        :param Sequence[_builtins.str] forwarded_ports: List of ports, or port pairs, to forward from the virtual machine to the application container.
        :param _builtins.str instance_ip_mode: Prevent instances from receiving an ephemeral external IP address.
               Possible values are: `EXTERNAL`, `INTERNAL`.
        :param _builtins.str instance_tag: Tag to apply to the instance during creation.
        :param _builtins.bool session_affinity: Enable session affinity.
        :param _builtins.str subnetwork: Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.
               If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
               If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
               If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
               If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        pulumi.set(__self__, "name", name)
        if forwarded_ports is not None:
            pulumi.set(__self__, "forwarded_ports", forwarded_ports)
        if instance_ip_mode is not None:
            pulumi.set(__self__, "instance_ip_mode", instance_ip_mode)
        if instance_tag is not None:
            pulumi.set(__self__, "instance_tag", instance_tag)
        if session_affinity is not None:
            pulumi.set(__self__, "session_affinity", session_affinity)
        if subnetwork is not None:
            pulumi.set(__self__, "subnetwork", subnetwork)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Google Compute Engine network where the virtual machines are created. Specify the short name, not the resource path.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="forwardedPorts")
    def forwarded_ports(self) -> Optional[Sequence[_builtins.str]]:
        """
        List of ports, or port pairs, to forward from the virtual machine to the application container.
        """
        return pulumi.get(self, "forwarded_ports")

    @_builtins.property
    @pulumi.getter(name="instanceIpMode")
    def instance_ip_mode(self) -> Optional[_builtins.str]:
        """
        Prevent instances from receiving an ephemeral external IP address.
        Possible values are: `EXTERNAL`, `INTERNAL`.
        """
        return pulumi.get(self, "instance_ip_mode")

    @_builtins.property
    @pulumi.getter(name="instanceTag")
    def instance_tag(self) -> Optional[_builtins.str]:
        """
        Tag to apply to the instance during creation.
        """
        return pulumi.get(self, "instance_tag")

    @_builtins.property
    @pulumi.getter(name="sessionAffinity")
    def session_affinity(self) -> Optional[_builtins.bool]:
        """
        Enable session affinity.
        """
        return pulumi.get(self, "session_affinity")

    @_builtins.property
    @pulumi.getter
    def subnetwork(self) -> Optional[_builtins.str]:
        """
        Google Cloud Platform sub-network where the virtual machines are created. Specify the short name, not the resource path.
        If the network that the instance is being created in is a Legacy network, then the IP address is allocated from the IPv4Range.
        If the network that the instance is being created in is an auto Subnet Mode Network, then only network name should be specified (not the subnetworkName) and the IP address is created from the IPCidrRange of the subnetwork that exists in that zone for that network.
        If the network that the instance is being created in is a custom Subnet Mode Network, then the subnetworkName must be specified and the IP address is created from the IPCidrRange of the subnetwork.
        If specified, the subnetwork must exist in the same region as the App Engine flexible environment application.
        """
        return pulumi.get(self, "subnetwork")


@pulumi.output_type
class FlexibleAppVersionReadinessCheck(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "appStartTimeout":
            suggest = "app_start_timeout"
        elif key == "checkInterval":
            suggest = "check_interval"
        elif key == "failureThreshold":
            suggest = "failure_threshold"
        elif key == "successThreshold":
            suggest = "success_threshold"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionReadinessCheck. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionReadinessCheck.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionReadinessCheck.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 path: _builtins.str,
                 app_start_timeout: Optional[_builtins.str] = None,
                 check_interval: Optional[_builtins.str] = None,
                 failure_threshold: Optional[_builtins.float] = None,
                 host: Optional[_builtins.str] = None,
                 success_threshold: Optional[_builtins.float] = None,
                 timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.str path: The request path.
        :param _builtins.str app_start_timeout: A maximum time limit on application initialization, measured from moment the application successfully
               replies to a healthcheck until it is ready to serve traffic. Default: "300s"
        :param _builtins.str check_interval: Interval between health checks.  Default: "5s".
        :param _builtins.float failure_threshold: Number of consecutive failed checks required before removing traffic. Default: 2.
        :param _builtins.str host: Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        :param _builtins.float success_threshold: Number of consecutive successful checks required before receiving traffic. Default: 2.
        :param _builtins.str timeout: Time before the check is considered failed. Default: "4s"
        """
        pulumi.set(__self__, "path", path)
        if app_start_timeout is not None:
            pulumi.set(__self__, "app_start_timeout", app_start_timeout)
        if check_interval is not None:
            pulumi.set(__self__, "check_interval", check_interval)
        if failure_threshold is not None:
            pulumi.set(__self__, "failure_threshold", failure_threshold)
        if host is not None:
            pulumi.set(__self__, "host", host)
        if success_threshold is not None:
            pulumi.set(__self__, "success_threshold", success_threshold)
        if timeout is not None:
            pulumi.set(__self__, "timeout", timeout)

    @_builtins.property
    @pulumi.getter
    def path(self) -> _builtins.str:
        """
        The request path.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="appStartTimeout")
    def app_start_timeout(self) -> Optional[_builtins.str]:
        """
        A maximum time limit on application initialization, measured from moment the application successfully
        replies to a healthcheck until it is ready to serve traffic. Default: "300s"
        """
        return pulumi.get(self, "app_start_timeout")

    @_builtins.property
    @pulumi.getter(name="checkInterval")
    def check_interval(self) -> Optional[_builtins.str]:
        """
        Interval between health checks.  Default: "5s".
        """
        return pulumi.get(self, "check_interval")

    @_builtins.property
    @pulumi.getter(name="failureThreshold")
    def failure_threshold(self) -> Optional[_builtins.float]:
        """
        Number of consecutive failed checks required before removing traffic. Default: 2.
        """
        return pulumi.get(self, "failure_threshold")

    @_builtins.property
    @pulumi.getter
    def host(self) -> Optional[_builtins.str]:
        """
        Host header to send when performing a HTTP Readiness check. Example: "myapp.appspot.com"
        """
        return pulumi.get(self, "host")

    @_builtins.property
    @pulumi.getter(name="successThreshold")
    def success_threshold(self) -> Optional[_builtins.float]:
        """
        Number of consecutive successful checks required before receiving traffic. Default: 2.
        """
        return pulumi.get(self, "success_threshold")

    @_builtins.property
    @pulumi.getter
    def timeout(self) -> Optional[_builtins.str]:
        """
        Time before the check is considered failed. Default: "4s"
        """
        return pulumi.get(self, "timeout")


@pulumi.output_type
class FlexibleAppVersionResources(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskGb":
            suggest = "disk_gb"
        elif key == "memoryGb":
            suggest = "memory_gb"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionResources. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionResources.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionResources.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cpu: Optional[_builtins.int] = None,
                 disk_gb: Optional[_builtins.int] = None,
                 memory_gb: Optional[_builtins.float] = None,
                 volumes: Optional[Sequence['outputs.FlexibleAppVersionResourcesVolume']] = None):
        """
        :param _builtins.int cpu: Number of CPU cores needed.
        :param _builtins.int disk_gb: Disk size (GB) needed.
        :param _builtins.float memory_gb: Memory (GB) needed.
        :param Sequence['FlexibleAppVersionResourcesVolumeArgs'] volumes: List of ports, or port pairs, to forward from the virtual machine to the application container.
               Structure is documented below.
        """
        if cpu is not None:
            pulumi.set(__self__, "cpu", cpu)
        if disk_gb is not None:
            pulumi.set(__self__, "disk_gb", disk_gb)
        if memory_gb is not None:
            pulumi.set(__self__, "memory_gb", memory_gb)
        if volumes is not None:
            pulumi.set(__self__, "volumes", volumes)

    @_builtins.property
    @pulumi.getter
    def cpu(self) -> Optional[_builtins.int]:
        """
        Number of CPU cores needed.
        """
        return pulumi.get(self, "cpu")

    @_builtins.property
    @pulumi.getter(name="diskGb")
    def disk_gb(self) -> Optional[_builtins.int]:
        """
        Disk size (GB) needed.
        """
        return pulumi.get(self, "disk_gb")

    @_builtins.property
    @pulumi.getter(name="memoryGb")
    def memory_gb(self) -> Optional[_builtins.float]:
        """
        Memory (GB) needed.
        """
        return pulumi.get(self, "memory_gb")

    @_builtins.property
    @pulumi.getter
    def volumes(self) -> Optional[Sequence['outputs.FlexibleAppVersionResourcesVolume']]:
        """
        List of ports, or port pairs, to forward from the virtual machine to the application container.
        Structure is documented below.
        """
        return pulumi.get(self, "volumes")


@pulumi.output_type
class FlexibleAppVersionResourcesVolume(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sizeGb":
            suggest = "size_gb"
        elif key == "volumeType":
            suggest = "volume_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in FlexibleAppVersionResourcesVolume. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        FlexibleAppVersionResourcesVolume.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        FlexibleAppVersionResourcesVolume.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 size_gb: _builtins.int,
                 volume_type: _builtins.str):
        """
        :param _builtins.str name: Unique name for the volume.
        :param _builtins.int size_gb: Volume size in gigabytes.
        :param _builtins.str volume_type: Underlying volume type, e.g. 'tmpfs'.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "size_gb", size_gb)
        pulumi.set(__self__, "volume_type", volume_type)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Unique name for the volume.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sizeGb")
    def size_gb(self) -> _builtins.int:
        """
        Volume size in gigabytes.
        """
        return pulumi.get(self, "size_gb")

    @_builtins.property
    @pulumi.getter(name="volumeType")
    def volume_type(self) -> _builtins.str:
        """
        Underlying volume type, e.g. 'tmpfs'.
        """
        return pulumi.get(self, "volume_type")


@pulumi.output_type
class FlexibleAppVersionVpcAccessConnector(dict):
    def __init__(__self__, *,
                 name: _builtins.str):
        """
        :param _builtins.str name: Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        pulumi.set(__self__, "name", name)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        return pulumi.get(self, "name")


@pulumi.output_type
class ServiceNetworkSettingsNetworkSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "ingressTrafficAllowed":
            suggest = "ingress_traffic_allowed"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ServiceNetworkSettingsNetworkSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ServiceNetworkSettingsNetworkSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ServiceNetworkSettingsNetworkSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ingress_traffic_allowed: Optional[_builtins.str] = None):
        """
        :param _builtins.str ingress_traffic_allowed: The ingress settings for version or service.
               Default value is `INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED`.
               Possible values are: `INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED`, `INGRESS_TRAFFIC_ALLOWED_ALL`, `INGRESS_TRAFFIC_ALLOWED_INTERNAL_ONLY`, `INGRESS_TRAFFIC_ALLOWED_INTERNAL_AND_LB`.
        """
        if ingress_traffic_allowed is not None:
            pulumi.set(__self__, "ingress_traffic_allowed", ingress_traffic_allowed)

    @_builtins.property
    @pulumi.getter(name="ingressTrafficAllowed")
    def ingress_traffic_allowed(self) -> Optional[_builtins.str]:
        """
        The ingress settings for version or service.
        Default value is `INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED`.
        Possible values are: `INGRESS_TRAFFIC_ALLOWED_UNSPECIFIED`, `INGRESS_TRAFFIC_ALLOWED_ALL`, `INGRESS_TRAFFIC_ALLOWED_INTERNAL_ONLY`, `INGRESS_TRAFFIC_ALLOWED_INTERNAL_AND_LB`.
        """
        return pulumi.get(self, "ingress_traffic_allowed")


@pulumi.output_type
class StandardAppVersionAutomaticScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxConcurrentRequests":
            suggest = "max_concurrent_requests"
        elif key == "maxIdleInstances":
            suggest = "max_idle_instances"
        elif key == "maxPendingLatency":
            suggest = "max_pending_latency"
        elif key == "minIdleInstances":
            suggest = "min_idle_instances"
        elif key == "minPendingLatency":
            suggest = "min_pending_latency"
        elif key == "standardSchedulerSettings":
            suggest = "standard_scheduler_settings"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionAutomaticScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionAutomaticScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionAutomaticScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_concurrent_requests: Optional[_builtins.int] = None,
                 max_idle_instances: Optional[_builtins.int] = None,
                 max_pending_latency: Optional[_builtins.str] = None,
                 min_idle_instances: Optional[_builtins.int] = None,
                 min_pending_latency: Optional[_builtins.str] = None,
                 standard_scheduler_settings: Optional['outputs.StandardAppVersionAutomaticScalingStandardSchedulerSettings'] = None):
        """
        :param _builtins.int max_concurrent_requests: Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
               Defaults to a runtime-specific value.
        :param _builtins.int max_idle_instances: Maximum number of idle instances that should be maintained for this version.
        :param _builtins.str max_pending_latency: Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param _builtins.int min_idle_instances: Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        :param _builtins.str min_pending_latency: Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        :param 'StandardAppVersionAutomaticScalingStandardSchedulerSettingsArgs' standard_scheduler_settings: Scheduler settings for standard environment.
               Structure is documented below.
        """
        if max_concurrent_requests is not None:
            pulumi.set(__self__, "max_concurrent_requests", max_concurrent_requests)
        if max_idle_instances is not None:
            pulumi.set(__self__, "max_idle_instances", max_idle_instances)
        if max_pending_latency is not None:
            pulumi.set(__self__, "max_pending_latency", max_pending_latency)
        if min_idle_instances is not None:
            pulumi.set(__self__, "min_idle_instances", min_idle_instances)
        if min_pending_latency is not None:
            pulumi.set(__self__, "min_pending_latency", min_pending_latency)
        if standard_scheduler_settings is not None:
            pulumi.set(__self__, "standard_scheduler_settings", standard_scheduler_settings)

    @_builtins.property
    @pulumi.getter(name="maxConcurrentRequests")
    def max_concurrent_requests(self) -> Optional[_builtins.int]:
        """
        Number of concurrent requests an automatic scaling instance can accept before the scheduler spawns a new instance.
        Defaults to a runtime-specific value.
        """
        return pulumi.get(self, "max_concurrent_requests")

    @_builtins.property
    @pulumi.getter(name="maxIdleInstances")
    def max_idle_instances(self) -> Optional[_builtins.int]:
        """
        Maximum number of idle instances that should be maintained for this version.
        """
        return pulumi.get(self, "max_idle_instances")

    @_builtins.property
    @pulumi.getter(name="maxPendingLatency")
    def max_pending_latency(self) -> Optional[_builtins.str]:
        """
        Maximum amount of time that a request should wait in the pending queue before starting a new instance to handle it.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "max_pending_latency")

    @_builtins.property
    @pulumi.getter(name="minIdleInstances")
    def min_idle_instances(self) -> Optional[_builtins.int]:
        """
        Minimum number of idle instances that should be maintained for this version. Only applicable for the default version of a service.
        """
        return pulumi.get(self, "min_idle_instances")

    @_builtins.property
    @pulumi.getter(name="minPendingLatency")
    def min_pending_latency(self) -> Optional[_builtins.str]:
        """
        Minimum amount of time a request should wait in the pending queue before starting a new instance to handle it.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s".
        """
        return pulumi.get(self, "min_pending_latency")

    @_builtins.property
    @pulumi.getter(name="standardSchedulerSettings")
    def standard_scheduler_settings(self) -> Optional['outputs.StandardAppVersionAutomaticScalingStandardSchedulerSettings']:
        """
        Scheduler settings for standard environment.
        Structure is documented below.
        """
        return pulumi.get(self, "standard_scheduler_settings")


@pulumi.output_type
class StandardAppVersionAutomaticScalingStandardSchedulerSettings(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"
        elif key == "targetCpuUtilization":
            suggest = "target_cpu_utilization"
        elif key == "targetThroughputUtilization":
            suggest = "target_throughput_utilization"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionAutomaticScalingStandardSchedulerSettings. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionAutomaticScalingStandardSchedulerSettings.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionAutomaticScalingStandardSchedulerSettings.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instances: Optional[_builtins.int] = None,
                 min_instances: Optional[_builtins.int] = None,
                 target_cpu_utilization: Optional[_builtins.float] = None,
                 target_throughput_utilization: Optional[_builtins.float] = None):
        """
        :param _builtins.int max_instances: Maximum number of instances to run for this version. Set to zero to disable maxInstances configuration.
               **Note:** Starting from March 2025, App Engine sets the maxInstances default for standard environment deployments to 20. This change doesn't impact existing apps. To override the default, specify a new value between 0 and 2147483647, and deploy a new version or redeploy over an existing version. To disable the maxInstances default configuration setting, specify the maximum permitted value 2147483647.
        :param _builtins.int min_instances: Minimum number of instances to run for this version. Set to zero to disable minInstances configuration.
        :param _builtins.float target_cpu_utilization: Target CPU utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
        :param _builtins.float target_throughput_utilization: Target throughput utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
        """
        if max_instances is not None:
            pulumi.set(__self__, "max_instances", max_instances)
        if min_instances is not None:
            pulumi.set(__self__, "min_instances", min_instances)
        if target_cpu_utilization is not None:
            pulumi.set(__self__, "target_cpu_utilization", target_cpu_utilization)
        if target_throughput_utilization is not None:
            pulumi.set(__self__, "target_throughput_utilization", target_throughput_utilization)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> Optional[_builtins.int]:
        """
        Maximum number of instances to run for this version. Set to zero to disable maxInstances configuration.
        **Note:** Starting from March 2025, App Engine sets the maxInstances default for standard environment deployments to 20. This change doesn't impact existing apps. To override the default, specify a new value between 0 and 2147483647, and deploy a new version or redeploy over an existing version. To disable the maxInstances default configuration setting, specify the maximum permitted value 2147483647.
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> Optional[_builtins.int]:
        """
        Minimum number of instances to run for this version. Set to zero to disable minInstances configuration.
        """
        return pulumi.get(self, "min_instances")

    @_builtins.property
    @pulumi.getter(name="targetCpuUtilization")
    def target_cpu_utilization(self) -> Optional[_builtins.float]:
        """
        Target CPU utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
        """
        return pulumi.get(self, "target_cpu_utilization")

    @_builtins.property
    @pulumi.getter(name="targetThroughputUtilization")
    def target_throughput_utilization(self) -> Optional[_builtins.float]:
        """
        Target throughput utilization ratio to maintain when scaling. Should be a value in the range [0.50, 0.95], zero, or a negative value.
        """
        return pulumi.get(self, "target_throughput_utilization")


@pulumi.output_type
class StandardAppVersionBasicScaling(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstances":
            suggest = "max_instances"
        elif key == "idleTimeout":
            suggest = "idle_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionBasicScaling. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionBasicScaling.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionBasicScaling.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instances: _builtins.int,
                 idle_timeout: Optional[_builtins.str] = None):
        """
        :param _builtins.int max_instances: Maximum number of instances to create for this version. Must be in the range [1.0, 200.0].
        :param _builtins.str idle_timeout: Duration of time after the last request that an instance must wait before the instance is shut down.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        if idle_timeout is not None:
            pulumi.set(__self__, "idle_timeout", idle_timeout)

    @_builtins.property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> _builtins.int:
        """
        Maximum number of instances to create for this version. Must be in the range [1.0, 200.0].
        """
        return pulumi.get(self, "max_instances")

    @_builtins.property
    @pulumi.getter(name="idleTimeout")
    def idle_timeout(self) -> Optional[_builtins.str]:
        """
        Duration of time after the last request that an instance must wait before the instance is shut down.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example: "3.5s". Defaults to 900s.
        """
        return pulumi.get(self, "idle_timeout")


@pulumi.output_type
class StandardAppVersionDeployment(dict):
    def __init__(__self__, *,
                 files: Optional[Sequence['outputs.StandardAppVersionDeploymentFile']] = None,
                 zip: Optional['outputs.StandardAppVersionDeploymentZip'] = None):
        """
        :param Sequence['StandardAppVersionDeploymentFileArgs'] files: Manifest of the files stored in Google Cloud Storage that are included as part of this version.
               All files must be readable using the credentials supplied with this call.
               Structure is documented below.
        :param 'StandardAppVersionDeploymentZipArgs' zip: Zip File
               Structure is documented below.
        """
        if files is not None:
            pulumi.set(__self__, "files", files)
        if zip is not None:
            pulumi.set(__self__, "zip", zip)

    @_builtins.property
    @pulumi.getter
    def files(self) -> Optional[Sequence['outputs.StandardAppVersionDeploymentFile']]:
        """
        Manifest of the files stored in Google Cloud Storage that are included as part of this version.
        All files must be readable using the credentials supplied with this call.
        Structure is documented below.
        """
        return pulumi.get(self, "files")

    @_builtins.property
    @pulumi.getter
    def zip(self) -> Optional['outputs.StandardAppVersionDeploymentZip']:
        """
        Zip File
        Structure is documented below.
        """
        return pulumi.get(self, "zip")


@pulumi.output_type
class StandardAppVersionDeploymentFile(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceUrl":
            suggest = "source_url"
        elif key == "sha1Sum":
            suggest = "sha1_sum"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionDeploymentFile. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionDeploymentFile.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionDeploymentFile.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 source_url: _builtins.str,
                 sha1_sum: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: The identifier for this object. Format specified above.
        :param _builtins.str source_url: Source URL
        :param _builtins.str sha1_sum: SHA1 checksum of the file
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "source_url", source_url)
        if sha1_sum is not None:
            pulumi.set(__self__, "sha1_sum", sha1_sum)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        The identifier for this object. Format specified above.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> _builtins.str:
        """
        Source URL
        """
        return pulumi.get(self, "source_url")

    @_builtins.property
    @pulumi.getter(name="sha1Sum")
    def sha1_sum(self) -> Optional[_builtins.str]:
        """
        SHA1 checksum of the file
        """
        return pulumi.get(self, "sha1_sum")


@pulumi.output_type
class StandardAppVersionDeploymentZip(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "sourceUrl":
            suggest = "source_url"
        elif key == "filesCount":
            suggest = "files_count"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionDeploymentZip. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionDeploymentZip.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionDeploymentZip.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 source_url: _builtins.str,
                 files_count: Optional[_builtins.int] = None):
        """
        :param _builtins.str source_url: Source URL
        :param _builtins.int files_count: files count
        """
        pulumi.set(__self__, "source_url", source_url)
        if files_count is not None:
            pulumi.set(__self__, "files_count", files_count)

    @_builtins.property
    @pulumi.getter(name="sourceUrl")
    def source_url(self) -> _builtins.str:
        """
        Source URL
        """
        return pulumi.get(self, "source_url")

    @_builtins.property
    @pulumi.getter(name="filesCount")
    def files_count(self) -> Optional[_builtins.int]:
        """
        files count
        """
        return pulumi.get(self, "files_count")


@pulumi.output_type
class StandardAppVersionEntrypoint(dict):
    def __init__(__self__, *,
                 shell: _builtins.str):
        """
        :param _builtins.str shell: The format should be a shell command that can be fed to bash -c.
        """
        pulumi.set(__self__, "shell", shell)

    @_builtins.property
    @pulumi.getter
    def shell(self) -> _builtins.str:
        """
        The format should be a shell command that can be fed to bash -c.
        """
        return pulumi.get(self, "shell")


@pulumi.output_type
class StandardAppVersionHandler(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "authFailAction":
            suggest = "auth_fail_action"
        elif key == "redirectHttpResponseCode":
            suggest = "redirect_http_response_code"
        elif key == "securityLevel":
            suggest = "security_level"
        elif key == "staticFiles":
            suggest = "static_files"
        elif key == "urlRegex":
            suggest = "url_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionHandler. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionHandler.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionHandler.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auth_fail_action: Optional[_builtins.str] = None,
                 login: Optional[_builtins.str] = None,
                 redirect_http_response_code: Optional[_builtins.str] = None,
                 script: Optional['outputs.StandardAppVersionHandlerScript'] = None,
                 security_level: Optional[_builtins.str] = None,
                 static_files: Optional['outputs.StandardAppVersionHandlerStaticFiles'] = None,
                 url_regex: Optional[_builtins.str] = None):
        """
        :param _builtins.str auth_fail_action: Actions to take when the user is not logged in.
               Possible values are: `AUTH_FAIL_ACTION_REDIRECT`, `AUTH_FAIL_ACTION_UNAUTHORIZED`.
        :param _builtins.str login: Methods to restrict access to a URL based on login status.
               Possible values are: `LOGIN_OPTIONAL`, `LOGIN_ADMIN`, `LOGIN_REQUIRED`.
        :param _builtins.str redirect_http_response_code: 30x code to use when performing redirects for the secure field.
               Possible values are: `REDIRECT_HTTP_RESPONSE_CODE_301`, `REDIRECT_HTTP_RESPONSE_CODE_302`, `REDIRECT_HTTP_RESPONSE_CODE_303`, `REDIRECT_HTTP_RESPONSE_CODE_307`.
        :param 'StandardAppVersionHandlerScriptArgs' script: Executes a script to handle the requests that match this URL pattern.
               Only the auto value is supported for Node.js in the App Engine standard environment, for example "script:" "auto".
               Structure is documented below.
        :param _builtins.str security_level: Security (HTTPS) enforcement for this URL.
               Possible values are: `SECURE_DEFAULT`, `SECURE_NEVER`, `SECURE_OPTIONAL`, `SECURE_ALWAYS`.
        :param 'StandardAppVersionHandlerStaticFilesArgs' static_files: Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files. Static file handlers describe which files in the application directory are static files, and which URLs serve them.
               Structure is documented below.
        :param _builtins.str url_regex: URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
               All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        if auth_fail_action is not None:
            pulumi.set(__self__, "auth_fail_action", auth_fail_action)
        if login is not None:
            pulumi.set(__self__, "login", login)
        if redirect_http_response_code is not None:
            pulumi.set(__self__, "redirect_http_response_code", redirect_http_response_code)
        if script is not None:
            pulumi.set(__self__, "script", script)
        if security_level is not None:
            pulumi.set(__self__, "security_level", security_level)
        if static_files is not None:
            pulumi.set(__self__, "static_files", static_files)
        if url_regex is not None:
            pulumi.set(__self__, "url_regex", url_regex)

    @_builtins.property
    @pulumi.getter(name="authFailAction")
    def auth_fail_action(self) -> Optional[_builtins.str]:
        """
        Actions to take when the user is not logged in.
        Possible values are: `AUTH_FAIL_ACTION_REDIRECT`, `AUTH_FAIL_ACTION_UNAUTHORIZED`.
        """
        return pulumi.get(self, "auth_fail_action")

    @_builtins.property
    @pulumi.getter
    def login(self) -> Optional[_builtins.str]:
        """
        Methods to restrict access to a URL based on login status.
        Possible values are: `LOGIN_OPTIONAL`, `LOGIN_ADMIN`, `LOGIN_REQUIRED`.
        """
        return pulumi.get(self, "login")

    @_builtins.property
    @pulumi.getter(name="redirectHttpResponseCode")
    def redirect_http_response_code(self) -> Optional[_builtins.str]:
        """
        30x code to use when performing redirects for the secure field.
        Possible values are: `REDIRECT_HTTP_RESPONSE_CODE_301`, `REDIRECT_HTTP_RESPONSE_CODE_302`, `REDIRECT_HTTP_RESPONSE_CODE_303`, `REDIRECT_HTTP_RESPONSE_CODE_307`.
        """
        return pulumi.get(self, "redirect_http_response_code")

    @_builtins.property
    @pulumi.getter
    def script(self) -> Optional['outputs.StandardAppVersionHandlerScript']:
        """
        Executes a script to handle the requests that match this URL pattern.
        Only the auto value is supported for Node.js in the App Engine standard environment, for example "script:" "auto".
        Structure is documented below.
        """
        return pulumi.get(self, "script")

    @_builtins.property
    @pulumi.getter(name="securityLevel")
    def security_level(self) -> Optional[_builtins.str]:
        """
        Security (HTTPS) enforcement for this URL.
        Possible values are: `SECURE_DEFAULT`, `SECURE_NEVER`, `SECURE_OPTIONAL`, `SECURE_ALWAYS`.
        """
        return pulumi.get(self, "security_level")

    @_builtins.property
    @pulumi.getter(name="staticFiles")
    def static_files(self) -> Optional['outputs.StandardAppVersionHandlerStaticFiles']:
        """
        Files served directly to the user for a given URL, such as images, CSS stylesheets, or JavaScript source files. Static file handlers describe which files in the application directory are static files, and which URLs serve them.
        Structure is documented below.
        """
        return pulumi.get(self, "static_files")

    @_builtins.property
    @pulumi.getter(name="urlRegex")
    def url_regex(self) -> Optional[_builtins.str]:
        """
        URL prefix. Uses regular expression syntax, which means regexp special characters must be escaped, but should not contain groupings.
        All URLs that begin with this prefix are handled by this handler, using the portion of the URL after the prefix as part of the file path.
        """
        return pulumi.get(self, "url_regex")


@pulumi.output_type
class StandardAppVersionHandlerScript(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "scriptPath":
            suggest = "script_path"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionHandlerScript. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionHandlerScript.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionHandlerScript.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 script_path: _builtins.str):
        """
        :param _builtins.str script_path: Path to the script from the application root directory.
        """
        pulumi.set(__self__, "script_path", script_path)

    @_builtins.property
    @pulumi.getter(name="scriptPath")
    def script_path(self) -> _builtins.str:
        """
        Path to the script from the application root directory.
        """
        return pulumi.get(self, "script_path")


@pulumi.output_type
class StandardAppVersionHandlerStaticFiles(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "applicationReadable":
            suggest = "application_readable"
        elif key == "httpHeaders":
            suggest = "http_headers"
        elif key == "mimeType":
            suggest = "mime_type"
        elif key == "requireMatchingFile":
            suggest = "require_matching_file"
        elif key == "uploadPathRegex":
            suggest = "upload_path_regex"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionHandlerStaticFiles. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionHandlerStaticFiles.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionHandlerStaticFiles.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 application_readable: Optional[_builtins.bool] = None,
                 expiration: Optional[_builtins.str] = None,
                 http_headers: Optional[Mapping[str, _builtins.str]] = None,
                 mime_type: Optional[_builtins.str] = None,
                 path: Optional[_builtins.str] = None,
                 require_matching_file: Optional[_builtins.bool] = None,
                 upload_path_regex: Optional[_builtins.str] = None):
        """
        :param _builtins.bool application_readable: Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as
               static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged
               against both your code and static data storage resource quotas.
        :param _builtins.str expiration: Time a static file served by this handler should be cached by web proxies and browsers.
               A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
        :param Mapping[str, _builtins.str] http_headers: HTTP headers to use for all responses from these URLs.
               An object containing a list of "key:value" value pairs.".
        :param _builtins.str mime_type: MIME type used to serve all files served by this handler.
               Defaults to file-specific MIME types, which are derived from each file's filename extension.
        :param _builtins.str path: Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        :param _builtins.bool require_matching_file: Whether this handler should match the request if the file referenced by the handler does not exist.
        :param _builtins.str upload_path_regex: Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        if application_readable is not None:
            pulumi.set(__self__, "application_readable", application_readable)
        if expiration is not None:
            pulumi.set(__self__, "expiration", expiration)
        if http_headers is not None:
            pulumi.set(__self__, "http_headers", http_headers)
        if mime_type is not None:
            pulumi.set(__self__, "mime_type", mime_type)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if require_matching_file is not None:
            pulumi.set(__self__, "require_matching_file", require_matching_file)
        if upload_path_regex is not None:
            pulumi.set(__self__, "upload_path_regex", upload_path_regex)

    @_builtins.property
    @pulumi.getter(name="applicationReadable")
    def application_readable(self) -> Optional[_builtins.bool]:
        """
        Whether files should also be uploaded as code data. By default, files declared in static file handlers are uploaded as
        static data and are only served to end users; they cannot be read by the application. If enabled, uploads are charged
        against both your code and static data storage resource quotas.
        """
        return pulumi.get(self, "application_readable")

    @_builtins.property
    @pulumi.getter
    def expiration(self) -> Optional[_builtins.str]:
        """
        Time a static file served by this handler should be cached by web proxies and browsers.
        A duration in seconds with up to nine fractional digits, terminated by 's'. Example "3.5s".
        """
        return pulumi.get(self, "expiration")

    @_builtins.property
    @pulumi.getter(name="httpHeaders")
    def http_headers(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        HTTP headers to use for all responses from these URLs.
        An object containing a list of "key:value" value pairs.".
        """
        return pulumi.get(self, "http_headers")

    @_builtins.property
    @pulumi.getter(name="mimeType")
    def mime_type(self) -> Optional[_builtins.str]:
        """
        MIME type used to serve all files served by this handler.
        Defaults to file-specific MIME types, which are derived from each file's filename extension.
        """
        return pulumi.get(self, "mime_type")

    @_builtins.property
    @pulumi.getter
    def path(self) -> Optional[_builtins.str]:
        """
        Path to the static files matched by the URL pattern, from the application root directory. The path can refer to text matched in groupings in the URL pattern.
        """
        return pulumi.get(self, "path")

    @_builtins.property
    @pulumi.getter(name="requireMatchingFile")
    def require_matching_file(self) -> Optional[_builtins.bool]:
        """
        Whether this handler should match the request if the file referenced by the handler does not exist.
        """
        return pulumi.get(self, "require_matching_file")

    @_builtins.property
    @pulumi.getter(name="uploadPathRegex")
    def upload_path_regex(self) -> Optional[_builtins.str]:
        """
        Regular expression that matches the file paths for all files that should be referenced by this handler.
        """
        return pulumi.get(self, "upload_path_regex")


@pulumi.output_type
class StandardAppVersionLibrary(dict):
    def __init__(__self__, *,
                 name: Optional[_builtins.str] = None,
                 version: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Name of the library. Example "django".
        :param _builtins.str version: Version of the library to select, or "latest".
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[_builtins.str]:
        """
        Name of the library. Example "django".
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def version(self) -> Optional[_builtins.str]:
        """
        Version of the library to select, or "latest".
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class StandardAppVersionManualScaling(dict):
    def __init__(__self__, *,
                 instances: _builtins.int):
        """
        :param _builtins.int instances: Number of instances to assign to the service at the start.
               **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
               Modules API set_num_instances() you must use `lifecycle.ignore_changes = ["manual_scaling"[0].instances]` to prevent drift detection.
        """
        pulumi.set(__self__, "instances", instances)

    @_builtins.property
    @pulumi.getter
    def instances(self) -> _builtins.int:
        """
        Number of instances to assign to the service at the start.
        **Note:** When managing the number of instances at runtime through the App Engine Admin API or the (now deprecated) Python 2
        Modules API set_num_instances() you must use `lifecycle.ignore_changes = ["manual_scaling"[0].instances]` to prevent drift detection.
        """
        return pulumi.get(self, "instances")


@pulumi.output_type
class StandardAppVersionVpcAccessConnector(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "egressSetting":
            suggest = "egress_setting"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StandardAppVersionVpcAccessConnector. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StandardAppVersionVpcAccessConnector.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StandardAppVersionVpcAccessConnector.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: _builtins.str,
                 egress_setting: Optional[_builtins.str] = None):
        """
        :param _builtins.str name: Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        :param _builtins.str egress_setting: The egress setting for the connector, controlling what traffic is diverted through it.
        """
        pulumi.set(__self__, "name", name)
        if egress_setting is not None:
            pulumi.set(__self__, "egress_setting", egress_setting)

    @_builtins.property
    @pulumi.getter
    def name(self) -> _builtins.str:
        """
        Full Serverless VPC Access Connector name e.g. /projects/my-project/locations/us-central1/connectors/c1.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter(name="egressSetting")
    def egress_setting(self) -> Optional[_builtins.str]:
        """
        The egress setting for the connector, controlling what traffic is diverted through it.
        """
        return pulumi.get(self, "egress_setting")


