# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'GetRepositoriesResult',
    'AwaitableGetRepositoriesResult',
    'get_repositories',
    'get_repositories_output',
]

@pulumi.output_type
class GetRepositoriesResult:
    """
    A collection of values returned by getRepositories.
    """
    def __init__(__self__, id=None, location=None, name_filter=None, project=None, repositories=None):
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if location and not isinstance(location, str):
            raise TypeError("Expected argument 'location' to be a str")
        pulumi.set(__self__, "location", location)
        if name_filter and not isinstance(name_filter, str):
            raise TypeError("Expected argument 'name_filter' to be a str")
        pulumi.set(__self__, "name_filter", name_filter)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if repositories and not isinstance(repositories, list):
            raise TypeError("Expected argument 'repositories' to be a list")
        pulumi.set(__self__, "repositories", repositories)

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def location(self) -> _builtins.str:
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter(name="nameFilter")
    def name_filter(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "name_filter")

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[_builtins.str]:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def repositories(self) -> Sequence['outputs.GetRepositoriesRepositoryResult']:
        """
        A list of all retrieved Artifact Registry repositories. Structure is defined below.
        """
        return pulumi.get(self, "repositories")


class AwaitableGetRepositoriesResult(GetRepositoriesResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetRepositoriesResult(
            id=self.id,
            location=self.location,
            name_filter=self.name_filter,
            project=self.project,
            repositories=self.repositories)


def get_repositories(location: Optional[_builtins.str] = None,
                     name_filter: Optional[_builtins.str] = None,
                     project: Optional[_builtins.str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetRepositoriesResult:
    """
    Get information about Artifact Registry repositories.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories/list).

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.artifactregistry.get_repositories(location="us-central1",
        project="my-project")
    ```


    :param _builtins.str location: The location of the artifact registry repositories. eg `us-central1`.
    :param _builtins.str name_filter: Optional. An expression for filtering the results by name. You can also use wildcards `*`. I.e. `my-repo`, `*-repo`, `my-*`, `*-re*`. For further information reach out to the [API docs](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories/list).
    :param _builtins.str project: The ID of the project. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['nameFilter'] = name_filter
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:artifactregistry/getRepositories:getRepositories', __args__, opts=opts, typ=GetRepositoriesResult).value

    return AwaitableGetRepositoriesResult(
        id=pulumi.get(__ret__, 'id'),
        location=pulumi.get(__ret__, 'location'),
        name_filter=pulumi.get(__ret__, 'name_filter'),
        project=pulumi.get(__ret__, 'project'),
        repositories=pulumi.get(__ret__, 'repositories'))
def get_repositories_output(location: Optional[pulumi.Input[_builtins.str]] = None,
                            name_filter: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                            opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetRepositoriesResult]:
    """
    Get information about Artifact Registry repositories.
    See [the official documentation](https://cloud.google.com/artifact-registry/docs)
    and [API](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories/list).

    ```python
    import pulumi
    import pulumi_gcp as gcp

    example = gcp.artifactregistry.get_repositories(location="us-central1",
        project="my-project")
    ```


    :param _builtins.str location: The location of the artifact registry repositories. eg `us-central1`.
    :param _builtins.str name_filter: Optional. An expression for filtering the results by name. You can also use wildcards `*`. I.e. `my-repo`, `*-repo`, `my-*`, `*-re*`. For further information reach out to the [API docs](https://cloud.google.com/artifact-registry/docs/reference/rest/v1/projects.locations.repositories/list).
    :param _builtins.str project: The ID of the project. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['location'] = location
    __args__['nameFilter'] = name_filter
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:artifactregistry/getRepositories:getRepositories', __args__, opts=opts, typ=GetRepositoriesResult)
    return __ret__.apply(lambda __response__: GetRepositoriesResult(
        id=pulumi.get(__response__, 'id'),
        location=pulumi.get(__response__, 'location'),
        name_filter=pulumi.get(__response__, 'name_filter'),
        project=pulumi.get(__response__, 'project'),
        repositories=pulumi.get(__response__, 'repositories')))
