# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = ['BackupVaultArgs', 'BackupVault']

@pulumi.input_type
class BackupVaultArgs:
    def __init__(__self__, *,
                 backup_minimum_enforced_retention_duration: pulumi.Input[_builtins.str],
                 backup_vault_id: pulumi.Input[_builtins.str],
                 location: pulumi.Input[_builtins.str],
                 access_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_missing: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backup_retention_inheritance: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_backup_plan_references: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_inactive_datasources: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a BackupVault resource.
        :param pulumi.Input[_builtins.str] backup_minimum_enforced_retention_duration: Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        :param pulumi.Input[_builtins.str] backup_vault_id: Required. ID of the requesting object.
        :param pulumi.Input[_builtins.str] location: The GCP location for the backup vault.
        :param pulumi.Input[_builtins.str] access_restriction: Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
               Default value is `WITHIN_ORGANIZATION`.
               Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        :param pulumi.Input[_builtins.bool] allow_missing: Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. See https://google.aip.dev/128#annotations
               Stores small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backup_retention_inheritance: How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
               Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        :param pulumi.Input[_builtins.str] description: Optional. The description of the BackupVault instance (2048 characters or less).
        :param pulumi.Input[_builtins.str] effective_time: Optional. Time after which the BackupVault resource is locked.
        :param pulumi.Input[_builtins.bool] force_delete: (Optional, Deprecated)
               If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
               * deletion of a backup vault instance that is being referenced by an active backup plan.
               
               > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        :param pulumi.Input[_builtins.bool] force_update: If set, allow update to extend the minimum enforced retention for backup vault. This overrides
               the restriction against conflicting retention periods. This conflict may occur when the
               expiration schedule defined by the associated backup plan is shorter than the minimum
               retention set by the backup vault.
        :param pulumi.Input[_builtins.bool] ignore_backup_plan_references: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance that is being referenced by an active backup plan.
        :param pulumi.Input[_builtins.bool] ignore_inactive_datasources: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        pulumi.set(__self__, "backup_minimum_enforced_retention_duration", backup_minimum_enforced_retention_duration)
        pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        pulumi.set(__self__, "location", location)
        if access_restriction is not None:
            pulumi.set(__self__, "access_restriction", access_restriction)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if backup_retention_inheritance is not None:
            pulumi.set(__self__, "backup_retention_inheritance", backup_retention_inheritance)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if force_delete is not None:
            warnings.warn("""`force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""", DeprecationWarning)
            pulumi.log.warn("""force_delete is deprecated: `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""")
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if ignore_backup_plan_references is not None:
            pulumi.set(__self__, "ignore_backup_plan_references", ignore_backup_plan_references)
        if ignore_inactive_datasources is not None:
            pulumi.set(__self__, "ignore_inactive_datasources", ignore_inactive_datasources)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if project is not None:
            pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDuration")
    def backup_minimum_enforced_retention_duration(self) -> pulumi.Input[_builtins.str]:
        """
        Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        """
        return pulumi.get(self, "backup_minimum_enforced_retention_duration")

    @backup_minimum_enforced_retention_duration.setter
    def backup_minimum_enforced_retention_duration(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_minimum_enforced_retention_duration", value)

    @_builtins.property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> pulumi.Input[_builtins.str]:
        """
        Required. ID of the requesting object.
        """
        return pulumi.get(self, "backup_vault_id")

    @backup_vault_id.setter
    def backup_vault_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "backup_vault_id", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The GCP location for the backup vault.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="accessRestriction")
    def access_restriction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
        Default value is `WITHIN_ORGANIZATION`.
        Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        """
        return pulumi.get(self, "access_restriction")

    @access_restriction.setter
    def access_restriction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_restriction", value)

    @_builtins.property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        """
        return pulumi.get(self, "allow_missing")

    @allow_missing.setter
    def allow_missing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_missing", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User annotations. See https://google.aip.dev/128#annotations
        Stores small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionInheritance")
    def backup_retention_inheritance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
        Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        """
        return pulumi.get(self, "backup_retention_inheritance")

    @backup_retention_inheritance.setter
    def backup_retention_inheritance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_retention_inheritance", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The description of the BackupVault instance (2048 characters or less).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Time after which the BackupVault resource is locked.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    @_utilities.deprecated("""`force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional, Deprecated)
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        * deletion of a backup vault instance that is being referenced by an active backup plan.

        > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, allow update to extend the minimum enforced retention for backup vault. This overrides
        the restriction against conflicting retention periods. This conflict may occur when the
        expiration schedule defined by the associated backup plan is shorter than the minimum
        retention set by the backup vault.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="ignoreBackupPlanReferences")
    def ignore_backup_plan_references(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance that is being referenced by an active backup plan.
        """
        return pulumi.get(self, "ignore_backup_plan_references")

    @ignore_backup_plan_references.setter
    def ignore_backup_plan_references(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_backup_plan_references", value)

    @_builtins.property
    @pulumi.getter(name="ignoreInactiveDatasources")
    def ignore_inactive_datasources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        """
        return pulumi.get(self, "ignore_inactive_datasources")

    @ignore_inactive_datasources.setter
    def ignore_inactive_datasources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_inactive_datasources", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)


@pulumi.input_type
class _BackupVaultState:
    def __init__(__self__, *,
                 access_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_missing: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backup_count: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_minimum_enforced_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_inheritance: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 deletable: Optional[pulumi.Input[_builtins.bool]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 etag: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_backup_plan_references: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_inactive_datasources: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 service_account: Optional[pulumi.Input[_builtins.str]] = None,
                 state: Optional[pulumi.Input[_builtins.str]] = None,
                 total_stored_bytes: Optional[pulumi.Input[_builtins.str]] = None,
                 uid: Optional[pulumi.Input[_builtins.str]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering BackupVault resources.
        :param pulumi.Input[_builtins.str] access_restriction: Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
               Default value is `WITHIN_ORGANIZATION`.
               Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        :param pulumi.Input[_builtins.bool] allow_missing: Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. See https://google.aip.dev/128#annotations
               Stores small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backup_count: Output only. The number of backups in this backup vault.
        :param pulumi.Input[_builtins.str] backup_minimum_enforced_retention_duration: Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        :param pulumi.Input[_builtins.str] backup_retention_inheritance: How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
               Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        :param pulumi.Input[_builtins.str] backup_vault_id: Required. ID of the requesting object.
        :param pulumi.Input[_builtins.str] create_time: Output only. The time when the instance was created.
        :param pulumi.Input[_builtins.bool] deletable: Output only. Set to true when there are no backups nested under this resource.
        :param pulumi.Input[_builtins.str] description: Optional. The description of the BackupVault instance (2048 characters or less).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] effective_time: Optional. Time after which the BackupVault resource is locked.
        :param pulumi.Input[_builtins.str] etag: Optional. Server specified ETag for the backup vault resource to prevent simultaneous updates from overwiting each other.
        :param pulumi.Input[_builtins.bool] force_delete: (Optional, Deprecated)
               If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
               * deletion of a backup vault instance that is being referenced by an active backup plan.
               
               > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        :param pulumi.Input[_builtins.bool] force_update: If set, allow update to extend the minimum enforced retention for backup vault. This overrides
               the restriction against conflicting retention periods. This conflict may occur when the
               expiration schedule defined by the associated backup plan is shorter than the minimum
               retention set by the backup vault.
        :param pulumi.Input[_builtins.bool] ignore_backup_plan_references: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance that is being referenced by an active backup plan.
        :param pulumi.Input[_builtins.bool] ignore_inactive_datasources: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The GCP location for the backup vault.
        :param pulumi.Input[_builtins.str] name: Output only. Identifier. The resource name.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: Output only. Service account used by the BackupVault Service for this BackupVault.  The user should grant this account permissions in their workload project to enable the service to run backups and restores there.
        :param pulumi.Input[_builtins.str] state: Output only. The BackupVault resource instance state.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               DELETING
               ERROR
        :param pulumi.Input[_builtins.str] total_stored_bytes: Output only. Total size of the storage used by all backup resources.
        :param pulumi.Input[_builtins.str] uid: Output only. Output only Immutable after resource creation until resource deletion.
        :param pulumi.Input[_builtins.str] update_time: Output only. The time when the instance was updated.
        """
        if access_restriction is not None:
            pulumi.set(__self__, "access_restriction", access_restriction)
        if allow_missing is not None:
            pulumi.set(__self__, "allow_missing", allow_missing)
        if annotations is not None:
            pulumi.set(__self__, "annotations", annotations)
        if backup_count is not None:
            pulumi.set(__self__, "backup_count", backup_count)
        if backup_minimum_enforced_retention_duration is not None:
            pulumi.set(__self__, "backup_minimum_enforced_retention_duration", backup_minimum_enforced_retention_duration)
        if backup_retention_inheritance is not None:
            pulumi.set(__self__, "backup_retention_inheritance", backup_retention_inheritance)
        if backup_vault_id is not None:
            pulumi.set(__self__, "backup_vault_id", backup_vault_id)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if deletable is not None:
            pulumi.set(__self__, "deletable", deletable)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_annotations is not None:
            pulumi.set(__self__, "effective_annotations", effective_annotations)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if effective_time is not None:
            pulumi.set(__self__, "effective_time", effective_time)
        if etag is not None:
            pulumi.set(__self__, "etag", etag)
        if force_delete is not None:
            warnings.warn("""`force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""", DeprecationWarning)
            pulumi.log.warn("""force_delete is deprecated: `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""")
        if force_delete is not None:
            pulumi.set(__self__, "force_delete", force_delete)
        if force_update is not None:
            pulumi.set(__self__, "force_update", force_update)
        if ignore_backup_plan_references is not None:
            pulumi.set(__self__, "ignore_backup_plan_references", ignore_backup_plan_references)
        if ignore_inactive_datasources is not None:
            pulumi.set(__self__, "ignore_inactive_datasources", ignore_inactive_datasources)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if service_account is not None:
            pulumi.set(__self__, "service_account", service_account)
        if state is not None:
            pulumi.set(__self__, "state", state)
        if total_stored_bytes is not None:
            pulumi.set(__self__, "total_stored_bytes", total_stored_bytes)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="accessRestriction")
    def access_restriction(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
        Default value is `WITHIN_ORGANIZATION`.
        Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        """
        return pulumi.get(self, "access_restriction")

    @access_restriction.setter
    def access_restriction(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "access_restriction", value)

    @_builtins.property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        """
        return pulumi.get(self, "allow_missing")

    @allow_missing.setter
    def allow_missing(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "allow_missing", value)

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. User annotations. See https://google.aip.dev/128#annotations
        Stores small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @annotations.setter
    def annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "annotations", value)

    @_builtins.property
    @pulumi.getter(name="backupCount")
    def backup_count(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The number of backups in this backup vault.
        """
        return pulumi.get(self, "backup_count")

    @backup_count.setter
    def backup_count(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_count", value)

    @_builtins.property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDuration")
    def backup_minimum_enforced_retention_duration(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        """
        return pulumi.get(self, "backup_minimum_enforced_retention_duration")

    @backup_minimum_enforced_retention_duration.setter
    def backup_minimum_enforced_retention_duration(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_minimum_enforced_retention_duration", value)

    @_builtins.property
    @pulumi.getter(name="backupRetentionInheritance")
    def backup_retention_inheritance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
        Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        """
        return pulumi.get(self, "backup_retention_inheritance")

    @backup_retention_inheritance.setter
    def backup_retention_inheritance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_retention_inheritance", value)

    @_builtins.property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Required. ID of the requesting object.
        """
        return pulumi.get(self, "backup_vault_id")

    @backup_vault_id.setter
    def backup_vault_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "backup_vault_id", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def deletable(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Output only. Set to true when there are no backups nested under this resource.
        """
        return pulumi.get(self, "deletable")

    @deletable.setter
    def deletable(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "deletable", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. The description of the BackupVault instance (2048 characters or less).
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        return pulumi.get(self, "effective_annotations")

    @effective_annotations.setter
    def effective_annotations(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_annotations", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Time after which the BackupVault resource is locked.
        """
        return pulumi.get(self, "effective_time")

    @effective_time.setter
    def effective_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "effective_time", value)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Optional. Server specified ETag for the backup vault resource to prevent simultaneous updates from overwiting each other.
        """
        return pulumi.get(self, "etag")

    @etag.setter
    def etag(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "etag", value)

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    @_utilities.deprecated("""`force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""")
    def force_delete(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        (Optional, Deprecated)
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        * deletion of a backup vault instance that is being referenced by an active backup plan.

        > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        """
        return pulumi.get(self, "force_delete")

    @force_delete.setter
    def force_delete(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_delete", value)

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, allow update to extend the minimum enforced retention for backup vault. This overrides
        the restriction against conflicting retention periods. This conflict may occur when the
        expiration schedule defined by the associated backup plan is shorter than the minimum
        retention set by the backup vault.
        """
        return pulumi.get(self, "force_update")

    @force_update.setter
    def force_update(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "force_update", value)

    @_builtins.property
    @pulumi.getter(name="ignoreBackupPlanReferences")
    def ignore_backup_plan_references(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance that is being referenced by an active backup plan.
        """
        return pulumi.get(self, "ignore_backup_plan_references")

    @ignore_backup_plan_references.setter
    def ignore_backup_plan_references(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_backup_plan_references", value)

    @_builtins.property
    @pulumi.getter(name="ignoreInactiveDatasources")
    def ignore_inactive_datasources(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        """
        return pulumi.get(self, "ignore_inactive_datasources")

    @ignore_inactive_datasources.setter
    def ignore_inactive_datasources(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_inactive_datasources", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Optional. Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The GCP location for the backup vault.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Identifier. The resource name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Service account used by the BackupVault Service for this BackupVault.  The user should grant this account permissions in their workload project to enable the service to run backups and restores there.
        """
        return pulumi.get(self, "service_account")

    @service_account.setter
    def service_account(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "service_account", value)

    @_builtins.property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The BackupVault resource instance state.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        DELETING
        ERROR
        """
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "state", value)

    @_builtins.property
    @pulumi.getter(name="totalStoredBytes")
    def total_stored_bytes(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Total size of the storage used by all backup resources.
        """
        return pulumi.get(self, "total_stored_bytes")

    @total_stored_bytes.setter
    def total_stored_bytes(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "total_stored_bytes", value)

    @_builtins.property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. Output only Immutable after resource creation until resource deletion.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "uid", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Output only. The time when the instance was updated.
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:backupdisasterrecovery/backupVault:BackupVault")
class BackupVault(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_missing: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backup_minimum_enforced_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_inheritance: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_backup_plan_references: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_inactive_datasources: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        Container to store and organize immutable and indelible backups.

        ## Example Usage

        ### Backup Dr Backup Vault Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        backup_vault_test = gcp.backupdisasterrecovery.BackupVault("backup-vault-test",
            location="us-central1",
            backup_vault_id="backup-vault-test",
            description="This is a second backup vault built by Terraform.",
            backup_minimum_enforced_retention_duration="100000s",
            annotations={
                "annotations1": "bar1",
                "annotations2": "baz1",
            },
            labels={
                "foo": "bar1",
                "bar": "baz1",
            },
            force_update=True,
            access_restriction="WITHIN_ORGANIZATION",
            backup_retention_inheritance="INHERIT_VAULT_RETENTION",
            ignore_inactive_datasources=True,
            ignore_backup_plan_references=True,
            allow_missing=True)
        ```

        ## Import

        BackupVault can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupVaults/{{backup_vault_id}}`

        * `{{project}}/{{location}}/{{backup_vault_id}}`

        * `{{location}}/{{backup_vault_id}}`

        When using the `pulumi import` command, BackupVault can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupVault:BackupVault default projects/{{project}}/locations/{{location}}/backupVaults/{{backup_vault_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupVault:BackupVault default {{project}}/{{location}}/{{backup_vault_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupVault:BackupVault default {{location}}/{{backup_vault_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_restriction: Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
               Default value is `WITHIN_ORGANIZATION`.
               Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        :param pulumi.Input[_builtins.bool] allow_missing: Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. See https://google.aip.dev/128#annotations
               Stores small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backup_minimum_enforced_retention_duration: Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        :param pulumi.Input[_builtins.str] backup_retention_inheritance: How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
               Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        :param pulumi.Input[_builtins.str] backup_vault_id: Required. ID of the requesting object.
        :param pulumi.Input[_builtins.str] description: Optional. The description of the BackupVault instance (2048 characters or less).
        :param pulumi.Input[_builtins.str] effective_time: Optional. Time after which the BackupVault resource is locked.
        :param pulumi.Input[_builtins.bool] force_delete: (Optional, Deprecated)
               If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
               * deletion of a backup vault instance that is being referenced by an active backup plan.
               
               > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        :param pulumi.Input[_builtins.bool] force_update: If set, allow update to extend the minimum enforced retention for backup vault. This overrides
               the restriction against conflicting retention periods. This conflict may occur when the
               expiration schedule defined by the associated backup plan is shorter than the minimum
               retention set by the backup vault.
        :param pulumi.Input[_builtins.bool] ignore_backup_plan_references: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance that is being referenced by an active backup plan.
        :param pulumi.Input[_builtins.bool] ignore_inactive_datasources: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The GCP location for the backup vault.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: BackupVaultArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Container to store and organize immutable and indelible backups.

        ## Example Usage

        ### Backup Dr Backup Vault Full

        ```python
        import pulumi
        import pulumi_gcp as gcp

        backup_vault_test = gcp.backupdisasterrecovery.BackupVault("backup-vault-test",
            location="us-central1",
            backup_vault_id="backup-vault-test",
            description="This is a second backup vault built by Terraform.",
            backup_minimum_enforced_retention_duration="100000s",
            annotations={
                "annotations1": "bar1",
                "annotations2": "baz1",
            },
            labels={
                "foo": "bar1",
                "bar": "baz1",
            },
            force_update=True,
            access_restriction="WITHIN_ORGANIZATION",
            backup_retention_inheritance="INHERIT_VAULT_RETENTION",
            ignore_inactive_datasources=True,
            ignore_backup_plan_references=True,
            allow_missing=True)
        ```

        ## Import

        BackupVault can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/backupVaults/{{backup_vault_id}}`

        * `{{project}}/{{location}}/{{backup_vault_id}}`

        * `{{location}}/{{backup_vault_id}}`

        When using the `pulumi import` command, BackupVault can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupVault:BackupVault default projects/{{project}}/locations/{{location}}/backupVaults/{{backup_vault_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupVault:BackupVault default {{project}}/{{location}}/{{backup_vault_id}}
        ```

        ```sh
        $ pulumi import gcp:backupdisasterrecovery/backupVault:BackupVault default {{location}}/{{backup_vault_id}}
        ```

        :param str resource_name: The name of the resource.
        :param BackupVaultArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BackupVaultArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 access_restriction: Optional[pulumi.Input[_builtins.str]] = None,
                 allow_missing: Optional[pulumi.Input[_builtins.bool]] = None,
                 annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 backup_minimum_enforced_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_retention_inheritance: Optional[pulumi.Input[_builtins.str]] = None,
                 backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_time: Optional[pulumi.Input[_builtins.str]] = None,
                 force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
                 force_update: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_backup_plan_references: Optional[pulumi.Input[_builtins.bool]] = None,
                 ignore_inactive_datasources: Optional[pulumi.Input[_builtins.bool]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BackupVaultArgs.__new__(BackupVaultArgs)

            __props__.__dict__["access_restriction"] = access_restriction
            __props__.__dict__["allow_missing"] = allow_missing
            __props__.__dict__["annotations"] = annotations
            if backup_minimum_enforced_retention_duration is None and not opts.urn:
                raise TypeError("Missing required property 'backup_minimum_enforced_retention_duration'")
            __props__.__dict__["backup_minimum_enforced_retention_duration"] = backup_minimum_enforced_retention_duration
            __props__.__dict__["backup_retention_inheritance"] = backup_retention_inheritance
            if backup_vault_id is None and not opts.urn:
                raise TypeError("Missing required property 'backup_vault_id'")
            __props__.__dict__["backup_vault_id"] = backup_vault_id
            __props__.__dict__["description"] = description
            __props__.__dict__["effective_time"] = effective_time
            __props__.__dict__["force_delete"] = force_delete
            __props__.__dict__["force_update"] = force_update
            __props__.__dict__["ignore_backup_plan_references"] = ignore_backup_plan_references
            __props__.__dict__["ignore_inactive_datasources"] = ignore_inactive_datasources
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["backup_count"] = None
            __props__.__dict__["create_time"] = None
            __props__.__dict__["deletable"] = None
            __props__.__dict__["effective_annotations"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["etag"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["service_account"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["total_stored_bytes"] = None
            __props__.__dict__["uid"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(BackupVault, __self__).__init__(
            'gcp:backupdisasterrecovery/backupVault:BackupVault',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            access_restriction: Optional[pulumi.Input[_builtins.str]] = None,
            allow_missing: Optional[pulumi.Input[_builtins.bool]] = None,
            annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            backup_count: Optional[pulumi.Input[_builtins.str]] = None,
            backup_minimum_enforced_retention_duration: Optional[pulumi.Input[_builtins.str]] = None,
            backup_retention_inheritance: Optional[pulumi.Input[_builtins.str]] = None,
            backup_vault_id: Optional[pulumi.Input[_builtins.str]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            deletable: Optional[pulumi.Input[_builtins.bool]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_annotations: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            effective_time: Optional[pulumi.Input[_builtins.str]] = None,
            etag: Optional[pulumi.Input[_builtins.str]] = None,
            force_delete: Optional[pulumi.Input[_builtins.bool]] = None,
            force_update: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_backup_plan_references: Optional[pulumi.Input[_builtins.bool]] = None,
            ignore_inactive_datasources: Optional[pulumi.Input[_builtins.bool]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            service_account: Optional[pulumi.Input[_builtins.str]] = None,
            state: Optional[pulumi.Input[_builtins.str]] = None,
            total_stored_bytes: Optional[pulumi.Input[_builtins.str]] = None,
            uid: Optional[pulumi.Input[_builtins.str]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'BackupVault':
        """
        Get an existing BackupVault resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] access_restriction: Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
               Default value is `WITHIN_ORGANIZATION`.
               Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        :param pulumi.Input[_builtins.bool] allow_missing: Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] annotations: Optional. User annotations. See https://google.aip.dev/128#annotations
               Stores small amounts of arbitrary data.
               **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
               Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        :param pulumi.Input[_builtins.str] backup_count: Output only. The number of backups in this backup vault.
        :param pulumi.Input[_builtins.str] backup_minimum_enforced_retention_duration: Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        :param pulumi.Input[_builtins.str] backup_retention_inheritance: How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
               Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        :param pulumi.Input[_builtins.str] backup_vault_id: Required. ID of the requesting object.
        :param pulumi.Input[_builtins.str] create_time: Output only. The time when the instance was created.
        :param pulumi.Input[_builtins.bool] deletable: Output only. Set to true when there are no backups nested under this resource.
        :param pulumi.Input[_builtins.str] description: Optional. The description of the BackupVault instance (2048 characters or less).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[_builtins.str] effective_time: Optional. Time after which the BackupVault resource is locked.
        :param pulumi.Input[_builtins.str] etag: Optional. Server specified ETag for the backup vault resource to prevent simultaneous updates from overwiting each other.
        :param pulumi.Input[_builtins.bool] force_delete: (Optional, Deprecated)
               If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
               * deletion of a backup vault instance that is being referenced by an active backup plan.
               
               > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        :param pulumi.Input[_builtins.bool] force_update: If set, allow update to extend the minimum enforced retention for backup vault. This overrides
               the restriction against conflicting retention periods. This conflict may occur when the
               expiration schedule defined by the associated backup plan is shorter than the minimum
               retention set by the backup vault.
        :param pulumi.Input[_builtins.bool] ignore_backup_plan_references: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance that is being referenced by an active backup plan.
        :param pulumi.Input[_builtins.bool] ignore_inactive_datasources: If set, the following restrictions against deletion of the backup vault instance can be overridden:
               * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Optional. Resource labels to represent user provided metadata.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The GCP location for the backup vault.
        :param pulumi.Input[_builtins.str] name: Output only. Identifier. The resource name.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[_builtins.str] service_account: Output only. Service account used by the BackupVault Service for this BackupVault.  The user should grant this account permissions in their workload project to enable the service to run backups and restores there.
        :param pulumi.Input[_builtins.str] state: Output only. The BackupVault resource instance state.
               Possible values:
               STATE_UNSPECIFIED
               CREATING
               ACTIVE
               DELETING
               ERROR
        :param pulumi.Input[_builtins.str] total_stored_bytes: Output only. Total size of the storage used by all backup resources.
        :param pulumi.Input[_builtins.str] uid: Output only. Output only Immutable after resource creation until resource deletion.
        :param pulumi.Input[_builtins.str] update_time: Output only. The time when the instance was updated.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _BackupVaultState.__new__(_BackupVaultState)

        __props__.__dict__["access_restriction"] = access_restriction
        __props__.__dict__["allow_missing"] = allow_missing
        __props__.__dict__["annotations"] = annotations
        __props__.__dict__["backup_count"] = backup_count
        __props__.__dict__["backup_minimum_enforced_retention_duration"] = backup_minimum_enforced_retention_duration
        __props__.__dict__["backup_retention_inheritance"] = backup_retention_inheritance
        __props__.__dict__["backup_vault_id"] = backup_vault_id
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["deletable"] = deletable
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_annotations"] = effective_annotations
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["effective_time"] = effective_time
        __props__.__dict__["etag"] = etag
        __props__.__dict__["force_delete"] = force_delete
        __props__.__dict__["force_update"] = force_update
        __props__.__dict__["ignore_backup_plan_references"] = ignore_backup_plan_references
        __props__.__dict__["ignore_inactive_datasources"] = ignore_inactive_datasources
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["service_account"] = service_account
        __props__.__dict__["state"] = state
        __props__.__dict__["total_stored_bytes"] = total_stored_bytes
        __props__.__dict__["uid"] = uid
        __props__.__dict__["update_time"] = update_time
        return BackupVault(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="accessRestriction")
    def access_restriction(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Access restriction for the backup vault. Default value is `WITHIN_ORGANIZATION` if not provided during creation.
        Default value is `WITHIN_ORGANIZATION`.
        Possible values are: `ACCESS_RESTRICTION_UNSPECIFIED`, `WITHIN_PROJECT`, `WITHIN_ORGANIZATION`, `UNRESTRICTED`, `WITHIN_ORG_BUT_UNRESTRICTED_FOR_BA`.
        """
        return pulumi.get(self, "access_restriction")

    @_builtins.property
    @pulumi.getter(name="allowMissing")
    def allow_missing(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        Allow idempotent deletion of backup vault. The request will still succeed in case the backup vault does not exist.
        """
        return pulumi.get(self, "allow_missing")

    @_builtins.property
    @pulumi.getter
    def annotations(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. User annotations. See https://google.aip.dev/128#annotations
        Stores small amounts of arbitrary data.
        **Note**: This field is non-authoritative, and will only manage the annotations present in your configuration.
        Please refer to the field `effective_annotations` for all of the annotations present on the resource.
        """
        return pulumi.get(self, "annotations")

    @_builtins.property
    @pulumi.getter(name="backupCount")
    def backup_count(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The number of backups in this backup vault.
        """
        return pulumi.get(self, "backup_count")

    @_builtins.property
    @pulumi.getter(name="backupMinimumEnforcedRetentionDuration")
    def backup_minimum_enforced_retention_duration(self) -> pulumi.Output[_builtins.str]:
        """
        Required. The default and minimum enforced retention for each backup within the backup vault. The enforced retention for each backup can be extended.
        """
        return pulumi.get(self, "backup_minimum_enforced_retention_duration")

    @_builtins.property
    @pulumi.getter(name="backupRetentionInheritance")
    def backup_retention_inheritance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        How a backup's enforced retention end time is inherited. Default value is `INHERIT_VAULT_RETENTION` if not provided during creation.
        Possible values are: `BACKUP_RETENTION_INHERITANCE_UNSPECIFIED`, `INHERIT_VAULT_RETENTION`, `MATCH_BACKUP_EXPIRE_TIME`.
        """
        return pulumi.get(self, "backup_retention_inheritance")

    @_builtins.property
    @pulumi.getter(name="backupVaultId")
    def backup_vault_id(self) -> pulumi.Output[_builtins.str]:
        """
        Required. ID of the requesting object.
        """
        return pulumi.get(self, "backup_vault_id")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The time when the instance was created.
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def deletable(self) -> pulumi.Output[_builtins.bool]:
        """
        Output only. Set to true when there are no backups nested under this resource.
        """
        return pulumi.get(self, "deletable")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. The description of the BackupVault instance (2048 characters or less).
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveAnnotations")
    def effective_annotations(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        return pulumi.get(self, "effective_annotations")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter(name="effectiveTime")
    def effective_time(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Optional. Time after which the BackupVault resource is locked.
        """
        return pulumi.get(self, "effective_time")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> pulumi.Output[_builtins.str]:
        """
        Optional. Server specified ETag for the backup vault resource to prevent simultaneous updates from overwiting each other.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter(name="forceDelete")
    @_utilities.deprecated("""`force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.""")
    def force_delete(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        (Optional, Deprecated)
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        * deletion of a backup vault instance that is being referenced by an active backup plan.

        > **Warning:** `force_delete` is deprecated and will be removed in a future major release. Use `ignore_inactive_datasources` instead.
        """
        return pulumi.get(self, "force_delete")

    @_builtins.property
    @pulumi.getter(name="forceUpdate")
    def force_update(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, allow update to extend the minimum enforced retention for backup vault. This overrides
        the restriction against conflicting retention periods. This conflict may occur when the
        expiration schedule defined by the associated backup plan is shorter than the minimum
        retention set by the backup vault.
        """
        return pulumi.get(self, "force_update")

    @_builtins.property
    @pulumi.getter(name="ignoreBackupPlanReferences")
    def ignore_backup_plan_references(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance that is being referenced by an active backup plan.
        """
        return pulumi.get(self, "ignore_backup_plan_references")

    @_builtins.property
    @pulumi.getter(name="ignoreInactiveDatasources")
    def ignore_inactive_datasources(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If set, the following restrictions against deletion of the backup vault instance can be overridden:
        * deletion of a backup vault instance containing no backups, but still containing empty datasources.
        """
        return pulumi.get(self, "ignore_inactive_datasources")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Optional. Resource labels to represent user provided metadata.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The GCP location for the backup vault.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Identifier. The resource name.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Service account used by the BackupVault Service for this BackupVault.  The user should grant this account permissions in their workload project to enable the service to run backups and restores there.
        """
        return pulumi.get(self, "service_account")

    @_builtins.property
    @pulumi.getter
    def state(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The BackupVault resource instance state.
        Possible values:
        STATE_UNSPECIFIED
        CREATING
        ACTIVE
        DELETING
        ERROR
        """
        return pulumi.get(self, "state")

    @_builtins.property
    @pulumi.getter(name="totalStoredBytes")
    def total_stored_bytes(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Total size of the storage used by all backup resources.
        """
        return pulumi.get(self, "total_stored_bytes")

    @_builtins.property
    @pulumi.getter
    def uid(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. Output only Immutable after resource creation until resource deletion.
        """
        return pulumi.get(self, "uid")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        Output only. The time when the instance was updated.
        """
        return pulumi.get(self, "update_time")

