# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs

__all__ = [
    'DatabaseHiveOptions',
    'TableHiveOptions',
    'TableHiveOptionsStorageDescriptor',
]

@pulumi.output_type
class DatabaseHiveOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "locationUri":
            suggest = "location_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DatabaseHiveOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DatabaseHiveOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DatabaseHiveOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 location_uri: Optional[_builtins.str] = None,
                 parameters: Optional[Mapping[str, _builtins.str]] = None):
        """
        :param _builtins.str location_uri: Cloud Storage folder URI where the database data is stored, starting with "gs://".
        :param Mapping[str, _builtins.str] parameters: Stores user supplied Hive database parameters. An object containing a
               list of"key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        if location_uri is not None:
            pulumi.set(__self__, "location_uri", location_uri)
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)

    @_builtins.property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[_builtins.str]:
        """
        Cloud Storage folder URI where the database data is stored, starting with "gs://".
        """
        return pulumi.get(self, "location_uri")

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Stores user supplied Hive database parameters. An object containing a
        list of"key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "parameters")


@pulumi.output_type
class TableHiveOptions(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "storageDescriptor":
            suggest = "storage_descriptor"
        elif key == "tableType":
            suggest = "table_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableHiveOptions. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableHiveOptions.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableHiveOptions.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 parameters: Optional[Mapping[str, _builtins.str]] = None,
                 storage_descriptor: Optional['outputs.TableHiveOptionsStorageDescriptor'] = None,
                 table_type: Optional[_builtins.str] = None):
        """
        :param Mapping[str, _builtins.str] parameters: Stores user supplied Hive table parameters. An object containing a
               list of "key": value pairs.
               Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        :param 'TableHiveOptionsStorageDescriptorArgs' storage_descriptor: Stores physical storage information on the data.
               Structure is documented below.
        :param _builtins.str table_type: Hive table type. For example, MANAGED_TABLE, EXTERNAL_TABLE.
        """
        if parameters is not None:
            pulumi.set(__self__, "parameters", parameters)
        if storage_descriptor is not None:
            pulumi.set(__self__, "storage_descriptor", storage_descriptor)
        if table_type is not None:
            pulumi.set(__self__, "table_type", table_type)

    @_builtins.property
    @pulumi.getter
    def parameters(self) -> Optional[Mapping[str, _builtins.str]]:
        """
        Stores user supplied Hive table parameters. An object containing a
        list of "key": value pairs.
        Example: { "name": "wrench", "mass": "1.3kg", "count": "3" }.
        """
        return pulumi.get(self, "parameters")

    @_builtins.property
    @pulumi.getter(name="storageDescriptor")
    def storage_descriptor(self) -> Optional['outputs.TableHiveOptionsStorageDescriptor']:
        """
        Stores physical storage information on the data.
        Structure is documented below.
        """
        return pulumi.get(self, "storage_descriptor")

    @_builtins.property
    @pulumi.getter(name="tableType")
    def table_type(self) -> Optional[_builtins.str]:
        """
        Hive table type. For example, MANAGED_TABLE, EXTERNAL_TABLE.
        """
        return pulumi.get(self, "table_type")


@pulumi.output_type
class TableHiveOptionsStorageDescriptor(dict):
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "inputFormat":
            suggest = "input_format"
        elif key == "locationUri":
            suggest = "location_uri"
        elif key == "outputFormat":
            suggest = "output_format"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in TableHiveOptionsStorageDescriptor. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        TableHiveOptionsStorageDescriptor.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        TableHiveOptionsStorageDescriptor.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 input_format: Optional[_builtins.str] = None,
                 location_uri: Optional[_builtins.str] = None,
                 output_format: Optional[_builtins.str] = None):
        """
        :param _builtins.str input_format: The fully qualified Java class name of the input format.
        :param _builtins.str location_uri: Cloud Storage folder URI where the table data is stored, starting with "gs://".
        :param _builtins.str output_format: The fully qualified Java class name of the output format.
        """
        if input_format is not None:
            pulumi.set(__self__, "input_format", input_format)
        if location_uri is not None:
            pulumi.set(__self__, "location_uri", location_uri)
        if output_format is not None:
            pulumi.set(__self__, "output_format", output_format)

    @_builtins.property
    @pulumi.getter(name="inputFormat")
    def input_format(self) -> Optional[_builtins.str]:
        """
        The fully qualified Java class name of the input format.
        """
        return pulumi.get(self, "input_format")

    @_builtins.property
    @pulumi.getter(name="locationUri")
    def location_uri(self) -> Optional[_builtins.str]:
        """
        Cloud Storage folder URI where the table data is stored, starting with "gs://".
        """
        return pulumi.get(self, "location_uri")

    @_builtins.property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> Optional[_builtins.str]:
        """
        The fully qualified Java class name of the output format.
        """
        return pulumi.get(self, "output_format")


