# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetDefaultServiceAccountResult',
    'AwaitableGetDefaultServiceAccountResult',
    'get_default_service_account',
    'get_default_service_account_output',
]

@pulumi.output_type
class GetDefaultServiceAccountResult:
    """
    A collection of values returned by getDefaultServiceAccount.
    """
    def __init__(__self__, email=None, id=None, member=None, project=None):
        if email and not isinstance(email, str):
            raise TypeError("Expected argument 'email' to be a str")
        pulumi.set(__self__, "email", email)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if member and not isinstance(member, str):
            raise TypeError("Expected argument 'member' to be a str")
        pulumi.set(__self__, "member", member)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)

    @_builtins.property
    @pulumi.getter
    def email(self) -> _builtins.str:
        """
        The email address of the service account. This value is often used to refer to the service account
        in order to grant IAM permissions.
        """
        return pulumi.get(self, "email")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter
    def member(self) -> _builtins.str:
        """
        The Identity of the service account in the form `serviceAccount:{email}`. This value is often used to refer to the service account in order to grant IAM permissions.
        """
        return pulumi.get(self, "member")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")


class AwaitableGetDefaultServiceAccountResult(GetDefaultServiceAccountResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDefaultServiceAccountResult(
            email=self.email,
            id=self.id,
            member=self.member,
            project=self.project)


def get_default_service_account(project: Optional[_builtins.str] = None,
                                opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDefaultServiceAccountResult:
    """
    Get the email address of a project's unique BigQuery service account.

    Each Google Cloud project has a unique service account used by BigQuery. When using
    BigQuery with [customer-managed encryption keys](https://cloud.google.com/bigquery/docs/customer-managed-encryption),
    this account needs to be granted the
    `cloudkms.cryptoKeyEncrypterDecrypter` IAM role on the customer-managed Cloud KMS key used to protect the data.

    For more information see
    [the API reference](https://cloud.google.com/bigquery/docs/reference/rest/v2/projects/getServiceAccount).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    bq_sa = gcp.bigquery.get_default_service_account()
    key_sa_user = gcp.kms.CryptoKeyIAMMember("key_sa_user",
        crypto_key_id=key["id"],
        role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
        member=f"serviceAccount:{bq_sa.email}")
    ```


    :param _builtins.str project: The project the unique service account was created for. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigquery/getDefaultServiceAccount:getDefaultServiceAccount', __args__, opts=opts, typ=GetDefaultServiceAccountResult).value

    return AwaitableGetDefaultServiceAccountResult(
        email=pulumi.get(__ret__, 'email'),
        id=pulumi.get(__ret__, 'id'),
        member=pulumi.get(__ret__, 'member'),
        project=pulumi.get(__ret__, 'project'))
def get_default_service_account_output(project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                       opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetDefaultServiceAccountResult]:
    """
    Get the email address of a project's unique BigQuery service account.

    Each Google Cloud project has a unique service account used by BigQuery. When using
    BigQuery with [customer-managed encryption keys](https://cloud.google.com/bigquery/docs/customer-managed-encryption),
    this account needs to be granted the
    `cloudkms.cryptoKeyEncrypterDecrypter` IAM role on the customer-managed Cloud KMS key used to protect the data.

    For more information see
    [the API reference](https://cloud.google.com/bigquery/docs/reference/rest/v2/projects/getServiceAccount).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_gcp as gcp

    bq_sa = gcp.bigquery.get_default_service_account()
    key_sa_user = gcp.kms.CryptoKeyIAMMember("key_sa_user",
        crypto_key_id=key["id"],
        role="roles/cloudkms.cryptoKeyEncrypterDecrypter",
        member=f"serviceAccount:{bq_sa.email}")
    ```


    :param _builtins.str project: The project the unique service account was created for. If it is not provided, the provider project is used.
    """
    __args__ = dict()
    __args__['project'] = project
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:bigquery/getDefaultServiceAccount:getDefaultServiceAccount', __args__, opts=opts, typ=GetDefaultServiceAccountResult)
    return __ret__.apply(lambda __response__: GetDefaultServiceAccountResult(
        email=pulumi.get(__response__, 'email'),
        id=pulumi.get(__response__, 'id'),
        member=pulumi.get(__response__, 'member'),
        project=pulumi.get(__response__, 'project')))
