# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetTableIamPolicyResult',
    'AwaitableGetTableIamPolicyResult',
    'get_table_iam_policy',
    'get_table_iam_policy_output',
]

@pulumi.output_type
class GetTableIamPolicyResult:
    """
    A collection of values returned by getTableIamPolicy.
    """
    def __init__(__self__, etag=None, id=None, instance_name=None, policy_data=None, project=None, table=None):
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if instance_name and not isinstance(instance_name, str):
            raise TypeError("Expected argument 'instance_name' to be a str")
        pulumi.set(__self__, "instance_name", instance_name)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)
        if project and not isinstance(project, str):
            raise TypeError("Expected argument 'project' to be a str")
        pulumi.set(__self__, "project", project)
        if table and not isinstance(table, str):
            raise TypeError("Expected argument 'table' to be a str")
        pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> _builtins.str:
        return pulumi.get(self, "instance_name")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")

    @_builtins.property
    @pulumi.getter
    def project(self) -> _builtins.str:
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter
    def table(self) -> _builtins.str:
        return pulumi.get(self, "table")


class AwaitableGetTableIamPolicyResult(GetTableIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetTableIamPolicyResult(
            etag=self.etag,
            id=self.id,
            instance_name=self.instance_name,
            policy_data=self.policy_data,
            project=self.project,
            table=self.table)


def get_table_iam_policy(instance_name: Optional[_builtins.str] = None,
                         project: Optional[_builtins.str] = None,
                         table: Optional[_builtins.str] = None,
                         opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetTableIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Bigtable Table.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.bigtable.get_table_iam_policy(instance_name=instance["name"],
        table=table["name"])
    ```


    :param _builtins.str table: The name or relative resource id of the table to manage IAM policies for.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['project'] = project
    __args__['table'] = table
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:bigtable/getTableIamPolicy:getTableIamPolicy', __args__, opts=opts, typ=GetTableIamPolicyResult).value

    return AwaitableGetTableIamPolicyResult(
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        instance_name=pulumi.get(__ret__, 'instance_name'),
        policy_data=pulumi.get(__ret__, 'policy_data'),
        project=pulumi.get(__ret__, 'project'),
        table=pulumi.get(__ret__, 'table'))
def get_table_iam_policy_output(instance_name: Optional[pulumi.Input[_builtins.str]] = None,
                                project: Optional[pulumi.Input[Optional[_builtins.str]]] = None,
                                table: Optional[pulumi.Input[_builtins.str]] = None,
                                opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetTableIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Bigtable Table.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.bigtable.get_table_iam_policy(instance_name=instance["name"],
        table=table["name"])
    ```


    :param _builtins.str table: The name or relative resource id of the table to manage IAM policies for.
    """
    __args__ = dict()
    __args__['instanceName'] = instance_name
    __args__['project'] = project
    __args__['table'] = table
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:bigtable/getTableIamPolicy:getTableIamPolicy', __args__, opts=opts, typ=GetTableIamPolicyResult)
    return __ret__.apply(lambda __response__: GetTableIamPolicyResult(
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        instance_name=pulumi.get(__response__, 'instance_name'),
        policy_data=pulumi.get(__response__, 'policy_data'),
        project=pulumi.get(__response__, 'project'),
        table=pulumi.get(__response__, 'table')))
