# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['SchemaBundleArgs', 'SchemaBundle']

@pulumi.input_type
class SchemaBundleArgs:
    def __init__(__self__, *,
                 proto_schema: pulumi.Input['SchemaBundleProtoSchemaArgs'],
                 schema_bundle_id: pulumi.Input[_builtins.str],
                 ignore_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None):
        """
        The set of arguments for constructing a SchemaBundle resource.
        :param pulumi.Input['SchemaBundleProtoSchemaArgs'] proto_schema: File descriptor set, generated by protoc.
               To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
               $ protoc --include_imports --include_source_info test.proto -o out.pb
               Structure is documented below.
        :param pulumi.Input[_builtins.str] schema_bundle_id: The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.bool] ignore_warnings: If true, allow backwards incompatible changes.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the schema bundle within.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[_builtins.str] table: The name of the table to create the schema bundle within.
        """
        pulumi.set(__self__, "proto_schema", proto_schema)
        pulumi.set(__self__, "schema_bundle_id", schema_bundle_id)
        if ignore_warnings is not None:
            pulumi.set(__self__, "ignore_warnings", ignore_warnings)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter(name="protoSchema")
    def proto_schema(self) -> pulumi.Input['SchemaBundleProtoSchemaArgs']:
        """
        File descriptor set, generated by protoc.
        To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
        $ protoc --include_imports --include_source_info test.proto -o out.pb
        Structure is documented below.
        """
        return pulumi.get(self, "proto_schema")

    @proto_schema.setter
    def proto_schema(self, value: pulumi.Input['SchemaBundleProtoSchemaArgs']):
        pulumi.set(self, "proto_schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaBundleId")
    def schema_bundle_id(self) -> pulumi.Input[_builtins.str]:
        """
        The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        """
        return pulumi.get(self, "schema_bundle_id")

    @schema_bundle_id.setter
    def schema_bundle_id(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "schema_bundle_id", value)

    @_builtins.property
    @pulumi.getter(name="ignoreWarnings")
    def ignore_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, allow backwards incompatible changes.
        """
        return pulumi.get(self, "ignore_warnings")

    @ignore_warnings.setter
    def ignore_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_warnings", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance to create the schema bundle within.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table to create the schema bundle within.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)


@pulumi.input_type
class _SchemaBundleState:
    def __init__(__self__, *,
                 ignore_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proto_schema: Optional[pulumi.Input['SchemaBundleProtoSchemaArgs']] = None,
                 schema_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering SchemaBundle resources.
        :param pulumi.Input[_builtins.bool] ignore_warnings: If true, allow backwards incompatible changes.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the schema bundle within.
        :param pulumi.Input[_builtins.str] name: The unique name of the requested schema bundle. Values are of the form `projects/<project>/instances/<instance>/tables/<table>/schemaBundles/<schemaBundleId>`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input['SchemaBundleProtoSchemaArgs'] proto_schema: File descriptor set, generated by protoc.
               To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
               $ protoc --include_imports --include_source_info test.proto -o out.pb
               Structure is documented below.
        :param pulumi.Input[_builtins.str] schema_bundle_id: The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] table: The name of the table to create the schema bundle within.
        """
        if ignore_warnings is not None:
            pulumi.set(__self__, "ignore_warnings", ignore_warnings)
        if instance is not None:
            pulumi.set(__self__, "instance", instance)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if proto_schema is not None:
            pulumi.set(__self__, "proto_schema", proto_schema)
        if schema_bundle_id is not None:
            pulumi.set(__self__, "schema_bundle_id", schema_bundle_id)
        if table is not None:
            pulumi.set(__self__, "table", table)

    @_builtins.property
    @pulumi.getter(name="ignoreWarnings")
    def ignore_warnings(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        If true, allow backwards incompatible changes.
        """
        return pulumi.get(self, "ignore_warnings")

    @ignore_warnings.setter
    def ignore_warnings(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "ignore_warnings", value)

    @_builtins.property
    @pulumi.getter
    def instance(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the instance to create the schema bundle within.
        """
        return pulumi.get(self, "instance")

    @instance.setter
    def instance(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "instance", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the requested schema bundle. Values are of the form `projects/<project>/instances/<instance>/tables/<table>/schemaBundles/<schemaBundleId>`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="protoSchema")
    def proto_schema(self) -> Optional[pulumi.Input['SchemaBundleProtoSchemaArgs']]:
        """
        File descriptor set, generated by protoc.
        To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
        $ protoc --include_imports --include_source_info test.proto -o out.pb
        Structure is documented below.
        """
        return pulumi.get(self, "proto_schema")

    @proto_schema.setter
    def proto_schema(self, value: Optional[pulumi.Input['SchemaBundleProtoSchemaArgs']]):
        pulumi.set(self, "proto_schema", value)

    @_builtins.property
    @pulumi.getter(name="schemaBundleId")
    def schema_bundle_id(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        """
        return pulumi.get(self, "schema_bundle_id")

    @schema_bundle_id.setter
    def schema_bundle_id(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "schema_bundle_id", value)

    @_builtins.property
    @pulumi.getter
    def table(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The name of the table to create the schema bundle within.
        """
        return pulumi.get(self, "table")

    @table.setter
    def table(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "table", value)


@pulumi.type_token("gcp:bigtable/schemaBundle:SchemaBundle")
class SchemaBundle(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ignore_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proto_schema: Optional[pulumi.Input[Union['SchemaBundleProtoSchemaArgs', 'SchemaBundleProtoSchemaArgsDict']]] = None,
                 schema_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        """
        A schema bundle object that can be referenced in SQL queries.

        To get more information about SchemaBundle, see:

        * [API documentation](https://cloud.google.com/bigtable/docs/reference/admin/rest/v2/projects.instances.tables.schemaBundles)

        ## Example Usage

        ### Bigtable Schema Bundle

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        instance = gcp.bigtable.Instance("instance",
            name="bt-instance",
            clusters=[{
                "cluster_id": "cluster-1",
                "zone": "us-east1-b",
                "num_nodes": 1,
                "storage_type": "HDD",
            }],
            deletion_protection=False)
        table = gcp.bigtable.Table("table",
            name="bt-table",
            instance_name=instance.name,
            column_families=[{
                "family": "CF",
            }])
        schema_bundle = gcp.bigtable.SchemaBundle("schema_bundle",
            schema_bundle_id="bt-schema-bundle",
            instance=instance.name,
            table=table.name,
            proto_schema={
                "proto_descriptors": std.filebase64(input="test-fixtures/proto_schema_bundle.pb").result,
            })
        ```

        ## Import

        SchemaBundle can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/tables/{{table}}/schemaBundles/{{schema_bundle_id}}`

        * `{{project}}/{{instance}}/{{table}}/{{schema_bundle_id}}`

        * `{{instance}}/{{table}}/{{schema_bundle_id}}`

        When using the `pulumi import` command, SchemaBundle can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/schemaBundle:SchemaBundle default projects/{{project}}/instances/{{instance}}/tables/{{table}}/schemaBundles/{{schema_bundle_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/schemaBundle:SchemaBundle default {{project}}/{{instance}}/{{table}}/{{schema_bundle_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/schemaBundle:SchemaBundle default {{instance}}/{{table}}/{{schema_bundle_id}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] ignore_warnings: If true, allow backwards incompatible changes.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the schema bundle within.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SchemaBundleProtoSchemaArgs', 'SchemaBundleProtoSchemaArgsDict']] proto_schema: File descriptor set, generated by protoc.
               To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
               $ protoc --include_imports --include_source_info test.proto -o out.pb
               Structure is documented below.
        :param pulumi.Input[_builtins.str] schema_bundle_id: The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] table: The name of the table to create the schema bundle within.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: SchemaBundleArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        A schema bundle object that can be referenced in SQL queries.

        To get more information about SchemaBundle, see:

        * [API documentation](https://cloud.google.com/bigtable/docs/reference/admin/rest/v2/projects.instances.tables.schemaBundles)

        ## Example Usage

        ### Bigtable Schema Bundle

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        instance = gcp.bigtable.Instance("instance",
            name="bt-instance",
            clusters=[{
                "cluster_id": "cluster-1",
                "zone": "us-east1-b",
                "num_nodes": 1,
                "storage_type": "HDD",
            }],
            deletion_protection=False)
        table = gcp.bigtable.Table("table",
            name="bt-table",
            instance_name=instance.name,
            column_families=[{
                "family": "CF",
            }])
        schema_bundle = gcp.bigtable.SchemaBundle("schema_bundle",
            schema_bundle_id="bt-schema-bundle",
            instance=instance.name,
            table=table.name,
            proto_schema={
                "proto_descriptors": std.filebase64(input="test-fixtures/proto_schema_bundle.pb").result,
            })
        ```

        ## Import

        SchemaBundle can be imported using any of these accepted formats:

        * `projects/{{project}}/instances/{{instance}}/tables/{{table}}/schemaBundles/{{schema_bundle_id}}`

        * `{{project}}/{{instance}}/{{table}}/{{schema_bundle_id}}`

        * `{{instance}}/{{table}}/{{schema_bundle_id}}`

        When using the `pulumi import` command, SchemaBundle can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:bigtable/schemaBundle:SchemaBundle default projects/{{project}}/instances/{{instance}}/tables/{{table}}/schemaBundles/{{schema_bundle_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/schemaBundle:SchemaBundle default {{project}}/{{instance}}/{{table}}/{{schema_bundle_id}}
        ```

        ```sh
        $ pulumi import gcp:bigtable/schemaBundle:SchemaBundle default {{instance}}/{{table}}/{{schema_bundle_id}}
        ```

        :param str resource_name: The name of the resource.
        :param SchemaBundleArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(SchemaBundleArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 ignore_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
                 instance: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 proto_schema: Optional[pulumi.Input[Union['SchemaBundleProtoSchemaArgs', 'SchemaBundleProtoSchemaArgsDict']]] = None,
                 schema_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
                 table: Optional[pulumi.Input[_builtins.str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = SchemaBundleArgs.__new__(SchemaBundleArgs)

            __props__.__dict__["ignore_warnings"] = ignore_warnings
            __props__.__dict__["instance"] = instance
            __props__.__dict__["project"] = project
            if proto_schema is None and not opts.urn:
                raise TypeError("Missing required property 'proto_schema'")
            __props__.__dict__["proto_schema"] = proto_schema
            if schema_bundle_id is None and not opts.urn:
                raise TypeError("Missing required property 'schema_bundle_id'")
            __props__.__dict__["schema_bundle_id"] = schema_bundle_id
            __props__.__dict__["table"] = table
            __props__.__dict__["name"] = None
        super(SchemaBundle, __self__).__init__(
            'gcp:bigtable/schemaBundle:SchemaBundle',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            ignore_warnings: Optional[pulumi.Input[_builtins.bool]] = None,
            instance: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            proto_schema: Optional[pulumi.Input[Union['SchemaBundleProtoSchemaArgs', 'SchemaBundleProtoSchemaArgsDict']]] = None,
            schema_bundle_id: Optional[pulumi.Input[_builtins.str]] = None,
            table: Optional[pulumi.Input[_builtins.str]] = None) -> 'SchemaBundle':
        """
        Get an existing SchemaBundle resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.bool] ignore_warnings: If true, allow backwards incompatible changes.
        :param pulumi.Input[_builtins.str] instance: The name of the instance to create the schema bundle within.
        :param pulumi.Input[_builtins.str] name: The unique name of the requested schema bundle. Values are of the form `projects/<project>/instances/<instance>/tables/<table>/schemaBundles/<schemaBundleId>`.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Union['SchemaBundleProtoSchemaArgs', 'SchemaBundleProtoSchemaArgsDict']] proto_schema: File descriptor set, generated by protoc.
               To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
               $ protoc --include_imports --include_source_info test.proto -o out.pb
               Structure is documented below.
        :param pulumi.Input[_builtins.str] schema_bundle_id: The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        :param pulumi.Input[_builtins.str] table: The name of the table to create the schema bundle within.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _SchemaBundleState.__new__(_SchemaBundleState)

        __props__.__dict__["ignore_warnings"] = ignore_warnings
        __props__.__dict__["instance"] = instance
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["proto_schema"] = proto_schema
        __props__.__dict__["schema_bundle_id"] = schema_bundle_id
        __props__.__dict__["table"] = table
        return SchemaBundle(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="ignoreWarnings")
    def ignore_warnings(self) -> pulumi.Output[Optional[_builtins.bool]]:
        """
        If true, allow backwards incompatible changes.
        """
        return pulumi.get(self, "ignore_warnings")

    @_builtins.property
    @pulumi.getter
    def instance(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the instance to create the schema bundle within.
        """
        return pulumi.get(self, "instance")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the requested schema bundle. Values are of the form `projects/<project>/instances/<instance>/tables/<table>/schemaBundles/<schemaBundleId>`.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="protoSchema")
    def proto_schema(self) -> pulumi.Output['outputs.SchemaBundleProtoSchema']:
        """
        File descriptor set, generated by protoc.
        To generate, use protoc with imports and source info included. For an example test.proto file, the following command would put the value in a new file named out.pb.
        $ protoc --include_imports --include_source_info test.proto -o out.pb
        Structure is documented below.
        """
        return pulumi.get(self, "proto_schema")

    @_builtins.property
    @pulumi.getter(name="schemaBundleId")
    def schema_bundle_id(self) -> pulumi.Output[_builtins.str]:
        """
        The unique name of the schema bundle in the form `[_a-zA-Z0-9][-_.a-zA-Z0-9]*`.
        """
        return pulumi.get(self, "schema_bundle_id")

    @_builtins.property
    @pulumi.getter
    def table(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        The name of the table to create the schema bundle within.
        """
        return pulumi.get(self, "table")

