# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities

__all__ = [
    'GetAccountIamPolicyResult',
    'AwaitableGetAccountIamPolicyResult',
    'get_account_iam_policy',
    'get_account_iam_policy_output',
]

@pulumi.output_type
class GetAccountIamPolicyResult:
    """
    A collection of values returned by getAccountIamPolicy.
    """
    def __init__(__self__, billing_account_id=None, etag=None, id=None, policy_data=None):
        if billing_account_id and not isinstance(billing_account_id, str):
            raise TypeError("Expected argument 'billing_account_id' to be a str")
        pulumi.set(__self__, "billing_account_id", billing_account_id)
        if etag and not isinstance(etag, str):
            raise TypeError("Expected argument 'etag' to be a str")
        pulumi.set(__self__, "etag", etag)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if policy_data and not isinstance(policy_data, str):
            raise TypeError("Expected argument 'policy_data' to be a str")
        pulumi.set(__self__, "policy_data", policy_data)

    @_builtins.property
    @pulumi.getter(name="billingAccountId")
    def billing_account_id(self) -> _builtins.str:
        return pulumi.get(self, "billing_account_id")

    @_builtins.property
    @pulumi.getter
    def etag(self) -> _builtins.str:
        """
        (Computed) The etag of the IAM policy.
        """
        return pulumi.get(self, "etag")

    @_builtins.property
    @pulumi.getter
    def id(self) -> _builtins.str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @_builtins.property
    @pulumi.getter(name="policyData")
    def policy_data(self) -> _builtins.str:
        """
        (Computed) The policy data
        """
        return pulumi.get(self, "policy_data")


class AwaitableGetAccountIamPolicyResult(GetAccountIamPolicyResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAccountIamPolicyResult(
            billing_account_id=self.billing_account_id,
            etag=self.etag,
            id=self.id,
            policy_data=self.policy_data)


def get_account_iam_policy(billing_account_id: Optional[_builtins.str] = None,
                           opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAccountIamPolicyResult:
    """
    Retrieves the current IAM policy data for a Billing Account.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.billing.get_account_iam_policy(billing_account_id="MEEP-MEEP-MEEP-MEEP-MEEP")
    ```


    :param _builtins.str billing_account_id: The billing account id.
    """
    __args__ = dict()
    __args__['billingAccountId'] = billing_account_id
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('gcp:billing/getAccountIamPolicy:getAccountIamPolicy', __args__, opts=opts, typ=GetAccountIamPolicyResult).value

    return AwaitableGetAccountIamPolicyResult(
        billing_account_id=pulumi.get(__ret__, 'billing_account_id'),
        etag=pulumi.get(__ret__, 'etag'),
        id=pulumi.get(__ret__, 'id'),
        policy_data=pulumi.get(__ret__, 'policy_data'))
def get_account_iam_policy_output(billing_account_id: Optional[pulumi.Input[_builtins.str]] = None,
                                  opts: Optional[Union[pulumi.InvokeOptions, pulumi.InvokeOutputOptions]] = None) -> pulumi.Output[GetAccountIamPolicyResult]:
    """
    Retrieves the current IAM policy data for a Billing Account.

    ## example

    ```python
    import pulumi
    import pulumi_gcp as gcp

    policy = gcp.billing.get_account_iam_policy(billing_account_id="MEEP-MEEP-MEEP-MEEP-MEEP")
    ```


    :param _builtins.str billing_account_id: The billing account id.
    """
    __args__ = dict()
    __args__['billingAccountId'] = billing_account_id
    opts = pulumi.InvokeOutputOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke_output('gcp:billing/getAccountIamPolicy:getAccountIamPolicy', __args__, opts=opts, typ=GetAccountIamPolicyResult)
    return __ret__.apply(lambda __response__: GetAccountIamPolicyResult(
        billing_account_id=pulumi.get(__response__, 'billing_account_id'),
        etag=pulumi.get(__response__, 'etag'),
        id=pulumi.get(__response__, 'id'),
        policy_data=pulumi.get(__response__, 'policy_data')))
