# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from .. import _utilities
from . import outputs
from ._inputs import *

__all__ = ['TrustConfigArgs', 'TrustConfig']

@pulumi.input_type
class TrustConfigArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[_builtins.str],
                 allowlisted_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_stores: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]]] = None):
        """
        The set of arguments for constructing a TrustConfig resource.
        :param pulumi.Input[_builtins.str] location: The trust config location.
        :param pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]] allowlisted_certificates: Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
               the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: One or more paragraphs of text description of a trust config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the trust config.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the trust config. Trust config names must be unique globally.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]] trust_stores: Set of trust stores to perform validation against.
               This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
               Structure is documented below.
        """
        pulumi.set(__self__, "location", location)
        if allowlisted_certificates is not None:
            pulumi.set(__self__, "allowlisted_certificates", allowlisted_certificates)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if trust_stores is not None:
            pulumi.set(__self__, "trust_stores", trust_stores)

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Input[_builtins.str]:
        """
        The trust config location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[_builtins.str]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter(name="allowlistedCertificates")
    def allowlisted_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]]]:
        """
        Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
        the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
        Structure is documented below.
        """
        return pulumi.get(self, "allowlisted_certificates")

    @allowlisted_certificates.setter
    def allowlisted_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]]]):
        pulumi.set(self, "allowlisted_certificates", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One or more paragraphs of text description of a trust config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the trust config.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-defined name of the trust config. Trust config names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="trustStores")
    def trust_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]]]:
        """
        Set of trust stores to perform validation against.
        This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
        Structure is documented below.
        """
        return pulumi.get(self, "trust_stores")

    @trust_stores.setter
    def trust_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]]]):
        pulumi.set(self, "trust_stores", value)


@pulumi.input_type
class _TrustConfigState:
    def __init__(__self__, *,
                 allowlisted_certificates: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]]] = None,
                 create_time: Optional[pulumi.Input[_builtins.str]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 trust_stores: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]]] = None,
                 update_time: Optional[pulumi.Input[_builtins.str]] = None):
        """
        Input properties used for looking up and filtering TrustConfig resources.
        :param pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]] allowlisted_certificates: Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
               the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The creation timestamp of a TrustConfig.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] description: One or more paragraphs of text description of a trust config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the trust config.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The trust config location.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the trust config. Trust config names must be unique globally.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]] trust_stores: Set of trust stores to perform validation against.
               This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The last update timestamp of a TrustConfig.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        if allowlisted_certificates is not None:
            pulumi.set(__self__, "allowlisted_certificates", allowlisted_certificates)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if effective_labels is not None:
            pulumi.set(__self__, "effective_labels", effective_labels)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pulumi_labels is not None:
            pulumi.set(__self__, "pulumi_labels", pulumi_labels)
        if trust_stores is not None:
            pulumi.set(__self__, "trust_stores", trust_stores)
        if update_time is not None:
            pulumi.set(__self__, "update_time", update_time)

    @_builtins.property
    @pulumi.getter(name="allowlistedCertificates")
    def allowlisted_certificates(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]]]:
        """
        Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
        the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
        Structure is documented below.
        """
        return pulumi.get(self, "allowlisted_certificates")

    @allowlisted_certificates.setter
    def allowlisted_certificates(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigAllowlistedCertificateArgs']]]]):
        pulumi.set(self, "allowlisted_certificates", value)

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The creation timestamp of a TrustConfig.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "create_time", value)

    @_builtins.property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        One or more paragraphs of text description of a trust config.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "description", value)

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @effective_labels.setter
    def effective_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "effective_labels", value)

    @_builtins.property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Set of label tags associated with the trust config.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "labels", value)

    @_builtins.property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The trust config location.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "location", value)

    @_builtins.property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A user-defined name of the trust config. Trust config names must be unique globally.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "name", value)

    @_builtins.property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "project", value)

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @pulumi_labels.setter
    def pulumi_labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "pulumi_labels", value)

    @_builtins.property
    @pulumi.getter(name="trustStores")
    def trust_stores(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]]]:
        """
        Set of trust stores to perform validation against.
        This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
        Structure is documented below.
        """
        return pulumi.get(self, "trust_stores")

    @trust_stores.setter
    def trust_stores(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['TrustConfigTrustStoreArgs']]]]):
        pulumi.set(self, "trust_stores", value)

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The last update timestamp of a TrustConfig.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

    @update_time.setter
    def update_time(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "update_time", value)


@pulumi.type_token("gcp:certificatemanager/trustConfig:TrustConfig")
class TrustConfig(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowlisted_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigAllowlistedCertificateArgs', 'TrustConfigAllowlistedCertificateArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigTrustStoreArgs', 'TrustConfigTrustStoreArgsDict']]]]] = None,
                 __props__=None):
        """
        TrustConfig represents a resource that represents your Public Key Infrastructure (PKI) configuration in Certificate Manager for use in mutual TLS authentication scenarios.

        To get more information about TrustConfig, see:

        * [API documentation](https://cloud.google.com/certificate-manager/docs/reference/certificate-manager/rest/v1/projects.locations.trustConfigs/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/certificate-manager/docs)

        ## Example Usage

        ### Certificate Manager Trust Config

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.TrustConfig("default",
            name="trust-config",
            description="sample description for the trust config",
            location="us-central1",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        ```
        ### Certificate Manager Trust Config Allowlisted Certificates

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.TrustConfig("default",
            name="trust-config",
            description="A sample trust config resource with allowlisted certificates",
            location="global",
            allowlisted_certificates=[
                {
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                },
                {
                    "pem_certificate": std.file(input="test-fixtures/cert2.pem").result,
                },
            ],
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        TrustConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/trustConfigs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, TrustConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/trustConfig:TrustConfig default projects/{{project}}/locations/{{location}}/trustConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/trustConfig:TrustConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/trustConfig:TrustConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigAllowlistedCertificateArgs', 'TrustConfigAllowlistedCertificateArgsDict']]]] allowlisted_certificates: Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
               the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] description: One or more paragraphs of text description of a trust config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the trust config.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The trust config location.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the trust config. Trust config names must be unique globally.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigTrustStoreArgs', 'TrustConfigTrustStoreArgsDict']]]] trust_stores: Set of trust stores to perform validation against.
               This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
               Structure is documented below.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: TrustConfigArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        TrustConfig represents a resource that represents your Public Key Infrastructure (PKI) configuration in Certificate Manager for use in mutual TLS authentication scenarios.

        To get more information about TrustConfig, see:

        * [API documentation](https://cloud.google.com/certificate-manager/docs/reference/certificate-manager/rest/v1/projects.locations.trustConfigs/create)
        * How-to Guides
            * [Official Documentation](https://cloud.google.com/certificate-manager/docs)

        ## Example Usage

        ### Certificate Manager Trust Config

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.TrustConfig("default",
            name="trust-config",
            description="sample description for the trust config",
            location="us-central1",
            trust_stores=[{
                "trust_anchors": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
                "intermediate_cas": [{
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                }],
            }],
            labels={
                "foo": "bar",
            })
        ```
        ### Certificate Manager Trust Config Allowlisted Certificates

        ```python
        import pulumi
        import pulumi_gcp as gcp
        import pulumi_std as std

        default = gcp.certificatemanager.TrustConfig("default",
            name="trust-config",
            description="A sample trust config resource with allowlisted certificates",
            location="global",
            allowlisted_certificates=[
                {
                    "pem_certificate": std.file(input="test-fixtures/cert.pem").result,
                },
                {
                    "pem_certificate": std.file(input="test-fixtures/cert2.pem").result,
                },
            ],
            labels={
                "foo": "bar",
            })
        ```

        ## Import

        TrustConfig can be imported using any of these accepted formats:

        * `projects/{{project}}/locations/{{location}}/trustConfigs/{{name}}`

        * `{{project}}/{{location}}/{{name}}`

        * `{{location}}/{{name}}`

        When using the `pulumi import` command, TrustConfig can be imported using one of the formats above. For example:

        ```sh
        $ pulumi import gcp:certificatemanager/trustConfig:TrustConfig default projects/{{project}}/locations/{{location}}/trustConfigs/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/trustConfig:TrustConfig default {{project}}/{{location}}/{{name}}
        ```

        ```sh
        $ pulumi import gcp:certificatemanager/trustConfig:TrustConfig default {{location}}/{{name}}
        ```

        :param str resource_name: The name of the resource.
        :param TrustConfigArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(TrustConfigArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 allowlisted_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigAllowlistedCertificateArgs', 'TrustConfigAllowlistedCertificateArgsDict']]]]] = None,
                 description: Optional[pulumi.Input[_builtins.str]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 location: Optional[pulumi.Input[_builtins.str]] = None,
                 name: Optional[pulumi.Input[_builtins.str]] = None,
                 project: Optional[pulumi.Input[_builtins.str]] = None,
                 trust_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigTrustStoreArgs', 'TrustConfigTrustStoreArgsDict']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = TrustConfigArgs.__new__(TrustConfigArgs)

            __props__.__dict__["allowlisted_certificates"] = allowlisted_certificates
            __props__.__dict__["description"] = description
            __props__.__dict__["labels"] = labels
            if location is None and not opts.urn:
                raise TypeError("Missing required property 'location'")
            __props__.__dict__["location"] = location
            __props__.__dict__["name"] = name
            __props__.__dict__["project"] = project
            __props__.__dict__["trust_stores"] = trust_stores
            __props__.__dict__["create_time"] = None
            __props__.__dict__["effective_labels"] = None
            __props__.__dict__["pulumi_labels"] = None
            __props__.__dict__["update_time"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["effectiveLabels", "pulumiLabels"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(TrustConfig, __self__).__init__(
            'gcp:certificatemanager/trustConfig:TrustConfig',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            allowlisted_certificates: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigAllowlistedCertificateArgs', 'TrustConfigAllowlistedCertificateArgsDict']]]]] = None,
            create_time: Optional[pulumi.Input[_builtins.str]] = None,
            description: Optional[pulumi.Input[_builtins.str]] = None,
            effective_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            location: Optional[pulumi.Input[_builtins.str]] = None,
            name: Optional[pulumi.Input[_builtins.str]] = None,
            project: Optional[pulumi.Input[_builtins.str]] = None,
            pulumi_labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            trust_stores: Optional[pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigTrustStoreArgs', 'TrustConfigTrustStoreArgsDict']]]]] = None,
            update_time: Optional[pulumi.Input[_builtins.str]] = None) -> 'TrustConfig':
        """
        Get an existing TrustConfig resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigAllowlistedCertificateArgs', 'TrustConfigAllowlistedCertificateArgsDict']]]] allowlisted_certificates: Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
               the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] create_time: The creation timestamp of a TrustConfig.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        :param pulumi.Input[_builtins.str] description: One or more paragraphs of text description of a trust config.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] effective_labels: All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] labels: Set of label tags associated with the trust config.
               **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
               Please refer to the field `effective_labels` for all of the labels present on the resource.
        :param pulumi.Input[_builtins.str] location: The trust config location.
        :param pulumi.Input[_builtins.str] name: A user-defined name of the trust config. Trust config names must be unique globally.
        :param pulumi.Input[_builtins.str] project: The ID of the project in which the resource belongs.
               If it is not provided, the provider project is used.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] pulumi_labels: The combination of labels configured directly on the resource
               and default labels configured on the provider.
        :param pulumi.Input[Sequence[pulumi.Input[Union['TrustConfigTrustStoreArgs', 'TrustConfigTrustStoreArgsDict']]]] trust_stores: Set of trust stores to perform validation against.
               This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
               Structure is documented below.
        :param pulumi.Input[_builtins.str] update_time: The last update timestamp of a TrustConfig.
               A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
               Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _TrustConfigState.__new__(_TrustConfigState)

        __props__.__dict__["allowlisted_certificates"] = allowlisted_certificates
        __props__.__dict__["create_time"] = create_time
        __props__.__dict__["description"] = description
        __props__.__dict__["effective_labels"] = effective_labels
        __props__.__dict__["labels"] = labels
        __props__.__dict__["location"] = location
        __props__.__dict__["name"] = name
        __props__.__dict__["project"] = project
        __props__.__dict__["pulumi_labels"] = pulumi_labels
        __props__.__dict__["trust_stores"] = trust_stores
        __props__.__dict__["update_time"] = update_time
        return TrustConfig(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="allowlistedCertificates")
    def allowlisted_certificates(self) -> pulumi.Output[Optional[Sequence['outputs.TrustConfigAllowlistedCertificate']]]:
        """
        Allowlisted PEM-encoded certificates. A certificate matching an allowlisted certificate is always considered valid as long as
        the certificate is parseable, proof of private key possession is established, and constraints on the certificate's SAN field are met.
        Structure is documented below.
        """
        return pulumi.get(self, "allowlisted_certificates")

    @_builtins.property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[_builtins.str]:
        """
        The creation timestamp of a TrustConfig.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "create_time")

    @_builtins.property
    @pulumi.getter
    def description(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        One or more paragraphs of text description of a trust config.
        """
        return pulumi.get(self, "description")

    @_builtins.property
    @pulumi.getter(name="effectiveLabels")
    def effective_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        All of labels (key/value pairs) present on the resource in GCP, including the labels configured through Pulumi, other clients and services.
        """
        return pulumi.get(self, "effective_labels")

    @_builtins.property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Set of label tags associated with the trust config.
        **Note**: This field is non-authoritative, and will only manage the labels present in your configuration.
        Please refer to the field `effective_labels` for all of the labels present on the resource.
        """
        return pulumi.get(self, "labels")

    @_builtins.property
    @pulumi.getter
    def location(self) -> pulumi.Output[_builtins.str]:
        """
        The trust config location.
        """
        return pulumi.get(self, "location")

    @_builtins.property
    @pulumi.getter
    def name(self) -> pulumi.Output[_builtins.str]:
        """
        A user-defined name of the trust config. Trust config names must be unique globally.
        """
        return pulumi.get(self, "name")

    @_builtins.property
    @pulumi.getter
    def project(self) -> pulumi.Output[_builtins.str]:
        """
        The ID of the project in which the resource belongs.
        If it is not provided, the provider project is used.
        """
        return pulumi.get(self, "project")

    @_builtins.property
    @pulumi.getter(name="pulumiLabels")
    def pulumi_labels(self) -> pulumi.Output[Mapping[str, _builtins.str]]:
        """
        The combination of labels configured directly on the resource
        and default labels configured on the provider.
        """
        return pulumi.get(self, "pulumi_labels")

    @_builtins.property
    @pulumi.getter(name="trustStores")
    def trust_stores(self) -> pulumi.Output[Optional[Sequence['outputs.TrustConfigTrustStore']]]:
        """
        Set of trust stores to perform validation against.
        This field is supported when TrustConfig is configured with Load Balancers, currently not supported for SPIFFE certificate validation.
        Structure is documented below.
        """
        return pulumi.get(self, "trust_stores")

    @_builtins.property
    @pulumi.getter(name="updateTime")
    def update_time(self) -> pulumi.Output[_builtins.str]:
        """
        The last update timestamp of a TrustConfig.
        A timestamp in RFC3339 UTC "Zulu" format, with nanosecond resolution and up to nine fractional digits.
        Examples: "2014-10-02T15:01:23Z" and "2014-10-02T15:01:23.045123456Z".
        """
        return pulumi.get(self, "update_time")

